/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.icao;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jmrtd.Util;
import org.jmrtd.lds.AbstractTaggedLDSFile;
import org.jmrtd.lds.DataGroup;

public class DG15File
extends DataGroup {
    public static final long serialVersionUID = 3834304239673755744L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final String[] PUBLIC_KEY_ALGORITHMS = new String[]{"RSA", "EC"};
    public PublicKey publicKey;

    public DG15File(PublicKey publicKey) {
        super(111);
        this.publicKey = publicKey;
    }

    public DG15File(InputStream inputStream) {
        super(111, inputStream);
    }

    public static PublicKey getPublicKey(byte[] objectArray) {
        X509EncodedKeySpec x509EncodedKeySpec;
        X509EncodedKeySpec x509EncodedKeySpec2 = x509EncodedKeySpec;
        x509EncodedKeySpec = new X509EncodedKeySpec((byte[])objectArray);
        objectArray = PUBLIC_KEY_ALGORITHMS;
        int n2 = PUBLIC_KEY_ALGORITHMS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                return Util.getPublicKey((String)objectArray[i2], x509EncodedKeySpec2);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                LOGGER.log(Level.FINE, "Ignore, try next algorithm", invalidKeySpecException);
                continue;
            }
        }
        throw new InvalidAlgorithmParameterException();
    }

    @Override
    public void readContent(InputStream inputStream) {
        InputStream inputStream2;
        if (inputStream instanceof DataInputStream) {
            inputStream2 = inputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream;
            inputStream2 = dataInputStream;
            dataInputStream = new DataInputStream(inputStream);
        }
        DG15File dG15File = object;
        InputStream inputStream3 = inputStream2;
        byte[] byArray = new byte[((AbstractTaggedLDSFile)object).getLength()];
        Object object = byArray;
        try {
            ((DataInputStream)inputStream3).readFully(byArray);
            dG15File.publicKey = DG15File.getPublicKey((byte[])object);
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOGGER.log(Level.WARNING, "Unexpected exception while reading DG15 content", generalSecurityException);
        }
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        outputStream.write(this.publicKey.getEncoded());
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != DG15File.class) {
            return false;
        }
        DG15File dG15File = dG15File2;
        DG15File dG15File2 = (DG15File)object;
        return dG15File.publicKey.equals(dG15File2.publicKey);
    }

    public int hashCode() {
        return this.publicKey.hashCode() * 5 + 61;
    }

    @Override
    public String toString() {
        return "DG15File [" + Util.getDetailedPublicKeyAlgorithm(this.publicKey) + "]";
    }
}

