/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;
import net.sf.scuba.tlv.TLVUtil;
import org.jmrtd.Util;
import org.jmrtd.protocol.SecureMessagingWrapper;

public class AESSecureMessagingWrapper
extends SecureMessagingWrapper
implements Serializable {
    public static final long serialVersionUID = 2086301081448345496L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public SecretKey ksEnc;
    public SecretKey ksMac;
    public transient Cipher sscIVCipher;
    public transient Cipher cipher;
    public transient Mac mac;
    public long ssc;

    public AESSecureMessagingWrapper(SecretKey secretKey, SecretKey secretKey2, long l2) {
        this(secretKey, secretKey2, 256, true, l2);
    }

    public AESSecureMessagingWrapper(SecretKey secretKey, SecretKey secretKey2, int n2, boolean bl, long l2) {
        AESSecureMessagingWrapper aESSecureMessagingWrapper = this;
        super(n2, bl);
        this.ksEnc = secretKey;
        this.ksMac = secretKey2;
        aESSecureMessagingWrapper.ssc = l2;
        aESSecureMessagingWrapper.sscIVCipher = Util.getCipher("AES/ECB/NoPadding", 1, secretKey);
        aESSecureMessagingWrapper.cipher = Util.getCipher("AES/CBC/NoPadding");
        aESSecureMessagingWrapper.mac = Util.getMac("AESCMAC", secretKey2);
    }

    private CommandAPDU wrapCommandAPDU(CommandAPDU object) {
        ByteArrayOutputStream byteArrayOutputStream;
        CommandAPDU commandAPDU = object;
        int n2 = commandAPDU.getNc();
        int n3 = commandAPDU.getNe();
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)(object.getCLA() | 0xC);
        byArray2[1] = (byte)object.getINS();
        byArray2[2] = (byte)object.getP1();
        byArray[3] = (byte)object.getP2();
        byte[] byArray3 = Util.pad(byArray, 16);
        int n4 = (byte)commandAPDU.getINS() == -79 ? 1 : 0;
        Object object2 = new byte[]{};
        byte[] byArray4 = new byte[]{};
        int n5 = object.getINS();
        if (n3 > 0 && n3 < this.getMaxTranceiveLength() || (byte)n5 == -120) {
            ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream2;
            ByteArrayOutputStream byteArrayOutputStream4 = byteArrayOutputStream2;
            byteArrayOutputStream4.reset();
            byteArrayOutputStream4.write(-105);
            byteArrayOutputStream4.write(1);
            byteArrayOutputStream3.write((byte)n3);
            byArray4 = byteArrayOutputStream3.toByteArray();
        }
        AESSecureMessagingWrapper aESSecureMessagingWrapper = this;
        ++aESSecureMessagingWrapper.ssc;
        byte[] byArray5 = AESSecureMessagingWrapper.getSSCAsBytes(aESSecureMessagingWrapper.ssc);
        if (n2 > 0) {
            AESSecureMessagingWrapper aESSecureMessagingWrapper2 = this;
            object = Util.pad(object.getData(), 16);
            SecretKey secretKey = this.ksEnc;
            object2 = this.getIV(byArray5);
            aESSecureMessagingWrapper2.cipher.init(1, (Key)secretKey, (AlgorithmParameterSpec)object2);
            object = aESSecureMessagingWrapper2.cipher.doFinal((byte[])object);
            byteArrayOutputStream2.reset();
            int n6 = n4 != 0 ? -123 : -121;
            byteArrayOutputStream2.write(n6);
            byteArrayOutputStream2.write(TLVUtil.getLengthAsBytes((int)(((CommandAPDU)object).length + (n4 ^ 1))));
            if (n4 == 0) {
                byteArrayOutputStream2.write(1);
            }
            ByteArrayOutputStream byteArrayOutputStream5 = byteArrayOutputStream2;
            byteArrayOutputStream5.write((byte[])object);
            object2 = byteArrayOutputStream5.toByteArray();
        }
        AESSecureMessagingWrapper aESSecureMessagingWrapper3 = this;
        ByteArrayOutputStream byteArrayOutputStream6 = byteArrayOutputStream2;
        byteArrayOutputStream2.reset();
        byteArrayOutputStream2.write(byArray3);
        byteArrayOutputStream2.write((byte[])object2);
        byteArrayOutputStream6.write(byArray4);
        byte[] byArray6 = byteArrayOutputStream6.toByteArray();
        byteArrayOutputStream2.reset();
        byteArrayOutputStream2.write(byArray5);
        byteArrayOutputStream6.write(byArray6);
        byteArrayOutputStream6.flush();
        object = Util.pad(byteArrayOutputStream6.toByteArray(), 16);
        aESSecureMessagingWrapper3.mac.init(this.ksMac);
        byte[] byArray7 = aESSecureMessagingWrapper3.mac.doFinal((byte[])object);
        object = byArray7;
        int n7 = byArray7.length;
        if (n7 != 8) {
            n7 = 8;
        }
        ByteArrayOutputStream byteArrayOutputStream7 = byteArrayOutputStream2;
        ByteArrayOutputStream byteArrayOutputStream8 = byteArrayOutputStream2;
        byteArrayOutputStream8.reset();
        byteArrayOutputStream8.write(-114);
        byteArrayOutputStream2.write(n7);
        byteArrayOutputStream7.write((byte[])object, 0, n7);
        byte[] byArray8 = byteArrayOutputStream7.toByteArray();
        byteArrayOutputStream2.reset();
        byteArrayOutputStream2.write((byte[])object2);
        byteArrayOutputStream2.write(byArray4);
        byteArrayOutputStream7.write(byArray8);
        object = byteArrayOutputStream7.toByteArray();
        return new CommandAPDU((int)byArray2[0], (int)byArray2[1], (int)byArray2[2], (int)byArray2[3], (byte[])object, this.getMaxTranceiveLength());
    }

    /*
     * Exception decompiling
     */
    private byte[] unwrapResponseAPDU(byte[] var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[CATCHBLOCK], 21[WHILELOOP]], but top level block is 11[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] readDO87(DataInputStream dataInputStream, boolean bl) {
        int n2 = 0;
        int n3 = dataInputStream.readUnsignedByte();
        if ((n3 & 0x80) != 128) {
            if (!bl && (n2 = dataInputStream.readUnsignedByte()) != 1) {
                throw new IllegalStateException("DO'87 expected 0x01 marker, found " + Integer.toHexString(n2 & 0xFF));
            }
            n2 = n3;
        } else {
            n3 &= 0x7F;
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 = n2 << 8 | dataInputStream.readUnsignedByte();
            }
            if (!bl && dataInputStream.readUnsignedByte() != 1) {
                throw new IllegalStateException("DO'87 expected 0x01 marker");
            }
        }
        if (!bl) {
            --n2;
        }
        AESSecureMessagingWrapper aESSecureMessagingWrapper = object;
        byte[] byArray = new byte[n2];
        Object object = byArray;
        dataInputStream.readFully(byArray);
        return Util.unpad(aESSecureMessagingWrapper.cipher.doFinal((byte[])object));
    }

    private short readDO99(DataInputStream dataInputStream) {
        if (dataInputStream.readUnsignedByte() == 2) {
            byte by = dataInputStream.readByte();
            return (short)((dataInputStream.readByte() & 0xFF) << 8 | by & 0xFF);
        }
        throw new IllegalStateException("DO'99 wrong length");
    }

    private byte[] readDO8E(DataInputStream dataInputStream) {
        int n2 = dataInputStream.readUnsignedByte();
        if (n2 != 8 && n2 != 16) {
            throw new IllegalStateException("DO'8E wrong length for MAC: " + n2);
        }
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray);
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkMac(byte[] byArray, byte[] byArray2) {
        DataOutputStream dataOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        AESSecureMessagingWrapper aESSecureMessagingWrapper;
        AESSecureMessagingWrapper aESSecureMessagingWrapper2;
        try {
            AESSecureMessagingWrapper aESSecureMessagingWrapper3 = object;
            aESSecureMessagingWrapper2 = aESSecureMessagingWrapper3;
            aESSecureMessagingWrapper = aESSecureMessagingWrapper3;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception checking MAC", iOException);
            return false;
        }
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = dataOutputStream;
        byte[] byArray3 = byArray;
        dataOutputStream2(byteArrayOutputStream2);
        dataOutputStream2.write(AESSecureMessagingWrapper.getSSCAsBytes(((AESSecureMessagingWrapper)object).ssc));
        int n2 = byArray.length;
        byte[] byArray4 = Util.pad(byArray3, 0, n2 - 2 - 8 - 2, 16);
        dataOutputStream.write(byArray4, 0, byArray4.length);
        dataOutputStream.flush();
        dataOutputStream.close();
        aESSecureMessagingWrapper2.mac.init(((AESSecureMessagingWrapper)object).ksMac);
        byte[] byArray5 = aESSecureMessagingWrapper.mac.doFinal(byteArrayOutputStream2.toByteArray());
        Object object = byArray5;
        if (byArray5.length <= 8) return Arrays.equals(byArray2, (byte[])object);
        if (byArray2.length != 8) return Arrays.equals(byArray2, (byte[])object);
        Object object2 = object;
        object = new byte[8];
        System.arraycopy(object2, 0, object, 0, ((Object)object).length);
        return Arrays.equals(byArray2, (byte[])object);
    }

    private IvParameterSpec getIV(long l2) {
        AESSecureMessagingWrapper aESSecureMessagingWrapper = object;
        Object object = AESSecureMessagingWrapper.getSSCAsBytes(l2);
        object = aESSecureMessagingWrapper.sscIVCipher.doFinal((byte[])object);
        return new IvParameterSpec((byte[])object);
    }

    private IvParameterSpec getIV(byte[] byArray) {
        Object object = ((AESSecureMessagingWrapper)object).sscIVCipher.doFinal(byArray);
        return new IvParameterSpec((byte[])object);
    }

    public static byte[] getSSCAsBytes(long l2) {
        DataOutputStream dataOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        try {
            new ByteArrayOutputStream(16).write(0);
            byteArrayOutputStream2.write(0);
            byteArrayOutputStream2.write(0);
            byteArrayOutputStream2.write(0);
            byteArrayOutputStream2.write(0);
            byteArrayOutputStream2.write(0);
            byteArrayOutputStream2.write(0);
            byteArrayOutputStream2.write(0);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception", iOException);
            return null;
        }
        DataOutputStream dataOutputStream2 = dataOutputStream;
        dataOutputStream2(byteArrayOutputStream2);
        dataOutputStream.writeLong(l2);
        dataOutputStream.close();
        return byteArrayOutputStream2.toByteArray();
    }

    public String getType() {
        return "AES";
    }

    @Override
    public long getSendSequenceCounter() {
        return this.ssc;
    }

    public CommandAPDU wrap(CommandAPDU commandAPDU) {
        try {
            return this.wrapCommandAPDU(commandAPDU);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Exception", iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Exception", generalSecurityException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseAPDU unwrap(ResponseAPDU responseAPDU) {
        byte[] byArray;
        try {
            byArray = responseAPDU.getBytes();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Exception", iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Exception", generalSecurityException);
        }
        {
            if (byArray.length != 2) {
                return new ResponseAPDU(this.unwrapResponseAPDU(byArray));
            }
            throw new IllegalStateException("Card indicates SM error, SW = " + Integer.toHexString(responseAPDU.getSW() & 0xFFFF));
        }
    }

    @Override
    public SecretKey getEncryptionKey() {
        return this.ksEnc;
    }

    @Override
    public SecretKey getMACKey() {
        return this.ksMac;
    }

    public String toString() {
        return "AESSecureMessagingWrapper [ " + this.ksEnc.toString() + ", " + this.ksMac.toString() + ", " + this.ssc + "]";
    }

    public int hashCode() {
        int n2 = 31;
        SecretKey secretKey = this.ksEnc;
        int n3 = secretKey == null ? 0 : secretKey.hashCode();
        n2 = (n2 + n3) * 31;
        SecretKey secretKey2 = this.ksMac;
        int n4 = secretKey2 == null ? 0 : secretKey2.hashCode();
        long l2 = this.ssc;
        return (n2 + n4) * 31 + (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (AESSecureMessagingWrapper.class != object.getClass()) {
            return false;
        }
        object = (AESSecureMessagingWrapper)object;
        SecretKey secretKey = this.ksEnc;
        if (secretKey == null ? ((AESSecureMessagingWrapper)object).ksEnc != null : !secretKey.equals(((AESSecureMessagingWrapper)object).ksEnc)) {
            return false;
        }
        secretKey = this.ksMac;
        if (secretKey == null ? ((AESSecureMessagingWrapper)object).ksMac != null : !secretKey.equals(((AESSecureMessagingWrapper)object).ksMac)) {
            return false;
        }
        return this.ssc == ((AESSecureMessagingWrapper)object).ssc;
    }
}

