/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.nfc.ui.dialog;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import com.dtf.face.nfc.R;
import com.dtf.face.nfc.ui.dialog.BaseBottomDialog;
import com.dtf.face.nfc.ui.widget.wheelpiker.WheelDatePicker;
import com.dtf.face.utils.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DatePickerDialog
extends BaseBottomDialog {
    public WheelDatePicker datePicker;
    private final StringBuilder selecteddateStr = new StringBuilder();
    private final boolean mIsBirthDay;
    private String defaultDate = "";

    public DatePickerDialog(Context context, boolean isBirthDayPicker) {
        super(context, R.layout.dtf_dialog_date_picker);
        this.mContext = context;
        this.mIsBirthDay = isBirthDayPicker;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        View viewCancel;
        super.onCreate(savedInstanceState);
        this.initDatePicker(this.mIsBirthDay);
        View viewSure = this.findViewById(R.id.fl_sure);
        if (null != viewSure) {
            viewSure.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DatePickerDialog.this.createDataString();
                    DatePickerDialog.this.dismiss();
                }
            });
        }
        if (null != (viewCancel = this.findViewById(R.id.fl_cancel))) {
            viewCancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DatePickerDialog.this.selecteddateStr.setLength(0);
                    DatePickerDialog.this.dismiss();
                }
            });
        }
    }

    public void initDatePicker(boolean needCheckEndDate) {
        this.datePicker = this.getDatePicker();
        Calendar cd = Calendar.getInstance();
        if (null != this.datePicker) {
            this.datePicker.setNeedCheckEndDate(needCheckEndDate);
            if (StringUtil.isNullorEmpty((String)this.defaultDate)) {
                this.datePicker.setSelectedYear(cd.get(1));
                this.datePicker.setSelectedMonth((cd.get(2) + 1) % 12);
                this.datePicker.setSelectedDay(cd.get(5));
            } else {
                String[] date = this.defaultDate.split("-");
                if (null != date && date.length > 2) {
                    this.datePicker.setSelectedYear(Integer.parseInt(date[0]));
                    this.datePicker.setSelectedMonth(Integer.parseInt(date[1]));
                    this.datePicker.setSelectedDay(Integer.parseInt(date[2]));
                }
            }
        }
    }

    public void setDetaultDate(String defaultDate) {
        this.defaultDate = defaultDate;
    }

    public WheelDatePicker getDatePicker() {
        if (null == this.datePicker) {
            this.datePicker = (WheelDatePicker)this.findViewById(R.id.date_picker);
        }
        return this.datePicker;
    }

    public boolean createDataString() {
        if (this.mIsBirthDay) {
            try {
                Date dateCurrent = new Date(System.currentTimeMillis());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
                Date dateSelected = sdf.parse(this.datePicker.getCurrentYear() + "-" + this.datePicker.getCurrentMonth() + "-" + this.datePicker.getCurrentDay());
                if (dateSelected.compareTo(dateCurrent) > 0) {
                    this.selecteddateStr.setLength(0);
                    return false;
                }
            }
            catch (ParseException dateCurrent) {
                // empty catch block
            }
        }
        String monthStr = this.format2(this.getDatePicker().getCurrentMonth());
        this.selecteddateStr.setLength(0);
        this.selecteddateStr.append(this.datePicker.getCurrentYear()).append("-").append(monthStr).append("-").append(this.format2(this.getDatePicker().getCurrentDay()));
        return true;
    }

    public String getSelectedDateString() {
        this.initDatePicker(this.mIsBirthDay);
        return this.selecteddateStr.toString();
    }

    public String format2(int num) {
        String str = "";
        str = num < 10 ? "0" + num : Integer.toString(num);
        return str;
    }
}

