/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.nfc.verify;

import android.content.Context;
import android.content.Intent;
import com.dtf.face.ToygerConfig;
import com.dtf.face.config.AndroidDocConfig;
import com.dtf.face.config.Coll;
import com.dtf.face.log.RecordLevel;
import com.dtf.face.log.RecordService;
import com.dtf.face.nfc.NFCConst;
import com.dtf.face.nfc.ui.NfcInfoInputActivity;
import com.dtf.face.nfc.ui.NfcReadActivity;
import com.dtf.face.utils.StringUtil;

public class DTFNfcFacade {
    public static void startNfc(Context context) {
        AndroidDocConfig androidDocConfig = ToygerConfig.getInstance().getAndroidDocConfig();
        if (null == androidDocConfig) {
            return;
        }
        RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "NfCSDKInitializationCompleted", new String[0]);
        Coll coll = androidDocConfig.getColl();
        if (null != coll) {
            String docInputMode = coll.docInputMode;
            NFCConst.REAL_TRY_TIME = 0;
            if (NFCConst.DOC_TYPE_PASSPORT.equals(coll.docType)) {
                if (NFCConst.DOC_INPUT_MODE_MANUAL.equalsIgnoreCase(docInputMode)) {
                    Intent intent = new Intent(context, NfcInfoInputActivity.class);
                    context.startActivity(intent);
                } else if (NFCConst.DOC_INPUT_MODE_TRANS.equalsIgnoreCase(docInputMode)) {
                    AndroidDocConfig.PassportInfo passportInfo = androidDocConfig.getPassportInfo();
                    if (null == passportInfo || StringUtil.isNullorEmpty((String)passportInfo.getPassportNo()) || StringUtil.isNullorEmpty((String)passportInfo.getPassportBirth()) || StringUtil.isNullorEmpty((String)passportInfo.getPassportExpire())) {
                        RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "NFCProtocolRequestFailed", new String[]{"errMsg", "passportInfo=" + (passportInfo == null ? "null" : passportInfo.toString())});
                        ToygerConfig.getInstance().sendResAndExit(context, "Z3004", "");
                        return;
                    }
                    Intent intent = new Intent(context, NfcReadActivity.class);
                    if (null != passportInfo) {
                        intent.putExtra(NFCConst.INTENT_PARAM_KEY_PASSPORTNUM, passportInfo.getPassportNo());
                        intent.putExtra(NFCConst.INTENT_PARAM_KEY_BIRTHDAY, passportInfo.getPassportBirth());
                        intent.putExtra(NFCConst.INTENT_PARAM_KEY_VALIDITY, passportInfo.getPassportExpire());
                    }
                    intent.putExtra(NFCConst.INTENT_PARAM_KEY_DOCTYPE, coll.docType);
                    context.startActivity(intent);
                } else {
                    RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "NFCProtocolRequestFailed", new String[]{"errMsg", "docInputMode", docInputMode == null ? "null" : docInputMode});
                    ToygerConfig.getInstance().sendResAndExit(context, "Z3004", "");
                }
            } else if (NFCConst.DOC_TYPE_ID_CARD.equals(coll.docType)) {
                Intent intent = new Intent(context, NfcReadActivity.class);
                intent.putExtra(NFCConst.INTENT_PARAM_KEY_DOCTYPE, coll.docType);
                context.startActivity(intent);
            } else {
                RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "NFCProtocolRequestFailed", new String[]{"errMsg", "docType=" + coll.docType});
                ToygerConfig.getInstance().sendResAndExit(context, "Z3004", "");
            }
        }
    }
}

