/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.IOException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.AlgorithmUtil;
import org.ejbca.cvc.ByteField;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.CVCertificateBody;
import org.ejbca.cvc.Signable;
import org.ejbca.cvc.exception.ConstructionException;
import org.ejbca.cvc.util.BCECUtil;

public class CVCertificate
extends AbstractSequence
implements Signable {
    public static final long serialVersionUID = 1L;
    public static CVCTagEnum[] allowedFields = new CVCTagEnum[]{CVCTagEnum.CERTIFICATE_BODY, CVCTagEnum.SIGNATURE};

    public CVCertificate() {
        super(CVCTagEnum.CV_CERTIFICATE);
    }

    public CVCertificate(CVCertificateBody cVCertificateBody) {
        this();
        if (cVCertificateBody != null) {
            this.addSubfield(cVCertificateBody);
            return;
        }
        throw new IllegalArgumentException("body is null");
    }

    @Override
    public CVCTagEnum[] getAllowedFields() {
        return allowedFields;
    }

    public void setSignature(byte[] byArray) {
        this.addSubfield(new ByteField(CVCTagEnum.SIGNATURE, byArray));
    }

    public CVCertificateBody getCertificateBody() {
        return (CVCertificateBody)this.getSubfield(CVCTagEnum.CERTIFICATE_BODY);
    }

    public byte[] getSignature() {
        return ((ByteField)this.getSubfield(CVCTagEnum.SIGNATURE)).getData();
    }

    @Override
    public byte[] getTBS() {
        try {
            return this.getCertificateBody().getDEREncoded();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ConstructionException(noSuchFieldException);
        }
        catch (IOException iOException) {
            throw new ConstructionException(iOException);
        }
    }

    public String toString() {
        return this.getAsText("");
    }

    public void verify(PublicKey publicKey, String object) {
        block6: {
            String string = AlgorithmUtil.getAlgorithmName(this.getCertificateBody().getPublicKey().getObjectIdentifier());
            object = Signature.getInstance(string, (String)object);
            ((Signature)object).initVerify(publicKey);
            ((Signature)object).update(this.getTBS());
            if (!((Signature)object).verify(BCECUtil.convertCVCSigToX962(string, this.getSignature()))) break block6;
            return;
        }
        try {
            throw new SignatureException("Signature verification failed!");
        }
        catch (ConstructionException constructionException) {
            throw new CertificateException("CV-Certificate is corrupt", constructionException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new CertificateException("CV-Certificate is corrupt", noSuchFieldException);
        }
    }
}

