/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import org.ejbca.cvc.CVCertificate;

public class CardVerifiableCertificate
extends Certificate {
    public CVCertificate cvc;

    public CardVerifiableCertificate(CVCertificate cVCertificate) {
        super("CVC");
        this.cvc = cVCertificate;
    }

    public CVCertificate getCVCertificate() {
        return this.cvc;
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.cvc.getDEREncoded();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException);
        }
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            return this.cvc.getCertificateBody().getPublicKey();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
            return null;
        }
    }

    @Override
    public void verify(PublicKey publicKey) {
        this.verify(publicKey, "BC");
    }

    @Override
    public void verify(PublicKey publicKey, String string) {
        this.cvc.verify(publicKey, string);
    }

    @Override
    public String toString() {
        return this.cvc.toString();
    }
}

