/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.AuthorizationField;
import org.ejbca.cvc.AuthorizationRole;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.ByteField;
import org.ejbca.cvc.CVCAuthorizationTemplate;
import org.ejbca.cvc.CVCObject;
import org.ejbca.cvc.CVCPublicKey;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.CVCertificateBody;
import org.ejbca.cvc.GenericPublicKeyField;
import org.ejbca.cvc.IntegerField;
import org.ejbca.cvc.OIDField;

public class PublicKeyEC
extends CVCPublicKey
implements ECPublicKey {
    public static final long serialVersionUID = 1L;
    public static final byte UNCOMPRESSED_POINT_TAG = 4;
    public static CVCTagEnum[] allowedFields = new CVCTagEnum[]{CVCTagEnum.OID, CVCTagEnum.MODULUS, CVCTagEnum.COEFFICIENT_A, CVCTagEnum.COEFFICIENT_B, CVCTagEnum.BASE_POINT_G, CVCTagEnum.BASE_POINT_R_ORDER, CVCTagEnum.PUBLIC_POINT_Y, CVCTagEnum.COFACTOR_F};

    public PublicKeyEC(GenericPublicKeyField genericPublicKeyField) {
        this.addSubfield(genericPublicKeyField.getSubfield(CVCTagEnum.OID));
        this.addSubfield(genericPublicKeyField.getOptionalSubfield(CVCTagEnum.MODULUS));
        this.addSubfield(genericPublicKeyField.getOptionalSubfield(CVCTagEnum.COEFFICIENT_A));
        this.addSubfield(genericPublicKeyField.getOptionalSubfield(CVCTagEnum.COEFFICIENT_B));
        this.addSubfield(genericPublicKeyField.getOptionalSubfield(CVCTagEnum.BASE_POINT_G));
        this.addSubfield(genericPublicKeyField.getOptionalSubfield(CVCTagEnum.BASE_POINT_R_ORDER));
        this.addSubfield(genericPublicKeyField.getSubfield(CVCTagEnum.PUBLIC_POINT_Y));
        this.addSubfield(genericPublicKeyField.getOptionalSubfield(CVCTagEnum.COFACTOR_F));
    }

    public PublicKeyEC(OIDField object, ECPublicKey eCPublicKey, AuthorizationRole authorizationRole) {
        this.addSubfield((CVCObject)object);
        object = eCPublicKey.getParams();
        boolean bl = authorizationRole == null || authorizationRole.isCVCA();
        if (bl) {
            ECField eCField = ((ECParameterSpec)object).getCurve().getField();
            if (eCField instanceof ECFieldFp) {
                eCField = (ECFieldFp)eCField;
                this.addSubfield(new ByteField(CVCTagEnum.MODULUS, CVCObject.trimByteArray(((ECFieldFp)eCField).getP().toByteArray())));
            }
            PublicKeyEC publicKeyEC = this;
            publicKeyEC.addSubfield(new ByteField(CVCTagEnum.COEFFICIENT_A, CVCObject.trimByteArray(((ECParameterSpec)object).getCurve().getA().toByteArray())));
            publicKeyEC.addSubfield(new ByteField(CVCTagEnum.COEFFICIENT_B, CVCObject.trimByteArray(((ECParameterSpec)object).getCurve().getB().toByteArray())));
            publicKeyEC.addSubfield(new ByteField(CVCTagEnum.BASE_POINT_G, PublicKeyEC.encodePoint(((ECParameterSpec)object).getGenerator(), ((ECParameterSpec)object).getCurve())));
            publicKeyEC.addSubfield(new ByteField(CVCTagEnum.BASE_POINT_R_ORDER, CVCObject.trimByteArray(((ECParameterSpec)object).getOrder().toByteArray())));
        }
        this.addSubfield(new ByteField(CVCTagEnum.PUBLIC_POINT_Y, PublicKeyEC.encodePoint(eCPublicKey.getW(), ((ECParameterSpec)object).getCurve())));
        if (bl) {
            this.addSubfield(new IntegerField(CVCTagEnum.COFACTOR_F, ((ECParameterSpec)object).getCofactor()));
        }
    }

    public PublicKeyEC(OIDField oIDField, ECPublicKey eCPublicKey, AuthorizationRoleEnum authorizationRoleEnum) {
        this(oIDField, eCPublicKey, (AuthorizationRole)authorizationRoleEnum);
    }

    public static byte[] encodePoint(ECPoint object, EllipticCurve ellipticCurve) {
        ECPoint eCPoint = object;
        object = CVCObject.trimByteArray(eCPoint.getAffineX().toByteArray());
        byte[] byArray = CVCObject.trimByteArray(eCPoint.getAffineY().toByteArray());
        int n2 = ellipticCurve != null ? ellipticCurve.getField().getFieldSize() + 7 >> 3 : (((Object)object).length <= byArray.length ? byArray.length : ((Object)object).length);
        int n3 = 0;
        int n4 = 0;
        if (((Object)object).length < n2) {
            n3 = n2 - ((Object)object).length;
        }
        if (byArray.length < n2) {
            n4 = n2 - byArray.length;
        }
        byte[] byArray2 = new byte[(n2 << 1) + 1];
        int n5 = n2;
        int n6 = n2;
        Arrays.fill(byArray2, (byte)0);
        byArray2[0] = 4;
        int n7 = n3 + 1;
        System.arraycopy(object, 0, byArray2, n7, n2 -= n3);
        n7 = n6 + 1 + n4;
        n2 = n5 - n4;
        System.arraycopy(byArray, 0, byArray2, n7, n2);
        return byArray2;
    }

    public static ECPoint decodePoint(byte[] byArray) {
        if (byArray[0] == 4) {
            byte[] byArray2 = byArray;
            byte[] byArray3 = new byte[(byArray2.length - 1) / 2];
            byArray = new byte[(byArray.length - 1) / 2];
            int n2 = byArray3.length;
            System.arraycopy(byArray2, 1, byArray3, 0, n2);
            System.arraycopy(byArray, byArray3.length + 1, byArray, 0, byArray.length);
            return new ECPoint(new BigInteger(1, byArray3), new BigInteger(1, byArray));
        }
        throw new IllegalArgumentException("First byte must be 0x4");
    }

    @Override
    public CVCTagEnum[] getAllowedFields() {
        return allowedFields;
    }

    public List getEncodableFields() {
        boolean bl;
        ECParameterSpec eCParameterSpec;
        boolean bl2;
        ArrayList<CVCObject> arrayList;
        block24: {
            block26: {
                CVCObject cVCObject;
                block25: {
                    block27: {
                        ArrayList<CVCObject> arrayList2;
                        PublicKeyEC publicKeyEC = this;
                        arrayList = arrayList2;
                        arrayList();
                        arrayList2.add(this.getSubfield(CVCTagEnum.OID));
                        bl2 = false;
                        eCParameterSpec = publicKeyEC.getParams();
                        if (eCParameterSpec == null) break block24;
                        cVCObject = this.getParent();
                        if (cVCObject == null) break block25;
                        if (cVCObject.getTag() != CVCTagEnum.CERTIFICATE_BODY) break block25;
                        try {
                            cVCObject = ((CVCertificateBody)cVCObject).getOptionalSubfield(CVCTagEnum.HOLDER_AUTH_TEMPLATE);
                            if (cVCObject == null) break block26;
                        }
                        catch (NoSuchFieldException noSuchFieldException) {}
                        cVCObject = ((CVCAuthorizationTemplate)cVCObject).getAuthorizationField();
                        if (cVCObject == null) break block27;
                        if (((AuthorizationField)cVCObject).getAuthRole().isCVCA()) break block26;
                    }
                    bl2 = false;
                    break block24;
                }
                if (cVCObject != null) break block24;
            }
            bl2 = true;
        }
        if (bl2) {
            block28: {
                if (!(eCParameterSpec.getCurve().getField() instanceof ECFieldFp)) break block28;
                arrayList.add(this.getSubfield(CVCTagEnum.MODULUS));
            }
            ArrayList<CVCObject> arrayList3 = arrayList;
            PublicKeyEC publicKeyEC = this;
            ArrayList<CVCObject> arrayList4 = arrayList;
            PublicKeyEC publicKeyEC2 = this;
            ArrayList<CVCObject> arrayList5 = arrayList;
            PublicKeyEC publicKeyEC3 = this;
            arrayList.add(this.getSubfield(CVCTagEnum.COEFFICIENT_A));
            arrayList5.add(publicKeyEC3.getSubfield(CVCTagEnum.COEFFICIENT_B));
            arrayList4.add(publicKeyEC2.getSubfield(CVCTagEnum.BASE_POINT_G));
            arrayList3.add(publicKeyEC.getSubfield(CVCTagEnum.BASE_POINT_R_ORDER));
        }
        try {
            bl = bl2;
            arrayList.add(this.getSubfield(CVCTagEnum.PUBLIC_POINT_Y));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException(noSuchFieldException);
        }
        if (bl) {
            arrayList.add(this.getSubfield(CVCTagEnum.COFACTOR_F));
        }
        return arrayList;
    }

    @Override
    public String getAlgorithm() {
        return "ECDSA";
    }

    @Override
    public String getFormat() {
        return "CVC";
    }

    @Override
    public ECParameterSpec getParams() {
        EllipticCurve ellipticCurve = null;
        ByteField byteField = (ByteField)((AbstractSequence)object).getOptionalSubfield(CVCTagEnum.MODULUS);
        PublicKeyEC publicKeyEC = object;
        Object object = (ByteField)publicKeyEC.getOptionalSubfield(CVCTagEnum.COEFFICIENT_A);
        ByteField byteField2 = (ByteField)publicKeyEC.getOptionalSubfield(CVCTagEnum.COEFFICIENT_B);
        ByteField cfr_ignored_0 = (ByteField)publicKeyEC.getOptionalSubfield(CVCTagEnum.BASE_POINT_G);
        ByteField byteField3 = (ByteField)publicKeyEC.getOptionalSubfield(CVCTagEnum.BASE_POINT_R_ORDER);
        IntegerField integerField = (IntegerField)publicKeyEC.getOptionalSubfield(CVCTagEnum.COFACTOR_F);
        if (byteField != null) {
            ECParameterSpec eCParameterSpec;
            EllipticCurve ellipticCurve2;
            ellipticCurve = ellipticCurve2;
            ellipticCurve2 = new EllipticCurve(new ECFieldFp(new BigInteger(1, byteField.getData())), new BigInteger(1, ((ByteField)object).getData()), new BigInteger(1, byteField2.getData()));
            object = eCParameterSpec;
            eCParameterSpec = new ECParameterSpec(ellipticCurve, new ECPoint(BigInteger.ONE, BigInteger.TEN), new BigInteger(1, byteField3.getData()), integerField.getValue());
        } else {
            object = ellipticCurve;
        }
        return object;
    }

    @Override
    public ECPoint getW() {
        try {
            return PublicKeyEC.decodePoint(((ByteField)this.getSubfield(CVCTagEnum.PUBLIC_POINT_Y)).getData());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException(noSuchFieldException);
        }
    }
}

