/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eid_bc.bouncycastle.asn1.ASN1Encodable;
import org.eid_bc.bouncycastle.asn1.ASN1EncodableVector;
import org.eid_bc.bouncycastle.asn1.ASN1Integer;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.asn1.ASN1Primitive;
import org.eid_bc.bouncycastle.asn1.DLSequence;
import org.jmrtd.lds.SecurityInfo;

public class ChipAuthenticationInfo
extends SecurityInfo {
    public static final long serialVersionUID = 5591988305059068535L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public String oid;
    public int version;
    public BigInteger keyId;

    public ChipAuthenticationInfo(String string, int n2) {
        this(string, n2, null);
    }

    public ChipAuthenticationInfo(String string, int n2, BigInteger bigInteger) {
        this.oid = string;
        this.version = n2;
        this.keyId = bigInteger;
        this.checkFields();
    }

    public static boolean checkRequiredIdentifier(String string) {
        return SecurityInfo.ID_CA_DH_3DES_CBC_CBC.equals(string) || SecurityInfo.ID_CA_ECDH_3DES_CBC_CBC.equals(string) || "0.4.0.127.0.7.2.2.3.1.2".equals(string) || "0.4.0.127.0.7.2.2.3.1.3".equals(string) || "0.4.0.127.0.7.2.2.3.1.4".equals(string) || "0.4.0.127.0.7.2.2.3.2.2".equals(string) || "0.4.0.127.0.7.2.2.3.2.3".equals(string) || "0.4.0.127.0.7.2.2.3.2.4".equals(string);
    }

    public static String toKeyAgreementAlgorithm(String string) {
        if (string != null) {
            if (!(SecurityInfo.ID_CA_DH_3DES_CBC_CBC.equals(string) || "0.4.0.127.0.7.2.2.3.1.2".equals(string) || "0.4.0.127.0.7.2.2.3.1.3".equals(string) || "0.4.0.127.0.7.2.2.3.1.4".equals(string))) {
                if (!(SecurityInfo.ID_CA_ECDH_3DES_CBC_CBC.equals(string) || "0.4.0.127.0.7.2.2.3.2.2".equals(string) || "0.4.0.127.0.7.2.2.3.2.3".equals(string) || "0.4.0.127.0.7.2.2.3.2.4".equals(string))) {
                    throw new NumberFormatException("Unknown OID: \"" + string + "\"");
                }
                return "ECDH";
            }
            return "DH";
        }
        throw new NumberFormatException("Unknown OID: null");
    }

    public static String toCipherAlgorithm(String string) {
        if (!SecurityInfo.ID_CA_DH_3DES_CBC_CBC.equals(string) && !SecurityInfo.ID_CA_ECDH_3DES_CBC_CBC.equals(string)) {
            if (!("0.4.0.127.0.7.2.2.3.1.2".equals(string) || "0.4.0.127.0.7.2.2.3.1.3".equals(string) || "0.4.0.127.0.7.2.2.3.1.4".equals(string) || "0.4.0.127.0.7.2.2.3.2.2".equals(string) || "0.4.0.127.0.7.2.2.3.2.3".equals(string) || "0.4.0.127.0.7.2.2.3.2.4".equals(string))) {
                throw new NumberFormatException("Unknown OID: \"" + string + "\"");
            }
            return "AES";
        }
        return "DESede";
    }

    public static String toDigestAlgorithm(String string) {
        if (!(SecurityInfo.ID_CA_DH_3DES_CBC_CBC.equals(string) || SecurityInfo.ID_CA_ECDH_3DES_CBC_CBC.equals(string) || "0.4.0.127.0.7.2.2.3.1.2".equals(string) || "0.4.0.127.0.7.2.2.3.2.2".equals(string))) {
            if (!("0.4.0.127.0.7.2.2.3.1.3".equals(string) || "0.4.0.127.0.7.2.2.3.2.3".equals(string) || "0.4.0.127.0.7.2.2.3.1.4".equals(string) || "0.4.0.127.0.7.2.2.3.2.4".equals(string))) {
                throw new NumberFormatException("Unknown OID: \"" + string + "\"");
            }
            return "SHA-256";
        }
        return "SHA-1";
    }

    public static int toKeyLength(String string) {
        if (!(SecurityInfo.ID_CA_DH_3DES_CBC_CBC.equals(string) || SecurityInfo.ID_CA_ECDH_3DES_CBC_CBC.equals(string) || "0.4.0.127.0.7.2.2.3.1.2".equals(string) || "0.4.0.127.0.7.2.2.3.2.2".equals(string))) {
            if (!"0.4.0.127.0.7.2.2.3.1.3".equals(string) && !"0.4.0.127.0.7.2.2.3.2.3".equals(string)) {
                if (!"0.4.0.127.0.7.2.2.3.1.4".equals(string) && !"0.4.0.127.0.7.2.2.3.2.4".equals(string)) {
                    throw new NumberFormatException("Unknown OID: \"" + string + "\"");
                }
                return 256;
            }
            return 192;
        }
        return 128;
    }

    public static String toProtocolOIDString(String string) {
        if (SecurityInfo.ID_CA_DH_3DES_CBC_CBC.equals(string)) {
            string = "id-CA-DH-3DES-CBC-CBC";
        } else if ("0.4.0.127.0.7.2.2.3.1.2".equals(string)) {
            string = "id-CA-DH-AES-CBC-CMAC-128";
        } else if ("0.4.0.127.0.7.2.2.3.1.3".equals(string)) {
            string = "id-CA-DH-AES-CBC-CMAC-192";
        } else if ("0.4.0.127.0.7.2.2.3.1.4".equals(string)) {
            string = "id-CA-DH-AES-CBC-CMAC-256";
        } else if (SecurityInfo.ID_CA_ECDH_3DES_CBC_CBC.equals(string)) {
            string = "id-CA-ECDH-3DES-CBC-CBC";
        } else if ("0.4.0.127.0.7.2.2.3.2.2".equals(string)) {
            string = "id-CA-ECDH-AES-CBC-CMAC-128";
        } else if ("0.4.0.127.0.7.2.2.3.2.3".equals(string)) {
            string = "id-CA-ECDH-AES-CBC-CMAC-192";
        } else if ("0.4.0.127.0.7.2.2.3.2.4".equals(string)) {
            string = "id-CA-ECDH-AES-CBC-CMAC-256";
        }
        return string;
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector().add((ASN1Encodable)new ASN1ObjectIdentifier(serializable.oid));
        aSN1EncodableVector2.add((ASN1Encodable)new ASN1Integer((long)serializable.version));
        Serializable serializable = serializable.keyId;
        if (serializable != null) {
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1Integer((BigInteger)serializable));
        }
        return new DLSequence(aSN1EncodableVector2);
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public String getProtocolOIDString() {
        return ChipAuthenticationInfo.toProtocolOIDString(this.oid);
    }

    public BigInteger getKeyId() {
        return this.keyId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkFields() {
        try {
            if (!ChipAuthenticationInfo.checkRequiredIdentifier(this.oid)) throw new IllegalArgumentException("Wrong identifier: " + this.oid);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Unexpected exception", exception);
            throw new IllegalArgumentException("Malformed ChipAuthenticationInfo.");
        }
        if (this.version == 1) return;
        if (this.version == 2) return;
        throw new IllegalArgumentException("Wrong version. Was expecting 1 or 2, found " + this.version);
    }

    public String toString() {
        ChipAuthenticationInfo chipAuthenticationInfo = serializable;
        Serializable serializable = new StringBuilder().append("ChipAuthenticationInfo [protocol: ").append(ChipAuthenticationInfo.toProtocolOIDString(((ChipAuthenticationInfo)serializable).oid)).append(", version: ").append(((ChipAuthenticationInfo)serializable).version).append(", keyId: ");
        Object object = chipAuthenticationInfo.keyId;
        if (object == null) {
            object = "-";
        }
        return ((StringBuilder)serializable).append(object).append("]").toString();
    }

    public int hashCode() {
        int n2 = 3;
        int n3 = 11;
        String string = this.oid;
        int n4 = (string == null ? 0 : string.hashCode()) * n3 + n2 + this.version * 61;
        n2 = 1991;
        BigInteger bigInteger = this.keyId;
        return n4 + (bigInteger == null ? 111 : bigInteger.hashCode()) * n2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!ChipAuthenticationInfo.class.equals(object.getClass())) {
            return false;
        }
        object = (ChipAuthenticationInfo)object;
        return ((ChipAuthenticationInfo)this).oid.equals(((ChipAuthenticationInfo)object).oid) && ((ChipAuthenticationInfo)this).version == ((ChipAuthenticationInfo)object).version && (((ChipAuthenticationInfo)this).keyId == null && ((ChipAuthenticationInfo)object).keyId == null || (this = ((ChipAuthenticationInfo)this).keyId) != null && ((BigInteger)this).equals(((ChipAuthenticationInfo)object).keyId));
    }
}

