/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import org.eid_bc.bouncycastle.asn1.ASN1Encodable;
import org.eid_bc.bouncycastle.asn1.ASN1EncodableVector;
import org.eid_bc.bouncycastle.asn1.ASN1Integer;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.asn1.ASN1Primitive;
import org.eid_bc.bouncycastle.asn1.ASN1Sequence;
import org.eid_bc.bouncycastle.asn1.DEROctetString;
import org.eid_bc.bouncycastle.asn1.DLSequence;
import org.jmrtd.lds.SecurityInfo;

public class TerminalAuthenticationInfo
extends SecurityInfo {
    public static final long serialVersionUID = 6220506985707094044L;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public String oid;
    public int version;
    public transient ASN1Sequence efCVCA;

    public TerminalAuthenticationInfo(String string, int n2, ASN1Sequence aSN1Sequence) {
        this.oid = string;
        this.version = n2;
        this.efCVCA = aSN1Sequence;
        this.checkFields();
    }

    public TerminalAuthenticationInfo(String string, int n2) {
        this(string, n2, null);
    }

    public TerminalAuthenticationInfo() {
        this(SecurityInfo.ID_TA, 1);
    }

    public TerminalAuthenticationInfo(short s2, byte by) {
        this(SecurityInfo.ID_TA, 1, TerminalAuthenticationInfo.constructEFCVCA(s2, by));
    }

    public static boolean checkRequiredIdentifier(String string) {
        return SecurityInfo.ID_TA.equals(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkFields() {
        try {
            if (!TerminalAuthenticationInfo.checkRequiredIdentifier(this.oid)) throw new IllegalArgumentException("Wrong identifier: " + this.oid);
            if (this.version != 1) {
                if (this.version != 2) throw new IllegalArgumentException("Wrong version. Was expecting 1 or 2, found " + this.version);
            }
            if (this.efCVCA == null) return;
            if (((DEROctetString)this.efCVCA.getObjectAt(0)).getOctets().length != 2) throw new IllegalArgumentException("Malformed FID.");
            if (this.efCVCA.size() != 2) return;
            if (((DEROctetString)this.efCVCA.getObjectAt(1)).getOctets().length != 1) throw new IllegalArgumentException("Malformed SFI.");
            return;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Malformed TerminalAuthenticationInfo", exception);
        }
    }

    public static ASN1Sequence constructEFCVCA(short s2, byte by) {
        DLSequence dLSequence;
        if (by != -1) {
            DEROctetString dEROctetString;
            DEROctetString dEROctetString2;
            DLSequence dLSequence2;
            dLSequence = dLSequence2;
            ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[2];
            DEROctetString dEROctetString3 = dEROctetString2;
            dEROctetString2 = new DEROctetString(new byte[]{(byte)((s2 & 0xFF00) >> 8), (byte)(s2 & 0xFF)});
            aSN1EncodableArray[0] = dEROctetString3;
            DEROctetString dEROctetString4 = dEROctetString;
            dEROctetString = new DEROctetString(new byte[]{(byte)(by & 0xFF)});
            aSN1EncodableArray[1] = dEROctetString4;
            dLSequence2 = new DLSequence(aSN1EncodableArray);
        } else {
            DEROctetString dEROctetString;
            DLSequence dLSequence3;
            dLSequence = dLSequence3;
            ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[1];
            DEROctetString dEROctetString5 = dEROctetString;
            dEROctetString = new DEROctetString(new byte[]{(byte)((s2 & 0xFF00) >> 8), (byte)(s2 & 0xFF)});
            aSN1EncodableArray[0] = dEROctetString5;
            dLSequence3 = new DLSequence(aSN1EncodableArray);
        }
        return dLSequence;
    }

    public static short getFID(ASN1Sequence object) {
        if (object == null) {
            return -1;
        }
        byte[] byArray = ((DEROctetString)object.getObjectAt(0)).getOctets();
        object = byArray;
        return (short)((byArray[0] & 0xFF) << 8 | object[1] & 0xFF);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte getSFI(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence == null) return -1;
        if (aSN1Sequence.size() != 2) return -1;
        byte by = ((DEROctetString)aSN1Sequence.getObjectAt(1)).getOctets()[0];
        return by;
    }

    private String toProtocolOIDString(String string) {
        if (SecurityInfo.ID_TA.equals(string)) {
            string = "id-TA";
        } else if (SecurityInfo.ID_TA_RSA.equals(string)) {
            string = "id-TA-RSA";
        } else if (SecurityInfo.ID_TA_RSA_V1_5_SHA_1.equals(string)) {
            string = "id-TA-RSA-v1-5-SHA-1";
        } else if (SecurityInfo.ID_TA_RSA_V1_5_SHA_256.equals(string)) {
            string = "id-TA-RSA-v1-5-SHA-256";
        } else if (SecurityInfo.ID_TA_RSA_PSS_SHA_1.equals(string)) {
            string = "id-TA-RSA-PSS-SHA-1";
        } else if (SecurityInfo.ID_TA_RSA_PSS_SHA_256.equals(string)) {
            string = "id-TA-RSA-PSS-SHA-256";
        } else if (SecurityInfo.ID_TA_ECDSA.equals(string)) {
            string = "id-TA-ECDSA";
        } else if (SecurityInfo.ID_TA_ECDSA_SHA_1.equals(string)) {
            string = "id-TA-ECDSA-SHA-1";
        } else if (SecurityInfo.ID_TA_ECDSA_SHA_224.equals(string)) {
            string = "id-TA-ECDSA-SHA-224";
        } else if (SecurityInfo.ID_TA_ECDSA_SHA_256.equals(string)) {
            string = "id-TA-ECDSA-SHA-256";
        }
        return string;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector().add((ASN1Encodable)new ASN1ObjectIdentifier(terminalAuthenticationInfo.oid));
        aSN1EncodableVector2.add((ASN1Encodable)new ASN1Integer((long)terminalAuthenticationInfo.version));
        TerminalAuthenticationInfo terminalAuthenticationInfo = terminalAuthenticationInfo.efCVCA;
        if (terminalAuthenticationInfo != null) {
            aSN1EncodableVector2.add((ASN1Encodable)terminalAuthenticationInfo);
        }
        return new DLSequence(aSN1EncodableVector2);
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    @Override
    public String getProtocolOIDString() {
        TerminalAuthenticationInfo terminalAuthenticationInfo = this;
        return terminalAuthenticationInfo.toProtocolOIDString(terminalAuthenticationInfo.oid);
    }

    public int getFileId() {
        return TerminalAuthenticationInfo.getFID(this.efCVCA);
    }

    public byte getShortFileId() {
        return TerminalAuthenticationInfo.getSFI(this.efCVCA);
    }

    public String toString() {
        TerminalAuthenticationInfo terminalAuthenticationInfo = this;
        return "TerminalAuthenticationInfo [protocol: " + terminalAuthenticationInfo.toProtocolOIDString(terminalAuthenticationInfo.oid) + ", version: " + this.version + ", fileID: " + this.getFileId() + ", shortFileID: " + this.getShortFileId() + "]";
    }

    public int hashCode() {
        int n2 = 123;
        int n3 = 7;
        String string = this.oid;
        int n4 = (string == null ? 0 : string.hashCode()) * n3 + n2 + this.version * 5;
        n2 = 3;
        ASN1Sequence aSN1Sequence = this.efCVCA;
        return n4 + (aSN1Sequence == null ? 1 : aSN1Sequence.hashCode()) * n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!TerminalAuthenticationInfo.class.equals(object.getClass())) {
            return false;
        }
        object = (TerminalAuthenticationInfo)object;
        if (this.efCVCA == null) {
            if (((TerminalAuthenticationInfo)object).efCVCA != null) return false;
        }
        if (this.efCVCA != null && ((TerminalAuthenticationInfo)object).efCVCA == null) {
            return false;
        }
        boolean bl = this.getDERObject().equals((Object)((TerminalAuthenticationInfo)object).getDERObject());
        return bl;
    }
}

