/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import net.sf.scuba.smartcards.CardServiceException;
import org.jmrtd.APDULevelBACCapable;
import org.jmrtd.AccessKeySpec;
import org.jmrtd.BACKeySpec;
import org.jmrtd.Util;
import org.jmrtd.protocol.BACResult;
import org.jmrtd.protocol.DESedeSecureMessagingWrapper;
import org.jmrtd.protocol.SecureMessagingWrapper;

public class BACProtocol {
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public APDULevelBACCapable service;
    public Random random;
    public int maxTranceiveLength;
    public boolean shouldCheckMAC;

    public BACProtocol(APDULevelBACCapable aPDULevelBACCapable, int n2, boolean bl) {
        BACProtocol bACProtocol = this;
        this.service = aPDULevelBACCapable;
        this.maxTranceiveLength = n2;
        bACProtocol.shouldCheckMAC = bl;
        bACProtocol.random = new SecureRandom();
    }

    private SecureMessagingWrapper doBACStep(SecretKey object, SecretKey object2) {
        BACProtocol bACProtocol = this;
        byte[] byArray = bACProtocol.service.sendGetChallenge();
        byte[] byArray2 = new byte[8];
        bACProtocol.random.nextBytes(byArray2);
        byte[] byArray3 = new byte[16];
        bACProtocol.random.nextBytes(byArray3);
        byte[] byArray4 = bACProtocol.service.sendMutualAuth(byArray2, byArray, byArray3, (SecretKey)object, (SecretKey)object2);
        object = new byte[16];
        System.arraycopy(byArray4, 16, object, 0, 16);
        object2 = new byte[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            object2[i2] = (byte)(byArray3[i2] & 0xFF ^ object[i2] & 0xFF);
        }
        Object object3 = object2;
        object = Util.deriveKey((byte[])object3, 1);
        object2 = Util.deriveKey((byte[])object3, 2);
        long l2 = BACProtocol.computeSendSequenceCounter(byArray, byArray2);
        return new DESedeSecureMessagingWrapper((SecretKey)object, (SecretKey)object2, this.maxTranceiveLength, this.shouldCheckMAC, l2);
    }

    public static byte[] computeKeySeedForBAC(BACKeySpec object) {
        BACKeySpec bACKeySpec = object;
        String string = bACKeySpec.getDocumentNumber();
        String string2 = bACKeySpec.getDateOfBirth();
        object = object.getDateOfExpiry();
        if (string2 != null && string2.length() == 6) {
            if (object != null && ((String)object).length() == 6) {
                if (string != null) {
                    return BACProtocol.computeKeySeedForBAC(BACProtocol.fixDocumentNumber(string), string2, (String)object);
                }
                throw new IllegalArgumentException("Wrong document number. Found " + string);
            }
            throw new IllegalArgumentException("Wrong date format used for date of expiry. Expected yyMMdd, found " + (String)object);
        }
        throw new IllegalArgumentException("Wrong date format used for date of birth. Expected yyMMdd, found " + string2);
    }

    public static long computeSendSequenceCounter(byte[] byArray, byte[] byArray2) {
        if (byArray != null && byArray.length == 8 && byArray2 != null && byArray2.length == 8) {
            long l2 = 0L;
            for (int i2 = 4; i2 < 8; ++i2) {
                l2 = (l2 << 8) + (long)(byArray[i2] & 0xFF);
            }
            for (int i3 = 4; i3 < 8; ++i3) {
                l2 = (l2 << 8) + (long)(byArray2[i3] & 0xFF);
            }
            return l2;
        }
        throw new IllegalStateException("Wrong length input");
    }

    public static byte[] computeKeySeedForBAC(String string, String string2, String string3) {
        return Util.computeKeySeed(string, string2, string3, "SHA-1", true);
    }

    public static String fixDocumentNumber(String string) {
        string = string == null ? "" : string.replace('<', ' ').trim().replace(' ', '<');
        StringBuilder stringBuilder = new StringBuilder(string);
        while (stringBuilder.length() < 9) {
            stringBuilder.append('<');
        }
        return stringBuilder.toString();
    }

    public BACResult doBAC(AccessKeySpec accessKeySpec) {
        BACProtocol bACProtocol = object;
        byte[] byArray = accessKeySpec.getKey();
        Object object = byArray;
        object = bACProtocol.doBACStep(Util.deriveKey(byArray, 1), Util.deriveKey((byte[])object, 2));
        try {
            return new BACResult(accessKeySpec, (SecureMessagingWrapper)object);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CardServiceException("Error during BAC", (Throwable)generalSecurityException);
        }
        catch (CardServiceException cardServiceException) {
            LOGGER.log(Level.WARNING, "BAC failed", cardServiceException);
            throw cardServiceException;
        }
    }

    public BACResult doBAC(SecretKey secretKey, SecretKey secretKey2) {
        return new BACResult(this.doBACStep(secretKey, secretKey2));
    }
}

