/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.tlv.TLVUtil;
import org.jmrtd.APDULevelPACECapable;
import org.jmrtd.Util;
import org.jmrtd.protocol.SecureMessagingAPDUSender;

public class PACEAPDUSender
implements APDULevelPACECapable {
    public static final byte NO_PACE_KEY_REFERENCE = 0;
    public static final byte MRZ_PACE_KEY_REFERENCE = 1;
    public static final byte CAN_PACE_KEY_REFERENCE = 2;
    public static final byte PIN_PACE_KEY_REFERENCE = 3;
    public static final byte PUK_PACE_KEY_REFERENCE = 4;
    public static final byte INS_PACE_GENERAL_AUTHENTICATE = -122;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd.protocol");
    public SecureMessagingAPDUSender secureMessagingSender;

    public PACEAPDUSender(CardService cardService) {
        this.secureMessagingSender = new SecureMessagingAPDUSender(cardService);
    }

    @Override
    public synchronized void sendMSESetATMutualAuth(APDUWrapper aPDUWrapper, String object, int n2, byte[] byArray) {
        if (object != null) {
            CommandAPDU commandAPDU;
            Object object2;
            block7: {
                ByteArrayOutputStream byteArrayOutputStream;
                object = Util.toOIDBytes((String)object);
                if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
                    throw new IllegalArgumentException("Unsupported key type reference (MRZ, CAN, etc), found " + n2);
                }
                byte[] byArray2 = new byte[1];
                object2 = byArray2;
                byArray2[0] = (byte)n2;
                byte[] byArray3 = TLVUtil.wrapDO((int)131, (byte[])object2);
                if (byArray != null) {
                    byArray = TLVUtil.wrapDO((int)132, (byte[])byArray);
                }
                object2 = byteArrayOutputStream;
                ((ByteArrayOutputStream)object2)();
                try {
                    ((OutputStream)object2).write((byte[])object);
                    byteArrayOutputStream.write(byArray3);
                    if (byArray == null) break block7;
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, "Error while copying data", iOException);
                    throw new IllegalStateException("Error while copying data");
                }
                ((OutputStream)object2).write(byArray);
            }
            PACEAPDUSender pACEAPDUSender = object3;
            Object object3 = ((ByteArrayOutputStream)object2).toByteArray();
            object = commandAPDU;
            commandAPDU = new CommandAPDU(0, 34, 193, 164, (byte[])object3);
            short s2 = (short)pACEAPDUSender.secureMessagingSender.transmit(aPDUWrapper, (CommandAPDU)object).getSW();
            if (s2 == -28672) {
                return;
            }
            throw new CardServiceException("Sending MSE AT failed", (int)s2);
        }
        throw new IllegalArgumentException("OID cannot be null");
    }

    @Override
    public synchronized byte[] sendGeneralAuthenticate(APDUWrapper aPDUWrapper, byte[] byArray, boolean bl) {
        int n2 = bl ? 0 : 16;
        CommandAPDU commandAPDU = new CommandAPDU(n2, -122, 0, 0, byArray = TLVUtil.wrapDO((int)124, (byte[])byArray), 256);
        PACEAPDUSender pACEAPDUSender = pACEAPDUSender.secureMessagingSender.transmit(aPDUWrapper, commandAPDU);
        short s2 = (short)pACEAPDUSender.getSW();
        if (s2 == -28672) {
            return TLVUtil.unwrapDO((int)124, (byte[])pACEAPDUSender.getData());
        }
        throw new CardServiceException("Sending general authenticate failed", (int)s2);
    }
}

