/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.nfc;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.nfc.NfcAdapter;
import android.nfc.tech.NfcB;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.dtf.face.log.RecordLevel;
import com.dtf.face.log.RecordService;

public class DTFNfcManager {
    private static IntentFilter mTagDetectedIntentFilter;
    private static String[][] mTechLists;
    private static PendingIntent mNfcPendingIntent;

    public static NfcAdapter enableReaderMode(Activity activity, NfcAdapter.ReaderCallback readerCallback) {
        try {
            NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter((Context)activity);
            if (nfcAdapter == null) {
                return null;
            }
            Bundle options = new Bundle();
            options.putInt("presence", 300);
            int READER_FLAGS = 31;
            if (Build.VERSION.SDK_INT >= 19) {
                nfcAdapter.enableReaderMode(activity, readerCallback, READER_FLAGS, options);
            }
            return nfcAdapter;
        }
        catch (Exception e) {
            RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "DTFNfcManagerError", new String[]{Log.getStackTraceString((Throwable)e)});
            return null;
        }
    }

    public static NfcAdapter enableReaderMode(Activity activity) {
        return DTFNfcManager.enableReaderMode(activity, null);
    }

    public static void disableReaderMode(Activity activity, NfcAdapter nfcAdapter) {
        try {
            if (nfcAdapter != null && Build.VERSION.SDK_INT >= 19) {
                nfcAdapter.disableReaderMode(activity);
            }
        }
        catch (Exception e) {
            RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "DTFNfcManagerError", new String[]{Log.getStackTraceString((Throwable)e)});
        }
    }

    public static NfcAdapter enableForegroundDispatch(Activity activity) {
        try {
            NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter((Context)activity);
            if (nfcAdapter == null) {
                return null;
            }
            if (!nfcAdapter.isEnabled()) {
                return null;
            }
            if (mNfcPendingIntent == null) {
                mNfcPendingIntent = PendingIntent.getActivity((Context)activity, (int)0, (Intent)new Intent((Context)activity, activity.getClass()).addFlags(0x20000000), (int)0);
            }
            if (mTagDetectedIntentFilter == null) {
                mTagDetectedIntentFilter = new IntentFilter("android.nfc.action.TECH_DISCOVERED");
                mTagDetectedIntentFilter.addCategory("android.intent.category.DEFAULT");
            }
            if (mTechLists == null) {
                mTechLists = new String[][]{{NfcB.class.getName()}};
            }
            nfcAdapter.enableForegroundDispatch(activity, mNfcPendingIntent, new IntentFilter[]{mTagDetectedIntentFilter}, mTechLists);
            return nfcAdapter;
        }
        catch (Exception e) {
            RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "DTFNfcManagerError", new String[]{Log.getStackTraceString((Throwable)e)});
            return null;
        }
    }

    public static void disableForegroundDispatch(Activity activity, NfcAdapter nfcAdapter) {
        try {
            if (nfcAdapter != null) {
                nfcAdapter.disableForegroundDispatch(activity);
            }
        }
        catch (Exception e) {
            RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "DTFNfcManagerError", new String[]{Log.getStackTraceString((Throwable)e)});
        }
    }
}

