/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.nfc.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.dtf.face.ToygerConfig;
import com.dtf.face.ToygerConst;
import com.dtf.face.config.AndroidDocConfig;
import com.dtf.face.config.Coll;
import com.dtf.face.log.RecordLevel;
import com.dtf.face.log.RecordService;
import com.dtf.face.network.APICallback;
import com.dtf.face.network.BizRequestProxy;
import com.dtf.face.network.callback.ZimValidateCallback;
import com.dtf.face.network.model.NfcInfo;
import com.dtf.face.network.model.ValidateParams;
import com.dtf.face.network.utils.NetworkPackUtil;
import com.dtf.face.nfc.DTFNfcManager;
import com.dtf.face.nfc.MurmurHash3;
import com.dtf.face.nfc.NFCConst;
import com.dtf.face.nfc.R;
import com.dtf.face.nfc.factory.VIVO;
import com.dtf.face.nfc.ui.anim.NfcReadOperationView;
import com.dtf.face.nfc.ui.dialog.NfcReadStatusDialog;
import com.dtf.face.ui.FaceBaseActivity;
import com.dtf.face.ui.overlay.CommAlertOverlay;
import com.dtf.face.utils.CountdownUpdater;
import com.dtf.face.utils.MiscUtil;
import com.eidlink.idocr.sdk.EidLinkSEFactory;
import com.eidlink.idocr.sdk.bean.EidlinkInitParams;
import com.eidlink.idocr.sdk.bean.EidlinkResult;
import com.eidlink.idocr.sdk.listener.OnGetResultListener;
import java.util.Map;

public class NfcReadActivity
extends FaceBaseActivity {
    private Handler handler;
    private NfcReadStatusDialog nfcReadStatusDialog;
    private String passportNum;
    private String birth;
    private String validity;
    private String docType;
    private String docInputMode = "";
    private long startListenTime = 0L;
    private NfcAdapter mNfcAdapter;
    protected CountdownUpdater mCountDown;
    private CommAlertOverlay nfcSettingDialog;
    private Button btnStartRead;
    private FrameLayout flBack;
    public int retryTime = 3;
    public int countDownTime = 20;
    public boolean readImg = false;
    private boolean isPassPort = true;
    private long onCreateTime = 0L;
    private Tag preTag;
    public boolean DEVICE_SM = false;
    private final OnGetResultListener mResultListener = new OnGetResultListener(){
        long startReadTime;

        public void onStart() {
            super.onStart();
            NfcReadActivity.this.preTag = null;
            NfcReadActivity.this.clearCountDown();
            NfcReadActivity.this.setDialogStatus(NFCConst.NFC_READ_STATUS_START);
            RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "NFCSDKStartCalled", new String[]{"docType", NfcReadActivity.this.docType});
            this.startReadTime = System.currentTimeMillis();
        }

        public void onSuccess(EidlinkResult result) {
            LinearLayout loadingPage;
            if (NfcReadActivity.this.DEVICE_SM) {
                NfcReadActivity.this.disableReaderMode();
            }
            if (null != (loadingPage = (LinearLayout)NfcReadActivity.this.findViewById(R.id.toyger_face_eye_loading_page))) {
                loadingPage.setVisibility(0);
            }
            long listenCostTime = System.currentTimeMillis() - NfcReadActivity.this.startListenTime;
            long readCostTime = System.currentTimeMillis() - this.startReadTime;
            RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "NFCSDKSuccessfullyCalled", new String[]{"docType", NfcReadActivity.this.docType, "reqId", result.reqId, "nfc_listen_cost", String.valueOf(listenCostTime), "nfc_read_cost", String.valueOf(readCostTime)});
            NfcReadActivity.this.doVerify(result);
            NfcReadActivity.this.setDialogStatus(NFCConst.NFC_READ_STATUS_SUCCESS);
            NfcReadActivity.this.dismissDialog(true);
        }

        public void onFailed(int code, String msg, String biz_id) {
            if (NfcReadActivity.this.DEVICE_SM) {
                NfcReadActivity.this.disableReaderMode();
                NfcReadActivity.this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        NfcReadActivity.this.enableReadModel();
                    }
                }, 3000L);
            }
            long listenCostTime = System.currentTimeMillis() - NfcReadActivity.this.startListenTime;
            long readCostTime = System.currentTimeMillis() - this.startReadTime;
            NfcReadActivity.this.setDialogStatus(NFCConst.NFC_READ_STATUS_FAIL, NfcReadActivity.this.getResources().getString(NfcReadActivity.this.codeToAliyunMsg(code)));
            NfcReadActivity.this.dismissDialog(false, code);
            RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "NFCSDKFailedCalled", new String[]{"code", Integer.toString(code), "msg", msg, "docType", NfcReadActivity.this.docType, "biz_id", biz_id, "nfc_listen_cost", String.valueOf(listenCostTime), "nfc_read_cost", String.valueOf(readCostTime)});
        }
    };

    public static void initEid(Context context, AndroidDocConfig.Eidlink eidlink) {
        if (null == eidlink) {
            RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "Eidlink init Error", new String[]{"errMsg", "eidlink is null"});
            ToygerConfig.getInstance().sendResAndExit(context, "Z3004", "");
            return;
        }
        try {
            NFCConst.eid = EidLinkSEFactory.getEidLinkSE((EidlinkInitParams)new EidlinkInitParams(context, eidlink.getAppid(), eidlink.getIp(), Integer.parseInt(eidlink.getPort2()), Integer.parseInt(eidlink.getEnvCode())));
            if (null == NFCConst.eid) {
                RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "eid is null", new String[]{"position", "onCreate"});
                ToygerConfig.getInstance().sendResAndExit(context, "Z3004", "");
                return;
            }
        }
        catch (Exception ex) {
            RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "Eidlink init Error", new String[]{"errMsg", Log.getStackTraceString((Throwable)ex)});
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        ImageView ivBack;
        super.onCreate(savedInstanceState);
        String device = Build.BRAND;
        if (device.equals("samsung")) {
            this.DEVICE_SM = true;
        }
        this.onCreateTime = System.currentTimeMillis();
        this.setContentView(R.layout.dtf_activity_nfc_read);
        RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "NfcReadActivityOnCreate", new String[0]);
        ToygerConfig.getInstance().asyncYunDeviceToken();
        AndroidDocConfig androidDocConfig = ToygerConfig.getInstance().getAndroidDocConfig();
        if (null == androidDocConfig) {
            RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "androidDocConfig_err", new String[]{"errMsg", "androidDocConfig is null"});
            ToygerConfig.getInstance().sendResAndExit((Context)this, "Z3004", "");
        } else {
            NfcReadOperationView nfcReadOperationView;
            NfcReadActivity.initEid((Context)this, androidDocConfig.getEidlink());
            Coll coll = androidDocConfig.getColl();
            if (null != coll) {
                this.docType = coll.docType;
                this.docInputMode = coll.docInputMode;
                this.retryTime = coll.retry;
                this.readImg = Boolean.parseBoolean(coll.readImg);
            }
            this.isPassPort = NFCConst.DOC_TYPE_PASSPORT.equals(this.docType);
            if (this.isPassPort) {
                try {
                    NFCConst.eid.setHttpReadTravelPort(Integer.parseInt(androidDocConfig.getEidlink().getPort()));
                }
                catch (Exception ex) {
                    RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "Eidlink init Error", new String[]{"errMsg", Log.getStackTraceString((Throwable)ex)});
                }
            }
            if (null != (nfcReadOperationView = (NfcReadOperationView)this.findViewById(R.id.fl_animation))) {
                nfcReadOperationView.setIsPassport(this.isPassPort);
            }
        }
        this.handler = new Handler();
        this.btnStartRead = (Button)this.findViewById(R.id.btn_start_read);
        if (null != this.btnStartRead) {
            this.btnStartRead.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    NfcReadActivity.this.startListenTime = System.currentTimeMillis();
                    NfcReadActivity.this.btnStartRead.setEnabled(false);
                    ++NFCConst.REAL_TRY_TIME;
                    NfcReadActivity.this.nfcSettingDialog = NfcReadActivity.this.getNfcSettingDialog();
                    if (null != NfcReadActivity.this.nfcSettingDialog) {
                        if (NfcReadActivity.this.nfcCheck()) {
                            if (!NfcReadActivity.this.nfcReadCheck()) {
                                NfcReadActivity.this.nfcSettingDialog.setMessageText(NfcReadActivity.this.getResources().getString(R.string.dtf_nfc_vivo_read_card_not_open));
                                NfcReadActivity.this.nfcSettingDialog.setVisibility(0);
                                NfcReadActivity.this.btnStartRead.setEnabled(false);
                                NfcReadActivity.this.flBack.setEnabled(false);
                                return;
                            }
                            NfcReadActivity.this.nfcSettingDialog.setVisibility(8);
                        } else {
                            NfcReadActivity.this.nfcSettingDialog.setMessageText(NfcReadActivity.this.getResources().getString(R.string.dtf_nfc_open_nfc_and_retry));
                            NfcReadActivity.this.nfcSettingDialog.setVisibility(0);
                            NfcReadActivity.this.btnStartRead.setEnabled(false);
                            NfcReadActivity.this.flBack.setEnabled(false);
                            return;
                        }
                    }
                    NfcReadActivity.this.mCountDown = CountdownUpdater.startCountDown((int)NfcReadActivity.this.countDownTime, (CountdownUpdater.Callback)new CountdownUpdater.Callback(){

                        public void onCountDownUpdate(int i) {
                        }

                        public void onCountdownCompleted() {
                            NfcReadActivity.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "WaitTimeOut", new String[]{"cost", String.valueOf(System.currentTimeMillis() - NfcReadActivity.this.startListenTime)});
                                    NfcReadActivity.this.setDialogStatus(NFCConst.NFC_READ_STATUS_TIME_OUT, NfcReadActivity.this.getResources().getString(NFCConst.REAL_TRY_TIME > NfcReadActivity.this.retryTime ? R.string.dtf_nfc_read_time_out_exit : R.string.dtf_nfc_read_time_out));
                                }
                            });
                            NfcReadActivity.this.dismissDialog(false);
                        }
                    });
                    NfcReadActivity.this.nfcReadStatusDialog = NfcReadActivity.this.getNfcReadStatusDialog();
                    if (null != NfcReadActivity.this.nfcReadStatusDialog && NfcReadActivity.this.nfcReadStatusDialog.getVisibility() != 0) {
                        NfcReadActivity.this.btnStartRead.setEnabled(true);
                        NfcReadActivity.this.nfcReadStatusDialog.setVisibility(0);
                        NfcReadActivity.this.nfcReadStatusDialog.setDialogStatus(NFCConst.NFC_READ_STATUS_DEFUALT);
                    }
                    if (null != NfcReadActivity.this.preTag) {
                        NfcReadActivity.this.readCard(NfcReadActivity.this.preTag);
                    } else {
                        NfcReadActivity.this.enableReadModel();
                    }
                }
            });
        }
        Intent intent = this.getIntent();
        this.passportNum = intent.getStringExtra(NFCConst.INTENT_PARAM_KEY_PASSPORTNUM);
        this.birth = intent.getStringExtra(NFCConst.INTENT_PARAM_KEY_BIRTHDAY);
        this.validity = intent.getStringExtra(NFCConst.INTENT_PARAM_KEY_VALIDITY);
        this.flBack = this.getFlBack();
        if (null != this.flBack) {
            this.flBack.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    NfcReadActivity.this.onBackPressed();
                }
            });
        }
        if (null != (ivBack = (ImageView)this.findViewById(R.id.iv_back))) {
            ivBack.setImageDrawable(this.getResources().getDrawable(this.isPassPort && this.docInputMode.equals(NFCConst.DOC_INPUT_MODE_MANUAL) ? R.mipmap.dtf_left_arrow : R.mipmap.dtf_face_black_close));
        }
    }

    private void enableReadModel() {
        if (null == this.handler) {
            this.handler = new Handler();
        }
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                NfcAdapter adapter = NfcAdapter.getDefaultAdapter((Context)NfcReadActivity.this);
                if (null != adapter && !adapter.isEnabled() && !adapter.isNdefPushEnabled()) {
                    NfcReadActivity.this.getNfcSettingDialog().setVisibility(0);
                }
            }
        }, 1000L);
        this.mNfcAdapter = Build.VERSION.SDK_INT >= 19 ? DTFNfcManager.enableReaderMode((Activity)this, new NfcAdapter.ReaderCallback(){

            public void onTagDiscovered(Tag tag) {
                NfcReadActivity.this.preTag = tag;
                if (null != NfcReadActivity.this.nfcReadStatusDialog && NfcReadActivity.this.nfcReadStatusDialog.getVisibility() == 0) {
                    NfcReadActivity.this.readCard(tag);
                }
            }
        }) : DTFNfcManager.enableForegroundDispatch((Activity)this);
    }

    public void onResume() {
        super.onResume();
        this.enableReadModel();
    }

    public FrameLayout getFlBack() {
        if (null == this.flBack) {
            this.flBack = (FrameLayout)this.findViewById(R.id.close_nfc_btn);
        }
        return this.flBack;
    }

    public void setDialogStatus(int status) {
        NfcReadStatusDialog dialog = this.getNfcReadStatusDialog();
        if (null != dialog) {
            dialog.setDialogStatus(status, "");
        }
    }

    public void setDialogStatus(int status, String msg) {
        NfcReadStatusDialog dialog = this.getNfcReadStatusDialog();
        if (null != dialog) {
            dialog.setDialogStatus(status, msg);
        }
    }

    public void readCancel() {
        this.clearCountDown();
        this.outOfTimeCheck();
        long costTime = System.currentTimeMillis() - this.startListenTime;
        RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "nfcReadCancel", new String[]{"cost", String.valueOf(costTime)});
    }

    public void onBackPressed() {
        super.onBackPressed();
        if (this.isPassPort && this.docInputMode.equals(NFCConst.DOC_INPUT_MODE_MANUAL)) {
            this.finish();
        } else {
            RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "UserActivelyExits", new String[0]);
            this.sendErrorCode(ToygerConst.ZcodeConstants.ZCODE_USER_BACK);
        }
    }

    public boolean nfcCheck() {
        NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this);
        return nfcAdapter != null && nfcAdapter.isEnabled();
    }

    public boolean nfcReadCheck() {
        return VIVO.isReaderModeEnabled();
    }

    protected void onPause() {
        super.onPause();
        if (this.nfcReadStatusDialog != null) {
            this.nfcReadStatusDialog.setVisibility(4);
        }
        this.getNfcSettingDialog().setVisibility(8);
        this.disableReaderMode();
    }

    private void disableReaderMode() {
        if (Build.VERSION.SDK_INT >= 19) {
            DTFNfcManager.disableReaderMode((Activity)this, this.mNfcAdapter);
        } else {
            DTFNfcManager.disableForegroundDispatch((Activity)this, this.mNfcAdapter);
        }
    }

    public NfcReadStatusDialog getNfcReadStatusDialog() {
        if (null == this.nfcReadStatusDialog) {
            this.nfcReadStatusDialog = (NfcReadStatusDialog)this.findViewById(R.id.dialog_read_status);
        }
        this.nfcReadStatusDialog.init(this, this.isPassPort ? 10 : 3);
        return this.nfcReadStatusDialog;
    }

    private void readCard(Tag tag) {
        if (NFCConst.eid == null) {
            RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "eid is null", new String[]{"position", "readCard"});
            this.sendErrorCode("Z3004");
            return;
        }
        if (this.isPassPort) {
            NFCConst.eid.readTravel((Activity)this, tag, this.passportNum, this.birth, this.validity, this.readImg, this.mResultListener);
        } else {
            NFCConst.eid.setReadCount(1);
            NFCConst.eid.readIDCard((Activity)this, tag, this.mResultListener);
        }
    }

    public void onDestroy() {
        long cost = System.currentTimeMillis() - this.onCreateTime;
        RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "NfcReadActivityOnDestroy", new String[]{"cost", String.valueOf(cost)});
        if (null != NFCConst.eid) {
            NFCConst.eid.release();
        }
        if (null != this.handler) {
            this.handler.removeCallbacks(null);
            this.handler.removeMessages(0);
        }
        super.onDestroy();
    }

    private void dismissDialog(boolean isSuccess) {
        this.dismissDialog(isSuccess, -1);
    }

    private void dismissDialog(final boolean isSuccess, final int code) {
        long delayTime = isSuccess ? 2000L : 3000L;
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (null != NfcReadActivity.this.nfcReadStatusDialog && NfcReadActivity.this.nfcReadStatusDialog.getVisibility() == 0) {
                    NfcReadActivity.this.nfcReadStatusDialog.setVisibility(4);
                    if (!isSuccess) {
                        if (code == -53001) {
                            if (NfcReadActivity.this.docInputMode.equals(NFCConst.DOC_INPUT_MODE_MANUAL)) {
                                NfcReadActivity.this.finish();
                            } else {
                                NfcReadActivity.this.SendResponseAndExit("Z3005");
                            }
                        } else {
                            NfcReadActivity.this.outOfTimeCheck();
                        }
                    }
                }
            }
        }, delayTime);
    }

    public void outOfTimeCheck() {
        this.btnStartRead.setEnabled(true);
        if (NFCConst.REAL_TRY_TIME > this.retryTime) {
            RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "MaximumRetryLimit", new String[0]);
            this.SendResponseAndExit("Z3001");
        }
    }

    public void doVerify(EidlinkResult result) {
        Map params = NetworkPackUtil.packageNfcVerify((ValidateParams)this.generateVerifyContent(result), (ZimValidateCallback)new ZimValidateCallback(){

            public void onSuccess() {
                RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "netVerifyRes", new String[]{"status", "success", "verify", "success"});
                NfcReadActivity.this.SendResponseAndExit(ToygerConst.ZcodeConstants.ZCODE_NET_VERIFY_SUCCESS);
            }

            public void onValidateFail(String retCodeSub, String retMessageSub, String srvRes) {
                RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "netVerifyRes", new String[]{"status", "success", "verify", "false", "msg", "Nfc onValidateFail, retCodeSub=" + retCodeSub + " retMessageSub=" + retMessageSub + " srvRes=" + srvRes});
                NfcReadActivity.this.SendResponseAndExit(ToygerConst.ZcodeConstants.ZCODE_VERIFY_FAIL_PREFIX + retCodeSub);
            }

            public void onServerError(String code, String errMsg) {
                RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "netVerifyRes", new String[]{"status", "fail", "msg", "Server Internal onError, code=" + code + " errMsg=" + errMsg});
                NfcReadActivity.this.SendResponseAndExit(code);
            }

            public void onNextVerify(int code, String data) {
                NfcReadActivity.this.SendResponseAndExit(code + "");
            }

            public void onError(String code, String errMsg) {
                RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "netVerifyRes", new String[]{"status", "fail", "msg", "Nfc onError, code=" + code + " errMsg=" + errMsg});
                if ("Z1028".equals(code)) {
                    NfcReadActivity.this.SendResponseAndExit(ToygerConst.ZcodeConstants.ZCODE_NET_OVER_RATE_LIMIT);
                } else {
                    NfcReadActivity.this.SendResponseAndExit(ToygerConst.ZcodeConstants.ZCODE_NET_VERIFY_ERROR);
                }
            }
        });
        BizRequestProxy.getInstance().zimNfcVerify(params, (APICallback)params.get("callback"));
    }

    private void sendErrorCode(String errCode) {
        ToygerConfig.getInstance().sendResAndExit((Context)this, errCode, "");
    }

    protected ValidateParams generateVerifyContent(EidlinkResult result) {
        String zimId = ToygerConfig.getInstance().getZimId();
        RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "startNFCNetVerify", new String[]{"status", "start net verify"});
        NfcInfo nfcInfo = new NfcInfo();
        nfcInfo.reqId = result.reqId;
        String tokenRequestId = ToygerConfig.getInstance().getClientProtocolContent().token + result.reqId;
        byte[] signBytes = tokenRequestId.getBytes();
        int hash = MurmurHash3.murmurhash3x8632(signBytes, 0, signBytes.length, tokenRequestId.length());
        nfcInfo.sign = Integer.toString(hash);
        ValidateParams params = new ValidateParams();
        params.setZimId(zimId).setNfcInfo(nfcInfo).setContext((Context)this).setPubKey(this.getPublicKey()).setMetaInfo(ToygerConfig.getInstance().getMetaInfo()).setProtocolContent(ToygerConfig.getInstance().getClientProtocolContent()).setDeviceToken(ToygerConfig.getInstance().getYunDeviceToken()).setAppidToken(ToygerConfig.getInstance().getApdidDeviceToken());
        return params;
    }

    public String getPublicKey() {
        return MiscUtil.readAssetsFile((Context)ToygerConfig.getInstance().getContext(), (String)"bid-log-key-public.key");
    }

    public void clearCountDown() {
        if (null != this.mCountDown) {
            this.mCountDown.cleanup();
        }
    }

    private int codeToAliyunMsg(int code) {
        switch (code) {
            case -93003: 
            case -93001: 
            case -1: {
                return R.string.dtf_nfc_do_not_move_and_retry;
            }
            case -99098: 
            case -99002: 
            case -99001: 
            case -93006: 
            case -91006: 
            case -91001: 
            case -54003: 
            case -35001: 
            case -31006: 
            case -13012: {
                return R.string.dtf_nfc_read_error_and_retry;
            }
            case -93005: 
            case -91007: 
            case -91005: 
            case -31001: 
            case -22003: 
            case -20005: 
            case -20004: 
            case -20003: 
            case -20002: 
            case -20001: {
                return R.string.dtf_nfc_check_network_and_retry;
            }
            case -990011: 
            case -99010: 
            case -99008: {
                return R.string.dtf_nfc_read_error;
            }
            case -53001: {
                return R.string.dtf_nfc_error_info;
            }
            case -53002: {
                return R.string.dtf_nfc_reset_and_retry;
            }
            case -93002: {
                return R.string.dtf_nfc_doc_type_is_wrong;
            }
            case -93008: {
                return R.string.dtf_nfc_unsurpported;
            }
            case -93009: {
                return R.string.dtf_nfc_not_open;
            }
        }
        return R.string.dtf_nfc_read_error_and_retry;
    }

    public CommAlertOverlay getNfcSettingDialog() {
        this.nfcSettingDialog = this.getCommAlertOverlay();
        this.nfcSettingDialog.setTitleText(this.getResources().getString(R.string.dtf_nfc_is_close));
        this.nfcSettingDialog.setMessageText(this.getResources().getString(R.string.dtf_nfc_open_nfc_and_retry));
        this.nfcSettingDialog.setConfirmText(this.getResources().getString(R.string.dtf_nfc_sure));
        this.nfcSettingDialog.setCancelText(this.getResources().getString(R.string.dtf_nfc_cancel));
        return this.nfcSettingDialog;
    }

    public CommAlertOverlay getCommAlertOverlay() {
        if (null == this.nfcSettingDialog) {
            this.nfcSettingDialog = (CommAlertOverlay)this.findViewById(R.id.message_box_overlay);
            this.nfcSettingDialog.setCommAlertOverlayListener(new CommAlertOverlay.CommAlertOverlayListener(){

                public void onCancel() {
                    NfcReadActivity.this.SendResponseAndExit("Z3002");
                }

                public void onConfirm() {
                    NfcReadActivity.this.btnStartRead.setEnabled(true);
                    NfcReadActivity.this.flBack = NfcReadActivity.this.getFlBack();
                    if (null != NfcReadActivity.this.flBack) {
                        NfcReadActivity.this.flBack.setEnabled(true);
                    }
                    NfcReadActivity.this.startActivity(new Intent("android.settings.NFC_SETTINGS"));
                }
            });
        }
        return this.nfcSettingDialog;
    }

    public void SendResponseAndExit(String errCode) {
        this.sendErrorCode(errCode);
        this.setResult(-1);
        this.finish();
    }
}

