/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.nfc.ui.widget.wheelpiker;

import android.content.Context;
import android.util.AttributeSet;
import com.dtf.face.nfc.ui.widget.wheelpiker.IWheelDayPicker;
import com.dtf.face.nfc.ui.widget.wheelpiker.WheelPicker;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WheelDayPicker
extends WheelPicker
implements IWheelDayPicker {
    private static final Map<Integer, List<Integer>> DAYS = new HashMap<Integer, List<Integer>>();
    private final Calendar mCalendar = Calendar.getInstance();
    private int mYear;
    private int mMonth;
    private int mSelectedDay;
    public int mEndDay = this.mCalendar.getActualMaximum(5);

    public int getDaysOfMonth(int month, int year) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                if (year % 4 == 0 && year % 400 != 0) {
                    return 29;
                }
                return 28;
            }
        }
        return 30;
    }

    public WheelDayPicker(Context context) {
        this(context, null);
    }

    public WheelDayPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mYear = this.mCalendar.get(1);
        this.mMonth = this.mCalendar.get(2);
        this.updateDays(this.mYear, this.mMonth);
        this.mSelectedDay = this.mCalendar.get(5);
        this.updateSelectedDay();
    }

    private void updateDays(int year, int month) {
        int days;
        List<Integer> data;
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(2, this.mMonth);
        if (month == -1) {
            month = this.mMonth;
        }
        if (null == (data = DAYS.get(days = (this.mEndDay = this.getDaysOfMonth(month, year))))) {
            data = new ArrayList<Integer>();
            for (int i = 1; i <= days; ++i) {
                data.add(i);
            }
            DAYS.put(days, data);
        }
        super.setData(data);
    }

    private void updateSelectedDay() {
        this.setSelectedItemPosition(this.mSelectedDay - 1);
    }

    @Override
    public void setData(List data) {
        throw new UnsupportedOperationException("You can not invoke setData in WheelDayPicker");
    }

    @Override
    public int getSelectedDay() {
        return this.mSelectedDay;
    }

    @Override
    public void setSelectedDay(int day) {
        this.mSelectedDay = day;
        this.updateSelectedDay();
    }

    @Override
    public int getCurrentDay() {
        return Integer.parseInt(String.valueOf(this.getData().get(this.getCurrentItemPosition())));
    }

    @Override
    public void setYearAndMonth(int year, int month) {
        this.mYear = year;
        this.mMonth = month - 1;
        this.updateDays(year, month);
    }

    @Override
    public void setYear(int year, int month) {
        this.mYear = year;
        this.updateDays(year, month);
    }

    @Override
    public void setMonth(int month, int year) {
        this.mMonth = month - 1;
        this.updateDays(year, month);
    }
}

