/*
 * Decompiled with CFR 0.152.
 */
package net.security.device.api.id.oaid;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import java.util.Objects;
import net.security.device.api.LogUtil;
import net.security.device.api.id.IOAID;
import net.security.device.api.id.IOAIDGetter;

public class MeizuImpl
implements IOAID {
    private final Context context;

    public MeizuImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        if (this.context == null) {
            return false;
        }
        try {
            ProviderInfo pi;
            PackageManager pm = this.context.getPackageManager();
            if (pm != null && (pi = pm.resolveContentProvider("com.meizu.flyme.openidsdk", 0)) != null) {
                return true;
            }
        }
        catch (Exception e) {
            LogUtil.e(e.toString());
        }
        return false;
    }

    @Override
    public void doGet(IOAIDGetter getter) {
        if (this.context == null) {
            getter.onOAIDGetError(new NullPointerException("OAID context is null"));
            return;
        }
        if (Build.VERSION.SDK_INT < 19) {
            getter.onOAIDGetError(new RuntimeException("OAID unsupported system"));
            return;
        }
        try {
            Cursor cursor;
            ContentResolver cr;
            String oaid = null;
            Uri uri = Uri.parse((String)"content://com.meizu.flyme.openidsdk/");
            if (uri != null && (cr = this.context.getContentResolver()) != null && (cursor = cr.query(uri, null, null, new String[]{"oaid"}, null)) != null) {
                Objects.requireNonNull(cursor).moveToFirst();
                oaid = cursor.getString(cursor.getColumnIndex("value"));
            }
            if (oaid == null || oaid.length() == 0) {
                throw new RuntimeException("OAID query failed");
            }
            getter.onOAIDGetComplete(oaid);
        }
        catch (Exception e) {
            LogUtil.e(e.toString());
            getter.onOAIDGetError(e);
        }
    }
}

