/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.ui.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.dtf.face.baseverify.R;
import com.dtf.face.utils.MobileUtil;
import java.lang.ref.WeakReference;

public class CircleHoleView
extends ImageView {
    public static final Xfermode SXFERMODE = new PorterDuffXfermode(PorterDuff.Mode.XOR);
    public Context mContext;
    public Bitmap mMaskBitmap;
    public Paint mPaint;
    public WeakReference<Bitmap> mWeakBitmap;
    public float leftAttr;
    public float topAttr;
    public float widthAttr;
    public float heightAttr;
    public boolean holeHCenter;
    public boolean holeVCenter;
    public int floodColor;

    public CircleHoleView(Context context) {
        CircleHoleView circleHoleView = this;
        super(context);
        circleHoleView.leftAttr = -1.0f;
        circleHoleView.topAttr = -1.0f;
        circleHoleView.widthAttr = -1.0f;
        circleHoleView.heightAttr = -1.0f;
        circleHoleView.holeHCenter = false;
        circleHoleView.holeVCenter = false;
        circleHoleView.floodColor = -1;
        circleHoleView.sharedConstructor();
    }

    public CircleHoleView(Context context, AttributeSet attributeSet) {
        CircleHoleView circleHoleView = this;
        super(context, attributeSet);
        this.leftAttr = -1.0f;
        this.topAttr = -1.0f;
        this.widthAttr = -1.0f;
        this.heightAttr = -1.0f;
        this.holeHCenter = false;
        this.holeVCenter = false;
        this.floodColor = -1;
        circleHoleView.initHoleAttrs(context, attributeSet);
        circleHoleView.sharedConstructor();
    }

    public CircleHoleView(Context context, AttributeSet attributeSet, int n) {
        CircleHoleView circleHoleView = this;
        super(context, attributeSet, n);
        this.leftAttr = -1.0f;
        this.topAttr = -1.0f;
        this.widthAttr = -1.0f;
        this.heightAttr = -1.0f;
        this.holeHCenter = false;
        this.holeVCenter = false;
        this.floodColor = -1;
        circleHoleView.initHoleAttrs(context, attributeSet);
        circleHoleView.sharedConstructor();
    }

    private void initHoleAttrs(Context context, AttributeSet attributeSet) {
        if ((context = context.obtainStyledAttributes(attributeSet, R.styleable.DtfCircleHoleView)) != null) {
            this.leftAttr = context.getDimension(R.styleable.DtfCircleHoleView_holeLeft, 0.0f);
            this.topAttr = context.getDimension(R.styleable.DtfCircleHoleView_holeTop, 0.0f);
            this.widthAttr = context.getDimension(R.styleable.DtfCircleHoleView_holeWidth, 0.0f);
            this.heightAttr = context.getDimension(R.styleable.DtfCircleHoleView_holeHeight, 0.0f);
            this.holeHCenter = context.getBoolean(R.styleable.DtfCircleHoleView_holeHCenter, false);
            this.holeVCenter = context.getBoolean(R.styleable.DtfCircleHoleView_holeVCenter, false);
            context.recycle();
        }
        if (this.widthAttr == 0.0f) {
            CircleHoleView circleHoleView = this;
            circleHoleView.leftAttr = 0.0f;
            circleHoleView.topAttr = MobileUtil.dp2px(circleHoleView.getContext(), 60.0f);
            circleHoleView.widthAttr = MobileUtil.dp2px(circleHoleView.getContext(), 238.0f);
            circleHoleView.heightAttr = MobileUtil.dp2px(circleHoleView.getContext(), 238.0f);
            circleHoleView.holeHCenter = true;
            circleHoleView.holeVCenter = false;
        }
    }

    private void sharedConstructor() {
        this.mPaint = new Paint(1);
    }

    public void changeBackColor(int n) {
        this.floodColor = n;
        this.invalidate();
    }

    public void invalidate() {
        this.mWeakBitmap = null;
        Bitmap bitmap = this.mMaskBitmap;
        if (bitmap != null) {
            bitmap.recycle();
        }
        super.invalidate();
    }

    /*
     * Unable to fully structure code
     */
    public void onDraw(Canvas var1_1) {
        block26: {
            block24: {
                block25: {
                    block22: {
                        block23: {
                            block21: {
                                block20: {
                                    if (this.isInEditMode()) break block24;
                                    v0 = this;
                                    var2_2 = v0.getWidth();
                                    var3_4 = v0.getHeight();
                                    var2_3 = var1_1.saveLayer(0.0f, 0.0f, var2_2, var3_4, null, 31);
                                    if (this.mWeakBitmap == null) break block20;
                                    var3_5 = (Bitmap)this.mWeakBitmap.get();
                                    break block21;
                                }
                                var3_5 = null;
                            }
                            if (var3_5 != null) {
                                if (!var3_5.isRecycled()) break block22;
                            }
                            var4_6 = this.getDrawable();
                            if (var4_6 == null) break block22;
                            v1 = this;
                            v2 = var4_6;
                            var3_5 = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                            var5_7 = v3;
                            v4 = var4_6;
                            var5_7(var3_5);
                            v4.setBounds(0, 0, this.getWidth(), this.getHeight());
                            v2.draw(v3);
                            if (v1.mMaskBitmap == null) break block23;
                            if (!this.mMaskBitmap.isRecycled()) ** GOTO lbl37
                        }
                        this.mMaskBitmap = this.createMask1();
lbl37:
                        // 2 sources

                        v5 = this;
                        v6 = var5_7;
                        v7 = this;
                        v8 = var5_7;
                        v9 = this;
                        v10 = v9;
                        v9.mPaint.reset();
                        v9.mPaint.setFilterBitmap(false);
                        v9.mPaint.setXfermode(CircleHoleView.SXFERMODE);
                        v8.drawColor(v10.floodColor);
                        v11 = v7.mMaskBitmap;
                        v6.drawBitmap(v11, 0.0f, 0.0f, this.mPaint);
                        v5.mWeakBitmap = new WeakReference<Bitmap>(var3_5);
                        break block22;
                        catch (OutOfMemoryError v12) {
                            System.gc();
                            var1_1.restoreToCount(var2_3);
                            return;
                        }
                    }
                    if (var3_5 != null) {
                        v13 = var1_1;
                        v14 = var2_3;
                        v15 = var1_1;
                        v16 = var3_5;
                        this.mPaint.setXfermode(null);
                        v15.drawBitmap(v16, 0.0f, 0.0f, this.mPaint);
                        v13.restoreToCount(v14);
                        return;
                    }
                    break block25;
                    {
                        catch (Throwable v17) {
                            var1_1.restoreToCount(var2_3);
                            throw v17;
                        }
                        catch (Exception v18) {}
                    }
                }
                var1_1.restoreToCount(var2_3);
                break block26;
            }
            super.onDraw(var1_1);
        }
    }

    public Bitmap createMask1() {
        float f2;
        float f3;
        float f4;
        float f5;
        Paint paint;
        Canvas canvas;
        CircleHoleView circleHoleView = this;
        Bitmap bitmap = Bitmap.createBitmap((int)circleHoleView.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = canvas;
        canvas = new Canvas(bitmap);
        Paint paint2 = paint;
        new Paint(1).setAntiAlias(true);
        paint2.setColor(-1);
        float f6 = circleHoleView.getWidth();
        float f7 = circleHoleView.getHeight();
        float f8 = 0.0f;
        float f9 = circleHoleView.leftAttr;
        if (!(f5 > -1.0f)) {
            f9 = f8;
        }
        if (this.holeHCenter) {
            float f10;
            f9 = f6 / 2.0f - this.widthAttr / 2.0f;
            if (f10 < 0.0f) {
                f9 = 0.0f;
            }
        }
        f8 = (f7 - f6) / 2.0f;
        float f11 = this.topAttr;
        if (!(f4 > -1.0f)) {
            f11 = f8;
        }
        if (this.holeVCenter) {
            float f12;
            f11 = f7 / 2.0f - this.heightAttr / 2.0f;
            if (f12 < 0.0f) {
                f11 = 0.0f;
            }
        }
        f7 = this.widthAttr;
        f7 = f3 > -1.0f ? f9 + f7 : f6;
        float f13 = f11 + f6;
        f6 = this.heightAttr;
        if (f2 > -1.0f) {
            f13 = f11 + f6;
        }
        canvas2.drawOval(new RectF(f9, f11, f7, f13), paint2);
        return bitmap;
    }
}

