/*
 * Decompiled with CFR 0.152.
 */
package org.eid_bc.bouncycastle.math.ec;

import java.math.BigInteger;
import org.eid_bc.bouncycastle.math.ec.AbstractECMultiplier;
import org.eid_bc.bouncycastle.math.ec.ECCurve;
import org.eid_bc.bouncycastle.math.ec.ECLookupTable;
import org.eid_bc.bouncycastle.math.ec.ECPoint;
import org.eid_bc.bouncycastle.math.ec.FixedPointPreCompInfo;
import org.eid_bc.bouncycastle.math.ec.FixedPointUtil;
import org.eid_bc.bouncycastle.math.raw.Nat;

public class FixedPointCombMultiplier
extends AbstractECMultiplier {
    @Override
    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        ECCurve c = p.getCurve();
        int size = FixedPointUtil.getCombSize(c);
        if (k.bitLength() > size) {
            throw new IllegalStateException("fixed-point comb doesn't support scalars larger than the curve order");
        }
        FixedPointPreCompInfo info = FixedPointUtil.precompute(p);
        ECLookupTable lookupTable = info.getLookupTable();
        int width = info.getWidth();
        int d = (size + width - 1) / width;
        ECPoint R = c.getInfinity();
        int fullComb = d * width;
        int[] K = Nat.fromBigInteger(fullComb, k);
        int top = fullComb - 1;
        for (int i = 0; i < d; ++i) {
            int secretIndex = 0;
            for (int j = top - i; j >= 0; j -= d) {
                secretIndex <<= 1;
                secretIndex |= Nat.getBit(K, j);
            }
            ECPoint add = lookupTable.lookup(secretIndex);
            R = R.twicePlus(add);
        }
        return R.add(info.getOffset());
    }

    protected int getWidthForCombSize(int combSize) {
        return combSize > 257 ? 6 : 5;
    }
}

