/*
 * Decompiled with CFR 0.152.
 */
package org.eid_bc.bouncycastle.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import org.eid_bc.bouncycastle.asn1.ASN1Integer;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.asn1.ASN1Sequence;
import org.eid_bc.bouncycastle.asn1.DERSequence;
import org.eid_bc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.eid_bc.bouncycastle.asn1.x509.GeneralName;
import org.eid_bc.bouncycastle.asn1.x509.GeneralNames;
import org.eid_bc.bouncycastle.asn1.x509.Holder;
import org.eid_bc.bouncycastle.asn1.x509.IssuerSerial;
import org.eid_bc.bouncycastle.asn1.x509.ObjectDigestInfo;
import org.eid_bc.bouncycastle.jce.PrincipalUtil;
import org.eid_bc.bouncycastle.jce.X509Principal;
import org.eid_bc.bouncycastle.util.Arrays;
import org.eid_bc.bouncycastle.util.Selector;
import org.eid_bc.bouncycastle.x509.X509Util;

public class AttributeCertificateHolder
implements CertSelector,
Selector {
    final Holder holder;

    AttributeCertificateHolder(ASN1Sequence seq) {
        this.holder = Holder.getInstance(seq);
    }

    public AttributeCertificateHolder(X509Principal issuerName, BigInteger serialNumber) {
        this.holder = new Holder(new IssuerSerial(GeneralNames.getInstance(new DERSequence(new GeneralName(issuerName))), new ASN1Integer(serialNumber)));
    }

    public AttributeCertificateHolder(X500Principal issuerName, BigInteger serialNumber) {
        this(X509Util.convertPrincipal(issuerName), serialNumber);
    }

    public AttributeCertificateHolder(X509Certificate cert) throws CertificateParsingException {
        X509Principal name;
        try {
            name = PrincipalUtil.getIssuerX509Principal(cert);
        }
        catch (Exception e) {
            throw new CertificateParsingException(e.getMessage());
        }
        this.holder = new Holder(new IssuerSerial(this.generateGeneralNames(name), new ASN1Integer(cert.getSerialNumber())));
    }

    public AttributeCertificateHolder(X509Principal principal) {
        this.holder = new Holder(this.generateGeneralNames(principal));
    }

    public AttributeCertificateHolder(X500Principal principal) {
        this(X509Util.convertPrincipal(principal));
    }

    public AttributeCertificateHolder(int digestedObjectType, String digestAlgorithm, String otherObjectTypeID, byte[] objectDigest) {
        this.holder = new Holder(new ObjectDigestInfo(digestedObjectType, new ASN1ObjectIdentifier(otherObjectTypeID), new AlgorithmIdentifier(new ASN1ObjectIdentifier(digestAlgorithm)), Arrays.clone(objectDigest)));
    }

    public int getDigestedObjectType() {
        if (this.holder.getObjectDigestInfo() != null) {
            return this.holder.getObjectDigestInfo().getDigestedObjectType().getValue().intValue();
        }
        return -1;
    }

    public String getDigestAlgorithm() {
        if (this.holder.getObjectDigestInfo() != null) {
            return this.holder.getObjectDigestInfo().getDigestAlgorithm().getAlgorithm().getId();
        }
        return null;
    }

    public byte[] getObjectDigest() {
        if (this.holder.getObjectDigestInfo() != null) {
            return this.holder.getObjectDigestInfo().getObjectDigest().getBytes();
        }
        return null;
    }

    private GeneralNames generateGeneralNames(X509Principal principal) {
        return GeneralNames.getInstance(new DERSequence(new GeneralName(principal)));
    }

    private boolean matchesDN(X509Principal subject, GeneralNames targets) {
        GeneralName[] names = targets.getNames();
        for (int i = 0; i != names.length; ++i) {
            GeneralName gn = names[i];
            if (gn.getTagNo() != 4) continue;
            try {
                if (!new X509Principal(gn.getName().toASN1Primitive().getEncoded()).equals(subject)) continue;
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private Object[] getNames(GeneralName[] names) {
        ArrayList<X500Principal> l = new ArrayList<X500Principal>(names.length);
        for (int i = 0; i != names.length; ++i) {
            if (names[i].getTagNo() != 4) continue;
            try {
                l.add(new X500Principal(names[i].getName().toASN1Primitive().getEncoded()));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("badly formed Name object");
            }
        }
        return l.toArray(new Object[l.size()]);
    }

    private Principal[] getPrincipals(GeneralNames names) {
        Object[] p = this.getNames(names.getNames());
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i != p.length; ++i) {
            if (!(p[i] instanceof Principal)) continue;
            l.add(p[i]);
        }
        return l.toArray(new Principal[l.size()]);
    }

    public Principal[] getEntityNames() {
        if (this.holder.getEntityName() != null) {
            return this.getPrincipals(this.holder.getEntityName());
        }
        return null;
    }

    public BigInteger getSerialNumber() {
        if (this.holder.getBaseCertificateID() != null) {
            return this.holder.getBaseCertificateID().getSerial().getValue();
        }
        return null;
    }

    @Override
    public Object clone() {
        return new AttributeCertificateHolder((ASN1Sequence)this.holder.toASN1Primitive());
    }

    @Override
    public boolean match(Certificate cert) {
        block12: {
            if (!(cert instanceof X509Certificate)) {
                return false;
            }
            X509Certificate x509Cert = (X509Certificate)cert;
            try {
                if (this.holder.getBaseCertificateID() != null) {
                    return this.holder.getBaseCertificateID().getSerial().getValue().equals(x509Cert.getSerialNumber()) && this.matchesDN(PrincipalUtil.getIssuerX509Principal(x509Cert), this.holder.getBaseCertificateID().getIssuer());
                }
                if (this.holder.getEntityName() != null && this.matchesDN(PrincipalUtil.getSubjectX509Principal(x509Cert), this.holder.getEntityName())) {
                    return true;
                }
                if (this.holder.getObjectDigestInfo() == null) break block12;
                MessageDigest md = null;
                try {
                    md = MessageDigest.getInstance(this.getDigestAlgorithm(), "BC");
                }
                catch (Exception e) {
                    return false;
                }
                switch (this.getDigestedObjectType()) {
                    case 0: {
                        md.update(cert.getPublicKey().getEncoded());
                        break;
                    }
                    case 1: {
                        md.update(cert.getEncoded());
                    }
                }
                if (!Arrays.areEqual(md.digest(), this.getObjectDigest())) {
                    return false;
                }
            }
            catch (CertificateEncodingException e) {
                return false;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AttributeCertificateHolder)) {
            return false;
        }
        AttributeCertificateHolder other = (AttributeCertificateHolder)obj;
        return this.holder.equals(other.holder);
    }

    public int hashCode() {
        return this.holder.hashCode();
    }

    public boolean match(Object obj) {
        if (!(obj instanceof X509Certificate)) {
            return false;
        }
        return this.match((Certificate)obj);
    }
}

