/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import org.ejbca.cvc.AbstractDataField;
import org.ejbca.cvc.CVCTagEnum;

public abstract class ReferenceField
extends AbstractDataField {
    public static final long serialVersionUID = 1L;
    public String country = null;
    public String mnemonic = null;
    public String sequence = null;

    public ReferenceField(CVCTagEnum cVCTagEnum, String string, String string2, String string3) {
        super(cVCTagEnum);
        if (string.length() == 2) {
            if (this.isValidCountry(string)) {
                if (string2.length() != 0) {
                    if (string2.length() <= 9) {
                        if (string3.length() == 5) {
                            for (int i2 = 0; i2 < string3.length(); ++i2) {
                                if (Character.isLetterOrDigit(string3.charAt(i2))) {
                                    continue;
                                }
                                throw new IllegalArgumentException("Sequence number can only contain alphanumerics: " + string3);
                            }
                            this.country = string;
                            this.mnemonic = string2;
                            this.sequence = string3;
                            return;
                        }
                        throw new IllegalArgumentException("Sequence number must have length 5, was " + string3.length());
                    }
                    throw new IllegalArgumentException("Holder mnemonic too long, max=9, was " + string2.length());
                }
                throw new IllegalArgumentException("Holder mnemonic too short, must have at least one character");
            }
            throw new IllegalArgumentException("Unknown country code: " + string);
        }
        throw new IllegalArgumentException("Country code length must be 2, was " + string.length());
    }

    public ReferenceField(CVCTagEnum object, byte[] byArray) {
        super((CVCTagEnum)((Object)object));
        String string;
        Object object2 = object = string;
        Object object3 = object;
        super(byArray);
        this.country = ((String)object3).substring(0, 2);
        this.mnemonic = ((String)object2).substring(2, ((String)object2).length() - 5);
        this.sequence = string.substring(string.length() - 5);
    }

    private boolean okChar(char c2) {
        return c2 >= 'A' && c2 <= 'Z';
    }

    private boolean isValidCountry(String string) {
        return this.okChar(string.charAt(0)) && this.okChar(string.charAt(1));
    }

    public String getConcatenated() {
        return this.country + this.mnemonic + this.sequence;
    }

    public String getCountry() {
        return this.country;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public String getSequence() {
        return this.sequence;
    }

    @Override
    public byte[] getEncoded() {
        return this.getConcatenated().getBytes();
    }

    @Override
    public String valueAsText() {
        return this.country + "/" + this.mnemonic + "/" + this.sequence;
    }
}

