/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVUtil;
import org.eid_bc.bouncycastle.asn1.ASN1Encodable;
import org.eid_bc.bouncycastle.asn1.ASN1InputStream;
import org.eid_bc.bouncycastle.asn1.ASN1Integer;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.asn1.ASN1Sequence;
import org.eid_bc.bouncycastle.asn1.pkcs.DHParameter;
import org.eid_bc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.eid_bc.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.eid_bc.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.eid_bc.bouncycastle.asn1.x9.X962NamedCurves;
import org.eid_bc.bouncycastle.asn1.x9.X9ECParameters;
import org.eid_bc.bouncycastle.crypto.params.DHParameters;
import org.eid_bc.bouncycastle.crypto.params.ECDomainParameters;
import org.eid_bc.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.eid_bc.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.eid_bc.bouncycastle.jce.interfaces.ECPublicKey;
import org.eid_bc.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eid_bc.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.eid_bc.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.eid_bc.bouncycastle.math.ec.ECCurve;
import org.eid_bc.bouncycastle.math.ec.ECFieldElement;
import org.eid_bc.bouncycastle.math.ec.ECPoint;
import org.jmrtd.PACESecretKeySpec;
import org.jmrtd.lds.PACEInfo;
import org.jmrtd.lds.SecurityInfo;
import org.jmrtd.lds.icao.MRZInfo;

public final class Util {
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final int ENC_MODE = 1;
    public static final int MAC_MODE = 2;
    public static final int PACE_MODE = 3;
    public static final Provider BC_PROVIDER = new BouncyCastleProvider();

    public static Provider getBouncyCastleProvider() {
        return BC_PROVIDER;
    }

    public static SecretKey deriveKey(byte[] byArray, int n2) {
        return Util.deriveKey(byArray, "DESede", 128, n2);
    }

    public static SecretKey deriveKey(byte[] byArray, String string, int n2, int n3) {
        return Util.deriveKey(byArray, string, n2, null, n3);
    }

    public static SecretKey deriveKey(byte[] byArray, String string, int n2, byte[] byArray2, int n3) {
        return Util.deriveKey(byArray, string, n2, byArray2, n3, (byte)0);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecretKey deriveKey(byte[] object, String string, int n2, byte[] byArray, int n3, byte by) {
        void var0_4;
        void var5_9;
        void var4_8;
        byte[] byArray2;
        void var2_6;
        void var1_5;
        MessageDigest messageDigest = Util.getMessageDigest(Util.inferDigestAlgorithmFromCipherAlgorithmForKeyDerivation((String)var1_5, (int)var2_6));
        messageDigest.reset();
        messageDigest.update((byte[])object);
        if (byArray2 != null) {
            messageDigest.update(byArray2);
        }
        MessageDigest messageDigest2 = messageDigest;
        messageDigest2.update(new byte[]{0, 0, 0, (byte)var4_8});
        byte[] byArray3 = messageDigest2.digest();
        byArray2 = null;
        if (!"DESede".equalsIgnoreCase((String)var1_5) && !"3DES".equalsIgnoreCase((String)var1_5)) {
            if ("AES".equalsIgnoreCase((String)var1_5) || var1_5.startsWith("AES")) {
                if (var2_6 != 128) {
                    if (var2_6 != 192) {
                        if (var2_6 != 256) throw new IllegalArgumentException("KDF can only use AES with 128-bit, 192-bit key or 256-bit length, found: " + (int)var2_6 + "-bit key length");
                        byArray2 = new byte[32];
                        System.arraycopy(byArray3, 0, byArray2, 0, 32);
                    } else {
                        byArray2 = new byte[24];
                        System.arraycopy(byArray3, 0, byArray2, 0, 24);
                    }
                } else {
                    byArray2 = new byte[16];
                    System.arraycopy(byArray3, 0, byArray2, 0, 16);
                }
            }
        } else {
            if (var2_6 != 112 && var2_6 != 128) {
                throw new IllegalArgumentException("KDF can only use DESede with 128-bit key length");
            }
            byte[] byArray4 = byArray3;
            byArray2 = new byte[24];
            System.arraycopy(byArray4, 0, byArray2, 0, 8);
            System.arraycopy(byArray4, 8, byArray2, 8, 8);
            System.arraycopy(byArray3, 0, byArray2, 16, 8);
        }
        if (var5_9 == false) {
            SecretKeySpec secretKeySpec;
            SecretKeySpec secretKeySpec2 = secretKeySpec;
            secretKeySpec = new SecretKeySpec(byArray2, (String)var1_5);
            return var0_4;
        } else {
            PACESecretKeySpec pACESecretKeySpec;
            PACESecretKeySpec pACESecretKeySpec2 = pACESecretKeySpec;
            pACESecretKeySpec = new PACESecretKeySpec(byArray2, (String)var1_5, (byte)var5_9);
        }
        return var0_4;
    }

    public static byte[] computeKeySeed(String string, String string2, String string3, String string4, boolean bl) {
        return Util.computeKeySeed(string + MRZInfo.checkDigit(string) + string2 + MRZInfo.checkDigit(string2) + string3 + MRZInfo.checkDigit(string3), string4, bl);
    }

    public static byte[] computeKeySeed(String object, String object2, boolean bl) {
        MessageDigest messageDigest = MessageDigest.getInstance((String)object2);
        messageDigest.update(Util.getBytes((String)object));
        object = messageDigest.digest();
        if (bl) {
            byte[] byArray = new byte[16];
            object2 = byArray;
            System.arraycopy(object, 0, object2, 0, 16);
            return byArray;
        }
        return object;
    }

    public static byte[] pad(byte[] byArray, int n2) {
        return Util.pad(byArray, 0, byArray.length, n2);
    }

    public static byte[] pad(byte[] byArray, int n2, int n3, int n4) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream2();
        byteArrayOutputStream.write(byArray, n2, n3);
        byteArrayOutputStream.write(-128);
        while (byteArrayOutputStream2.size() % n4 != 0) {
            byteArrayOutputStream2.write(0);
        }
        return byteArrayOutputStream2.toByteArray();
    }

    public static byte[] unpad(byte[] byArray) {
        int n2;
        for (n2 = byArray.length - 1; n2 >= 0 && byArray[n2] == 0; --n2) {
        }
        if ((byArray[n2] & 0xFF) == 128) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        throw new BadPaddingException("Expected constant 0x80, found 0x" + Integer.toHexString(byArray[n2] & 0xFF));
    }

    public static byte[] recoverMessage(int n2, byte[] byArray) {
        block7: {
            block8: {
                block11: {
                    int n3;
                    block10: {
                        block9: {
                            if (byArray == null || byArray.length < 1) break block7;
                            if ((byArray[byArray.length - 1] & 0xF ^ 0xC) != 0) break block8;
                            if ((byArray[byArray.length - 1] & 0xFF ^ 0xBC) != 0) break block9;
                            n3 = 1;
                            break block10;
                        }
                        if ((byArray[byArray.length - 1] & 0xFF ^ 0xCC) != 0) break block11;
                        n3 = 2;
                    }
                    if ((byArray[0] & 0xC0 ^ 0x40) == 0) {
                        if ((byArray[0] & 0x20) != 0) {
                            int n4;
                            for (n4 = 0; n4 < byArray.length && (byArray[n4] & 0xF ^ 0xA) != 0; ++n4) {
                            }
                            if ((n2 = byArray.length - n3 - n2 - ++n4) > 0) {
                                byte[] byArray2 = new byte[n2];
                                System.arraycopy(byArray, n4, byArray2, 0, n2);
                                return byArray2;
                            }
                            throw new NumberFormatException("Could not get M1");
                        }
                        throw new NumberFormatException("Could not get M1, first byte indicates partial recovery not enabled: " + Integer.toHexString(byArray[0]));
                    }
                    throw new NumberFormatException("Could not get M1");
                }
                throw new NumberFormatException("Not an ISO 9796-2 scheme 2 signature trailer");
            }
            throw new NumberFormatException("Could not get M1, malformed trailer");
        }
        throw new IllegalArgumentException("Plaintext is too short to recover message");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getRawECDSASignature(byte[] object, int n2) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream;
        ASN1InputStream aSN1InputStream;
        ASN1InputStream aSN1InputStream2 = aSN1InputStream;
        aSN1InputStream = new ASN1InputStream((byte[])object);
        object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Enumeration enumeration = ((ASN1Sequence)aSN1InputStream.readObject()).getObjects();
            while (enumeration.hasMoreElements()) {
                ((OutputStream)object).write(Util.alignKeyDataToSize(((ASN1Integer)enumeration.nextElement()).getValue().toByteArray(), n2));
            }
            Object object2 = object;
            ((OutputStream)object2).flush();
            byArray = ((ByteArrayOutputStream)object2).toByteArray();
        }
        catch (Throwable throwable) {
            aSN1InputStream2.close();
            ((ByteArrayOutputStream)object).close();
            throw throwable;
        }
        aSN1InputStream2.close();
        ((ByteArrayOutputStream)object).close();
        return byArray;
    }

    public static byte[] alignKeyDataToSize(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        if (byArray.length < n2) {
            n2 = byArray.length;
        }
        System.arraycopy(byArray, byArray.length - n2, byArray2, byArray2.length - n2, n2);
        return byArray2;
    }

    public static byte[] i2os(BigInteger bigInteger, int n2) {
        BigInteger bigInteger2 = BigInteger.valueOf(256L);
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            BigInteger bigInteger3 = bigInteger;
            bigInteger = bigInteger.mod(bigInteger2);
            BigInteger bigInteger4 = bigInteger3.divide(bigInteger2);
            byArray[n2 - 1 - i2] = (byte)bigInteger.intValue();
            bigInteger = bigInteger4;
        }
        return byArray;
    }

    public static byte[] i2os(BigInteger bigInteger) {
        int n2 = bigInteger.toString(16).length();
        if (n2 % 2 != 0) {
            ++n2;
        }
        return Util.i2os(bigInteger, n2 / 2);
    }

    public static BigInteger os2i(byte[] byArray) {
        if (byArray != null) {
            return Util.os2i(byArray, 0, byArray.length);
        }
        throw new IllegalArgumentException();
    }

    public static BigInteger os2i(byte[] byArray, int n2, int n3) {
        if (byArray != null) {
            BigInteger bigInteger = BigInteger.ZERO;
            BigInteger bigInteger2 = BigInteger.valueOf(256L);
            BigInteger bigInteger3 = bigInteger;
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                bigInteger3 = bigInteger3.multiply(bigInteger2).add(BigInteger.valueOf(byArray[i2] & 0xFF));
            }
            return bigInteger3;
        }
        throw new IllegalArgumentException();
    }

    public static BigInteger os2fe(byte[] byArray, BigInteger bigInteger) {
        return Util.os2i(byArray).mod(bigInteger);
    }

    public static String inferDigestAlgorithmFromSignatureAlgorithm(String string) {
        if (string != null) {
            String string2 = string;
            string = null;
            String string3 = string2.toUpperCase();
            if (string3.contains("WITH")) {
                string = string3.split("WITH")[0];
            }
            if ("SHA1".equalsIgnoreCase(string)) {
                string = "SHA-1";
            } else if ("SHA224".equalsIgnoreCase(string)) {
                string = "SHA-224";
            } else if ("SHA256".equalsIgnoreCase(string)) {
                string = "SHA-256";
            } else if ("SHA384".equalsIgnoreCase(string)) {
                string = "SHA-384";
            } else if ("SHA512".equalsIgnoreCase(string)) {
                string = "SHA-512";
            }
            return string;
        }
        throw new IllegalArgumentException();
    }

    public static String inferDigestAlgorithmFromCipherAlgorithmForKeyDerivation(String string, int n2) {
        if (string != null) {
            if (!"DESede".equals(string) && !"AES-128".equals(string)) {
                if ("AES".equals(string) && n2 == 128) {
                    return "SHA-1";
                }
                if (!"AES-256".equals(string) && !"AES-192".equals(string)) {
                    if ("AES".equals(string) && (n2 == 192 || n2 == 256)) {
                        return "SHA-256";
                    }
                    throw new IllegalArgumentException("Unsupported cipher algorithm or key length \"" + string + "\", " + n2);
                }
                return "SHA-256";
            }
            return "SHA-1";
        }
        throw new IllegalArgumentException();
    }

    public static DHParameterSpec toExplicitDHParameterSpec(DHParameters dHParameters) {
        Object object;
        DHParameters dHParameters2 = dHParameters;
        BigInteger bigInteger = dHParameters2.getP();
        BigInteger bigInteger2 = dHParameters2.getG();
        Object object2 = dHParameters2.getQ();
        int n2 = dHParameters.getL();
        if (object2 == null) {
            DHParameterSpec dHParameterSpec;
            object2 = dHParameterSpec;
            dHParameterSpec = new DHParameterSpec(bigInteger, bigInteger2, n2);
            object = object2;
        } else {
            PACEInfo.DHCParameterSpec dHCParameterSpec;
            object = dHCParameterSpec;
            dHCParameterSpec = new PACEInfo.DHCParameterSpec(bigInteger, bigInteger2, (BigInteger)object2);
        }
        return object;
    }

    public static String getDetailedPublicKeyAlgorithm(PublicKey object) {
        if (object == null) {
            return "null";
        }
        PublicKey publicKey = object;
        String string = publicKey.getAlgorithm();
        if (publicKey instanceof RSAPublicKey) {
            string = string + " [" + ((RSAPublicKey)object).getModulus().bitLength() + " bit]";
        } else if (object instanceof java.security.interfaces.ECPublicKey) {
            if ((object = Util.getCurveName(((java.security.interfaces.ECPublicKey)object).getParams())) != null) {
                string = string + " [" + (String)object + "]";
            }
        } else if (object instanceof DHPublicKey) {
            DHPublicKey dHPublicKey = (DHPublicKey)object;
            dHPublicKey.getY();
            DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
            object = dHParameterSpec.getG();
            int n2 = dHParameterSpec.getL();
            string = string + " [p.length = " + dHParameterSpec.getP().bitLength() + ", g.length = " + ((BigInteger)object).bitLength() + ", l = " + n2 + "]";
        }
        return string;
    }

    public static String getDetailedPrivateKeyAlgorithm(PrivateKey object) {
        if (object == null) {
            return "null";
        }
        PrivateKey privateKey = object;
        String string = privateKey.getAlgorithm();
        if (privateKey instanceof RSAPrivateKey) {
            string = string + " [" + ((RSAPrivateKey)object).getModulus().bitLength() + " bit]";
        } else if (object instanceof ECPrivateKey && (object = Util.getCurveName(((ECPrivateKey)object).getParams())) != null) {
            string = string + " [" + (String)object + "]";
        }
        return string;
    }

    public static String getCurveName(ECParameterSpec eCParameterSpec) {
        return (eCParameterSpec = Util.toNamedCurveSpec(eCParameterSpec)) == null ? null : eCParameterSpec.getName();
    }

    public static ECParameterSpec toExplicitECParameterSpec(ECNamedCurveParameterSpec eCNamedCurveParameterSpec) {
        return Util.toExplicitECParameterSpec((ECParameterSpec)Util.toECNamedCurveSpec(eCNamedCurveParameterSpec));
    }

    /*
     * Unable to fully structure code
     */
    public static ECParameterSpec toExplicitECParameterSpec(ECParameterSpec var0) {
        try {
            v0 = var0;
            v1 = v0;
            v2 = v0;
            v3 = v0;
            var1_1 = v0.getGenerator();
        }
        catch (Exception var1_2) {
            Util.LOGGER.log(Level.WARNING, "Could not make named EC param spec explicit", var1_2);
            return var0;
        }
        var2_3 = v1.getOrder();
        var3_4 = v2.getCofactor();
        v4 = v3.getCurve();
        v5 = v4;
        v6 = v4;
        var4_5 = v4.getA();
        var5_6 = v6.getB();
        var6_7 = v5.getField();
        if (!(var6_7 instanceof ECFieldFp)) ** GOTO lbl34
        var6_7 = ((ECFieldFp)var6_7).getP();
        var7_10 = v7;
        v7 = new ECFieldFp((BigInteger)var6_7);
        var6_7 = v8;
        v8 = new EllipticCurve(var7_10, var4_5, var5_6);
        return new ECParameterSpec((EllipticCurve)var6_7, var1_1, var2_3, var3_4);
lbl34:
        // 1 sources

        if (!(var6_7 instanceof ECFieldF2m)) ** GOTO lbl44
        var6_8 = ((ECFieldF2m)var6_7).getM();
        var7_11 = v9;
        v9 = new ECFieldF2m(var6_8);
        var6_9 = v10;
        v10 = new EllipticCurve(var7_11, var4_5, var5_6);
        return new ECParameterSpec(var6_9, var1_1, var2_3, var3_4);
lbl44:
        // 1 sources

        Util.LOGGER.warning("Could not make named EC param spec explicit");
        return var0;
    }

    public static ECNamedCurveSpec toNamedCurveSpec(ECParameterSpec object) {
        ArrayList arrayList;
        if (object == null) {
            return null;
        }
        if (object instanceof ECNamedCurveSpec) {
            return (ECNamedCurveSpec)object;
        }
        object = arrayList;
        arrayList = new ArrayList();
        Iterator iterator = Collections.list(ECNamedCurveTable.getNames()).iterator();
        while (iterator.hasNext()) {
            String cfr_ignored_0 = (String)iterator.next();
        }
        if (object.isEmpty()) {
            return null;
        }
        if (object.size() == 1) {
            return (ECNamedCurveSpec)object.get(0);
        }
        return (ECNamedCurveSpec)object.get(0);
    }

    public static ECNamedCurveSpec toECNamedCurveSpec(ECNamedCurveParameterSpec object) {
        ECNamedCurveParameterSpec eCNamedCurveParameterSpec = object;
        object = eCNamedCurveParameterSpec.getName();
        ECCurve eCCurve = eCNamedCurveParameterSpec.getCurve();
        ECPoint eCPoint = eCNamedCurveParameterSpec.getG();
        BigInteger bigInteger = eCNamedCurveParameterSpec.getN();
        BigInteger bigInteger2 = eCNamedCurveParameterSpec.getH();
        byte[] byArray = eCNamedCurveParameterSpec.getSeed();
        return new ECNamedCurveSpec((String)object, eCCurve, eCPoint, bigInteger, bigInteger2, byArray);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static SubjectPublicKeyInfo toSubjectPublicKeyInfo(PublicKey publicKey) {
        AlgorithmIdentifier algorithmIdentifier;
        String string;
        block30: {
            AlgorithmIdentifier algorithmIdentifier2;
            X9ECParameters x9ECParameters;
            SubjectPublicKeyInfo subjectPublicKeyInfo;
            block31: {
                X9ECParameters x9ECParameters2;
                String string2;
                block29: {
                    ASN1InputStream aSN1InputStream;
                    block28: {
                        ASN1InputStream aSN1InputStream2;
                        string = publicKey.getAlgorithm();
                        if ("EC".equals(string) || "ECDH".equals(string) || publicKey instanceof java.security.interfaces.ECPublicKey) break block28;
                        if (!"DH".equals(string)) {
                            if (!(publicKey instanceof DHPublicKey)) throw new IllegalArgumentException("Unrecognized key type, found " + publicKey.getAlgorithm() + ", should be DH or ECDH");
                        }
                        PublicKey publicKey2 = publicKey;
                        {
                            catch (Exception exception) {
                                LOGGER.log(Level.WARNING, "Exception", exception);
                                return null;
                            }
                        }
                        string = aSN1InputStream2;
                        aSN1InputStream2 = new ASN1InputStream(publicKey.getEncoded());
                        publicKey = SubjectPublicKeyInfo.getInstance((Object)aSN1InputStream2.readObject()).getAlgorithm();
                        DHPublicKey dHPublicKey = (DHPublicKey)publicKey2;
                        DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
                        String string3 = string;
                        SubjectPublicKeyInfo subjectPublicKeyInfo2 = new SubjectPublicKeyInfo(new AlgorithmIdentifier(publicKey.getAlgorithm(), (ASN1Encodable)new DHParameter(dHParameterSpec.getP(), dHParameterSpec.getG(), dHParameterSpec.getL()).toASN1Primitive()), (ASN1Encodable)new ASN1Integer(dHPublicKey.getY()));
                        {
                            catch (Throwable throwable) {
                                string.close();
                                throw throwable;
                            }
                        }
                        string3.close();
                        return subjectPublicKeyInfo2;
                    }
                    string = aSN1InputStream;
                    aSN1InputStream = new ASN1InputStream(publicKey.getEncoded());
                    subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)aSN1InputStream.readObject());
                    algorithmIdentifier = subjectPublicKeyInfo.getAlgorithm();
                    string2 = algorithmIdentifier.getAlgorithm().getId();
                    if (!SecurityInfo.ID_EC_PUBLIC_KEY.equals(string2)) throw new IllegalStateException("Was expecting id-ecPublicKey (" + SecurityInfo.ID_EC_PUBLIC_KEY_TYPE + "), found " + string2);
                    algorithmIdentifier = algorithmIdentifier.getParameters().toASN1Primitive();
                    if (algorithmIdentifier instanceof ASN1ObjectIdentifier) break block29;
                    string.close();
                    return subjectPublicKeyInfo;
                }
                algorithmIdentifier = (ASN1ObjectIdentifier)algorithmIdentifier;
                string2 = X962NamedCurves.getByOID((ASN1ObjectIdentifier)algorithmIdentifier);
                if (string2 == null) break block30;
                PublicKey publicKey3 = publicKey;
                algorithmIdentifier = string2.getG();
                algorithmIdentifier = algorithmIdentifier.getCurve().createPoint(algorithmIdentifier.getAffineXCoord().toBigInteger(), algorithmIdentifier.getAffineYCoord().toBigInteger());
                x9ECParameters = x9ECParameters2;
                x9ECParameters2 = new X9ECParameters(string2.getCurve(), (ECPoint)algorithmIdentifier, string2.getN(), string2.getH(), string2.getSeed());
                if (publicKey3 instanceof ECPublicKey) break block31;
                string.close();
                return subjectPublicKeyInfo;
            }
            ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
            publicKey = algorithmIdentifier2;
            algorithmIdentifier2 = new AlgorithmIdentifier(subjectPublicKeyInfo.getAlgorithm().getAlgorithm(), (ASN1Encodable)x9ECParameters.toASN1Primitive());
            subjectPublicKeyInfo = eCPublicKey.getQ();
            String string4 = string;
            SubjectPublicKeyInfo subjectPublicKeyInfo3 = new SubjectPublicKeyInfo((AlgorithmIdentifier)publicKey, subjectPublicKeyInfo.getEncoded(false));
            string4.close();
            return subjectPublicKeyInfo3;
        }
        try {
            throw new IllegalStateException("Could not find X9.62 named curve for OID " + algorithmIdentifier.getId());
        }
        catch (Throwable throwable) {
            string.close();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public static PublicKey toPublicKey(SubjectPublicKeyInfo object) {
        X509EncodedKeySpec x509EncodedKeySpec;
        object /* !! */  = object /* !! */ .getEncoded("DER");
        X509EncodedKeySpec x509EncodedKeySpec2 = x509EncodedKeySpec;
        x509EncodedKeySpec = new X509EncodedKeySpec((byte[])object /* !! */ );
        {
            catch (GeneralSecurityException generalSecurityException) {
                LOGGER.log(Level.WARNING, "Exception", generalSecurityException);
                return null;
            }
        }
        try {
            return KeyFactory.getInstance("DH").generatePublic(x509EncodedKeySpec2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOGGER.log(Level.FINE, "Not DH public key? Fine, let's try EC public key", generalSecurityException);
            try {
                return KeyFactory.getInstance("EC", BC_PROVIDER).generatePublic(x509EncodedKeySpec2);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Exception", exception);
                return null;
            }
        }
    }

    public static PublicKey reconstructPublicKey(PublicKey publicKey) {
        ECPublicKeySpec eCPublicKeySpec;
        java.security.spec.ECPoint eCPoint;
        java.security.interfaces.ECPublicKey eCPublicKey;
        if (!(publicKey instanceof java.security.interfaces.ECPublicKey)) {
            return publicKey;
        }
        try {
            java.security.interfaces.ECPublicKey eCPublicKey2 = (java.security.interfaces.ECPublicKey)publicKey;
            eCPublicKey = eCPublicKey2;
            eCPoint = eCPublicKey2.getW();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Could not make public key param spec explicit", exception);
            return publicKey;
        }
        ECParameterSpec eCParameterSpec = Util.toExplicitECParameterSpec(eCPublicKey.getParams());
        ECPublicKeySpec eCPublicKeySpec2 = eCPublicKeySpec;
        eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
        return KeyFactory.getInstance("EC", BC_PROVIDER).generatePublic(eCPublicKeySpec2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static java.security.spec.ECPoint os2ECPoint(byte[] object) {
        Throwable throwable222222;
        DataInputStream dataInputStream;
        block13: {
            block12: {
                java.security.spec.ECPoint eCPoint;
                DataInputStream dataInputStream2;
                dataInputStream = dataInputStream2;
                if (new DataInputStream(new ByteArrayInputStream((byte[])object)).read() != 4) break block12;
                DataInputStream dataInputStream3 = dataInputStream;
                int n2 = (((byte[])object).length - 1) / 2;
                object = new byte[n2];
                Object object2 = new byte[n2];
                DataInputStream dataInputStream4 = dataInputStream;
                dataInputStream.readFully((byte[])object);
                dataInputStream4.readFully((byte[])object2);
                dataInputStream4.close();
                object = Util.os2i(object);
                object2 = Util.os2i(object2);
                java.security.spec.ECPoint eCPoint2 = eCPoint;
                eCPoint = new java.security.spec.ECPoint((BigInteger)object, (BigInteger)object2);
                try {
                    dataInputStream3.close();
                    return eCPoint2;
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, "Error closing stream", iOException);
                }
                return eCPoint2;
            }
            try {
                throw new IllegalArgumentException("Expected encoded ECPoint to start with 0x04");
            }
            catch (Throwable throwable222222) {
                break block13;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Exception", iOException);
            }
        }
        try {
            dataInputStream.close();
            throw throwable222222;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error closing stream", iOException);
        }
        throw throwable222222;
    }

    public static byte[] ecPoint2OS(java.security.spec.ECPoint object) {
        ByteArrayOutputStream byteArrayOutputStream;
        Object object2 = byteArrayOutputStream;
        java.security.spec.ECPoint eCPoint = object;
        ((ByteArrayOutputStream)object2)();
        object = eCPoint.getAffineX();
        object2 = eCPoint.getAffineY();
        try {
            byteArrayOutputStream.write(4);
            byteArrayOutputStream.write(Util.i2os((BigInteger)object));
            byteArrayOutputStream.write(Util.i2os((BigInteger)object2));
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Exception", iOException);
        }
    }

    public static String inferProtocolIdentifier(PublicKey object) {
        if (!"EC".equals(object = object.getAlgorithm()) && !"ECDH".equals(object)) {
            if ("DH".equals(object)) {
                return SecurityInfo.ID_PK_DH;
            }
            throw new IllegalArgumentException("Wrong key type. Was expecting ECDH or DH public key.");
        }
        return SecurityInfo.ID_PK_ECDH;
    }

    public static java.security.spec.ECPoint add(java.security.spec.ECPoint eCPoint, java.security.spec.ECPoint eCPoint2, ECParameterSpec eCParameterSpec) {
        return Util.fromBouncyCastleECPoint(Util.toBouncyCastleECPoint(eCPoint, eCParameterSpec).add(Util.toBouncyCastleECPoint(eCPoint2, eCParameterSpec)));
    }

    public static java.security.spec.ECPoint multiply(BigInteger bigInteger, java.security.spec.ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        return Util.fromBouncyCastleECPoint(Util.toBouncyCastleECPoint(eCPoint, eCParameterSpec).multiply(bigInteger));
    }

    public static byte[] getBytes(String object) {
        String string = object;
        object = string.getBytes();
        try {
            object = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
        }
        return object;
    }

    public static BigInteger getPrime(AlgorithmParameterSpec object) {
        if (object != null) {
            if (object instanceof DHParameterSpec) {
                return ((DHParameterSpec)object).getP();
            }
            if (object instanceof ECParameterSpec) {
                if ((object = ((ECParameterSpec)object).getCurve().getField()) instanceof ECFieldFp) {
                    return ((ECFieldFp)object).getP();
                }
                throw new IllegalStateException("Was expecting prime field of type ECFieldFp, found " + object.getClass().getCanonicalName());
            }
            throw new IllegalArgumentException("Unsupported agreement algorithm, was expecting DHParameterSpec or ECParameterSpec, found " + object.getClass().getCanonicalName());
        }
        throw new IllegalArgumentException("Parameters null");
    }

    public static String inferKeyAgreementAlgorithm(PublicKey publicKey) {
        if (publicKey instanceof java.security.interfaces.ECPublicKey) {
            return "ECDH";
        }
        if (publicKey instanceof DHPublicKey) {
            return "DH";
        }
        throw new IllegalArgumentException("Unsupported public key: " + publicKey);
    }

    public static BigInteger computeAffineY(BigInteger bigInteger, ECParameterSpec eCParameterSpec) {
        ECCurve eCCurve = Util.toBouncyCastleECCurve(eCParameterSpec);
        bigInteger = eCCurve.getA();
        eCParameterSpec = eCCurve.getB();
        ECFieldElement eCFieldElement = eCCurve.fromBigInteger(bigInteger);
        return eCFieldElement.multiply(eCFieldElement).add((ECFieldElement)bigInteger).multiply(eCFieldElement).add((ECFieldElement)eCParameterSpec).sqrt().toBigInteger();
    }

    public static ECPoint toBouncyCastleECPoint(java.security.spec.ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        return Util.toBouncyCastleECCurve(eCParameterSpec).createPoint(eCPoint.getAffineX(), eCPoint.getAffineY());
    }

    public static java.security.spec.ECPoint fromBouncyCastleECPoint(ECPoint eCPoint) {
        if (!(eCPoint = eCPoint.normalize()).isValid()) {
            LOGGER.warning("point not valid");
        }
        return new java.security.spec.ECPoint(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger());
    }

    public static boolean isValid(java.security.spec.ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        return Util.toBouncyCastleECPoint(eCPoint, eCParameterSpec).isValid();
    }

    public static java.security.spec.ECPoint normalize(java.security.spec.ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        return Util.fromBouncyCastleECPoint(Util.toBouncyCastleECPoint(eCPoint, eCParameterSpec).normalize());
    }

    public static ECCurve toBouncyCastleECCurve(ECParameterSpec eCParameterSpec) {
        Object object = eCParameterSpec.getCurve();
        Object object2 = ((EllipticCurve)object).getField();
        if (object2 instanceof ECFieldFp) {
            EllipticCurve ellipticCurve = object;
            ECParameterSpec eCParameterSpec2 = eCParameterSpec;
            int n2 = eCParameterSpec2.getCofactor();
            object = eCParameterSpec2.getOrder();
            object2 = ellipticCurve.getA();
            BigInteger bigInteger = ellipticCurve.getB();
            BigInteger bigInteger2 = Util.getPrime(eCParameterSpec);
            return new ECCurve.Fp(bigInteger2, (BigInteger)object2, bigInteger, (BigInteger)object, BigInteger.valueOf(n2));
        }
        throw new IllegalArgumentException("Only prime field supported (for now), found " + object2.getClass().getCanonicalName());
    }

    public static ECPublicKeyParameters toBouncyECPublicKeyParameters(java.security.interfaces.ECPublicKey object) {
        java.security.interfaces.ECPublicKey eCPublicKey = object;
        object = eCPublicKey.getParams();
        ECPoint eCPoint = Util.toBouncyCastleECPoint(eCPublicKey.getW(), (ECParameterSpec)object);
        return new ECPublicKeyParameters(eCPoint, Util.toBouncyECDomainParameters((ECParameterSpec)object));
    }

    public static ECPrivateKeyParameters toBouncyECPrivateKeyParameters(ECPrivateKey serializable) {
        ECPrivateKey eCPrivateKey = serializable;
        serializable = eCPrivateKey.getS();
        ECDomainParameters eCDomainParameters = Util.toBouncyECDomainParameters(eCPrivateKey.getParams());
        return new ECPrivateKeyParameters((BigInteger)serializable, eCDomainParameters);
    }

    public static ECDomainParameters toBouncyECDomainParameters(ECParameterSpec eCParameterSpec) {
        ECParameterSpec eCParameterSpec2 = eCParameterSpec;
        ECCurve eCCurve = Util.toBouncyCastleECCurve(eCParameterSpec2);
        eCParameterSpec = Util.toBouncyCastleECPoint(eCParameterSpec2.getGenerator(), eCParameterSpec);
        BigInteger bigInteger = eCParameterSpec2.getOrder();
        BigInteger bigInteger2 = BigInteger.valueOf(eCParameterSpec2.getCofactor());
        byte[] byArray = eCParameterSpec2.getCurve().getSeed();
        return new ECDomainParameters(eCCurve, (ECPoint)eCParameterSpec, bigInteger, bigInteger2, byArray);
    }

    public static Cipher getCipher(String string) {
        try {
            return Cipher.getInstance(string);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this cipher, falling aar_back to explicit BC", exception);
            return Cipher.getInstance(string, BC_PROVIDER);
        }
    }

    public static Cipher getCipher(String string, int n2, Key key) {
        try {
            Cipher cipher = Cipher.getInstance(string);
            cipher.init(n2, key);
            return cipher;
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Cipher, falling aar_back to explicit BC", exception);
            Cipher cipher = Cipher.getInstance(string, BC_PROVIDER);
            cipher.init(n2, key);
            return cipher;
        }
    }

    public static KeyAgreement getKeyAgreement(String string) {
        try {
            return KeyAgreement.getInstance(string);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Key Agreement, falling aar_back to explicit BC", exception);
            return KeyAgreement.getInstance(string, BC_PROVIDER);
        }
    }

    public static KeyPairGenerator getKeyPairGenerator(String string) {
        try {
            return KeyPairGenerator.getInstance(string);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Key Pair Generator, falling aar_back to explicit BC", exception);
            return KeyPairGenerator.getInstance(string, BC_PROVIDER);
        }
    }

    public static Mac getMac(String string) {
        try {
            return Mac.getInstance(string);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Mac, falling aar_back to explicit BC", exception);
            return Mac.getInstance(string, BC_PROVIDER);
        }
    }

    public static Mac getMac(String string, Key key) {
        try {
            Mac mac = Mac.getInstance(string);
            mac.init(key);
            return mac;
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Mac, falling aar_back to explicit BC", exception);
            Mac mac = Mac.getInstance(string, BC_PROVIDER);
            mac.init(key);
            return mac;
        }
    }

    public static MessageDigest getMessageDigest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Message Digest, falling aar_back to explicit BC", exception);
            return MessageDigest.getInstance(string, BC_PROVIDER);
        }
    }

    public static PublicKey getPublicKey(String string, KeySpec keySpec) {
        try {
            return KeyFactory.getInstance(string).generatePublic(keySpec);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Key Factory or Public Key, falling aar_back to explicit BC", exception);
            return KeyFactory.getInstance(string, BC_PROVIDER).generatePublic(keySpec);
        }
    }

    public static Signature getSignature(String string) {
        try {
            return Signature.getInstance(string);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Signature, falling aar_back to explicit BC", exception);
            return Signature.getInstance(string, BC_PROVIDER);
        }
    }

    public static CertificateFactory getCertificateFactory(String string) {
        try {
            return CertificateFactory.getInstance(string);
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, "Default provider could not provide this Certificate Factory, falling aar_back ot explicit BC", exception);
            return CertificateFactory.getInstance(string, BC_PROVIDER);
        }
    }

    /*
     * Loose catch block
     */
    public static byte[] toOIDBytes(String string) {
        TLVInputStream tLVInputStream;
        Object object = tLVInputStream;
        tLVInputStream = new TLVInputStream((InputStream)new ByteArrayInputStream(new ASN1ObjectIdentifier(string).getEncoded()));
        tLVInputStream.readTag();
        {
            catch (Throwable throwable) {
                object.close();
                throw throwable;
            }
        }
        tLVInputStream.readLength();
        object = tLVInputStream.readValue();
        try {
            tLVInputStream.close();
            return TLVUtil.wrapDO((int)128, (byte[])object);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Illegal OID: \"" + string, iOException);
        }
    }
}

