/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jmrtd.io.SplittableInputStream;
import org.jmrtd.lds.ImageInfo;

public abstract class AbstractImageInfo
implements ImageInfo {
    public static final long serialVersionUID = 2870092217269116309L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public int type;
    public String mimeType;
    public byte[] imageBytes;
    public transient SplittableInputStream splittableInputStream;
    public int imagePositionInInputStream;
    public int imageLength;
    public int width;
    public int height;

    public AbstractImageInfo() {
        this(-1, 0, 0, null);
    }

    public AbstractImageInfo(int n2) {
        this(n2, 0, 0, null);
    }

    public AbstractImageInfo(int n2, String string) {
        this(n2, 0, 0, string);
    }

    public AbstractImageInfo(int n2, int n3, int n4, String string) {
        this.type = n2;
        this.mimeType = string;
        this.width = n3;
        this.height = n4;
    }

    public AbstractImageInfo(int n2, int n3, int n4, InputStream inputStream, long l2, String string) {
        this(n2, n3, n4, string);
        this.readImage(inputStream, l2);
    }

    private byte[] getImageBytes() {
        byte[] byArray = new byte[((AbstractImageInfo)((Object)inputStream)).getImageLength()];
        InputStream inputStream = ((AbstractImageInfo)((Object)inputStream)).getImageInputStream();
        new DataInputStream(inputStream).readFully(byArray);
        return byArray;
    }

    public static String typeToString(int n2) {
        switch (n2) {
            default: {
                throw new NumberFormatException("Unknown type: " + Integer.toHexString(n2));
            }
            case 3: {
                return "Iris";
            }
            case 2: {
                return "Finger";
            }
            case 1: {
                return "Signature or usual mark";
            }
            case 0: {
                return "Portrait";
            }
            case -1: 
        }
        return "Unknown";
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getImageLength() {
        if (((AbstractImageInfo)object).splittableInputStream != null) {
            return ((AbstractImageInfo)object).imageLength;
        }
        Object object = ((AbstractImageInfo)object).imageBytes;
        if (((AbstractImageInfo)object).imageBytes != null) {
            return ((Object)object).length;
        }
        throw new IllegalStateException("Cannot get length of null");
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [type: " + AbstractImageInfo.typeToString(this.type) + ", size: " + this.getImageLength() + "]";
    }

    public int hashCode() {
        AbstractImageInfo abstractImageInfo = this;
        int n2 = -591263623 + abstractImageInfo.type * 5;
        int n3 = 5;
        String string = abstractImageInfo.mimeType;
        return n2 + ((string == null ? 1337 : string.hashCode()) * n3 + 7) + (this.getImageLength() * 7 + 11);
    }

    public boolean equals(Object object) {
        boolean bl;
        block15: {
            block12: {
                block14: {
                    block13: {
                        block11: {
                            if (object == null) {
                                return false;
                            }
                            if (object == this) {
                                return true;
                            }
                            try {
                                if (object.getClass().equals(this.getClass())) break block11;
                                return false;
                            }
                            catch (Exception exception) {
                                LOGGER.log(Level.WARNING, "Exception" + exception);
                                return false;
                            }
                        }
                        AbstractImageInfo abstractImageInfo = this;
                        object = (AbstractImageInfo)object;
                        if (!Arrays.equals(abstractImageInfo.getImageBytes(), super.getImageBytes())) break block12;
                        if (this.mimeType != null) break block13;
                        if (((AbstractImageInfo)object).mimeType == null) break block14;
                    }
                    if (this.mimeType == null) break block12;
                    if (!this.mimeType.equals(((AbstractImageInfo)object).mimeType)) break block12;
                }
                if (this.type != ((AbstractImageInfo)object).type) break block12;
                bl = true;
                break block15;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream;
        AbstractImageInfo abstractImageInfo = byteArrayOutputStream2;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        try {
            abstractImageInfo.writeObject(new ByteArrayOutputStream());
            return byteArrayOutputStream2.toByteArray();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception", iOException);
            return null;
        }
    }

    @Override
    public InputStream getImageInputStream() {
        SplittableInputStream splittableInputStream = ((AbstractImageInfo)object).splittableInputStream;
        if (splittableInputStream != null) {
            return splittableInputStream.getInputStream(((AbstractImageInfo)object).imagePositionInInputStream);
        }
        Object object = ((AbstractImageInfo)object).imageBytes;
        if (((AbstractImageInfo)object).imageBytes != null) {
            return new ByteArrayInputStream((byte[])object);
        }
        throw new IllegalStateException("Both the byte buffer and the stream are null");
    }

    public void readImage(InputStream inputStream, long l2) {
        this.splittableInputStream = null;
        this.imageBytes = new byte[(int)l2];
        new DataInputStream(inputStream).readFully(this.imageBytes);
    }

    public void writeImage(OutputStream outputStream) {
        outputStream.write(this.getImageBytes());
    }

    public final void setMimeType(String string) {
        this.mimeType = string;
    }

    public final void setType(int n2) {
        this.type = n2;
    }

    public final void setWidth(int n2) {
        this.width = n2;
    }

    public final void setHeight(int n2) {
        this.height = n2;
    }

    public final void setImageBytes(byte[] byArray) {
        if (byArray != null) {
            AbstractImageInfo abstractImageInfo = this;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            long l2 = byArray.length;
            try {
                abstractImageInfo.readImage(byteArrayInputStream, l2);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Exception", iOException);
            }
            return;
        }
        throw new IllegalArgumentException("Cannot set null image bytes");
    }

    public abstract void readObject(InputStream var1);

    public abstract void writeObject(OutputStream var1);
}

