/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.icao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jmrtd.cbeff.BiometricDataBlockDecoder;
import org.jmrtd.cbeff.BiometricDataBlockEncoder;
import org.jmrtd.cbeff.CBEFFInfo;
import org.jmrtd.cbeff.ComplexCBEFFInfo;
import org.jmrtd.cbeff.ISO781611Decoder;
import org.jmrtd.cbeff.ISO781611Encoder;
import org.jmrtd.cbeff.SimpleCBEFFInfo;
import org.jmrtd.cbeff.StandardBiometricHeader;
import org.jmrtd.lds.CBEFFDataGroup;
import org.jmrtd.lds.iso19794.FingerInfo;

public class DG3File
extends CBEFFDataGroup<FingerInfo> {
    public static final long serialVersionUID = -1037522331623814528L;
    public static final ISO781611Decoder DECODER = new ISO781611Decoder(new BiometricDataBlockDecoder<FingerInfo>(){

        @Override
        public FingerInfo decode(InputStream inputStream, StandardBiometricHeader standardBiometricHeader, int n2, int n3) {
            return new FingerInfo(standardBiometricHeader, inputStream);
        }
    });
    public static final ISO781611Encoder<FingerInfo> ENCODER = new ISO781611Encoder<FingerInfo>(new BiometricDataBlockEncoder<FingerInfo>(){

        @Override
        public void encode(FingerInfo fingerInfo, OutputStream outputStream) {
            fingerInfo.writeObject(outputStream);
        }
    });
    public boolean shouldAddRandomDataIfEmpty;

    public DG3File(List<FingerInfo> list) {
        this(list, true);
    }

    public DG3File(List<FingerInfo> list, boolean bl) {
        super(99, list);
        this.shouldAddRandomDataIfEmpty = bl;
    }

    public DG3File(InputStream inputStream) {
        super(99, inputStream);
    }

    @Override
    public void readContent(InputStream object) {
        for (CBEFFInfo cBEFFInfo : DECODER.decode((InputStream)object).getSubRecords()) {
            if (cBEFFInfo instanceof SimpleCBEFFInfo) {
                if ((cBEFFInfo = ((SimpleCBEFFInfo)cBEFFInfo).getBiometricDataBlock()) instanceof FingerInfo) {
                    this.add((FingerInfo)((Object)cBEFFInfo));
                    continue;
                }
                throw new IOException("Was expecting a FingerInfo, found " + cBEFFInfo.getClass().getSimpleName());
            }
            throw new IOException("Was expecting a SimpleCBEFFInfo, found " + cBEFFInfo.getClass().getSimpleName());
        }
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        ComplexCBEFFInfo complexCBEFFInfo;
        ComplexCBEFFInfo complexCBEFFInfo2 = complexCBEFFInfo;
        complexCBEFFInfo = new ComplexCBEFFInfo();
        for (FingerInfo fingerInfo : this.getSubRecords()) {
            complexCBEFFInfo2.add(new SimpleCBEFFInfo<FingerInfo>(fingerInfo));
        }
        ENCODER.encode(complexCBEFFInfo2, outputStream);
        if (this.shouldAddRandomDataIfEmpty) {
            this.writeOptionalRandomData(outputStream);
        }
    }

    @Override
    public String toString() {
        return "DG3File [" + super.toString() + "]";
    }

    public List<FingerInfo> getFingerInfos() {
        return this.getSubRecords();
    }

    public void addFingerInfo(FingerInfo fingerInfo) {
        this.add(fingerInfo);
    }

    public void removeFingerInfo(int n2) {
        this.remove(n2);
    }

    @Override
    public int hashCode() {
        DG3File dG3File = this;
        int n2 = super.hashCode() * 31;
        int n3 = dG3File.shouldAddRandomDataIfEmpty ? 1231 : 1237;
        return n2 + n3;
    }

    @Override
    public boolean equals(Object object) {
        if (dG3File2 == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (DG3File.class != object.getClass()) {
            return false;
        }
        DG3File dG3File = dG3File2;
        DG3File dG3File2 = (DG3File)object;
        return dG3File.shouldAddRandomDataIfEmpty == dG3File2.shouldAddRandomDataIfEmpty;
    }
}

