/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.utils;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;

public class CountdownUpdater
implements Handler.Callback {
    public int countdown;
    public Callback callback;
    public volatile boolean isStop;
    public HandlerThread handlerThread;
    public Handler countDownHandler;

    public CountdownUpdater(int n, Callback callback) {
        CountdownUpdater countdownUpdater = this;
        this.isStop = false;
        this.countdown = n;
        countdownUpdater.callback = callback;
        countdownUpdater.handlerThread = new HandlerThread("CountdownUpdater");
        countdownUpdater.handlerThread.start();
        countdownUpdater.countDownHandler = new Handler(this.handlerThread.getLooper(), (Handler.Callback)this);
        countdownUpdater.handleMessage(countdownUpdater.countDownHandler.obtainMessage());
    }

    public static CountdownUpdater startCountDown(int n, Callback callback) {
        return new CountdownUpdater(n, callback);
    }

    public static CountdownUpdater startCountDown(Callback callback) {
        return CountdownUpdater.startCountDown(60, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quit() {
        HandlerThread handlerThread = this.handlerThread;
        if (handlerThread != null) {
            handlerThread.quit();
        }
        CountdownUpdater countdownUpdater = this;
        synchronized (countdownUpdater) {
            countdownUpdater.callback = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleMessage(Message object) {
        if (this.isStop) {
            return false;
        }
        object = this.callback;
        if (object != null) {
            object.onCountDownUpdate(this.countdown);
        }
        CountdownUpdater countdownUpdater = this;
        --countdownUpdater.countdown;
        if (countdownUpdater.countdown >= 0) {
            this.countDownHandler.sendEmptyMessageDelayed(0, 1000L);
            return false;
        }
        CountdownUpdater countdownUpdater2 = this;
        countdownUpdater2.isStop = true;
        synchronized (countdownUpdater2) {
            if (countdownUpdater2.callback != null) {
                this.callback.onCountdownCompleted();
            }
            CountdownUpdater countdownUpdater3 = this;
            // ** MonitorExit[v2] (shouldn't be in output)
            countdownUpdater3.quit();
            return false;
        }
    }

    public void pause() {
        CountdownUpdater countdownUpdater = this;
        countdownUpdater.countDownHandler.removeMessages(0);
        countdownUpdater.countDownHandler.removeCallbacks(null);
    }

    public void resume() {
        CountdownUpdater countdownUpdater = this;
        countdownUpdater.handleMessage(countdownUpdater.countDownHandler.obtainMessage());
    }

    public void cleanup() {
        CountdownUpdater countdownUpdater = this;
        countdownUpdater.isStop = true;
        countdownUpdater.countDownHandler.removeMessages(0);
        countdownUpdater.countDownHandler.removeCallbacks(null);
        countdownUpdater.quit();
    }

    public static interface Callback {
        public void onCountDownUpdate(int var1);

        public void onCountdownCompleted();
    }
}

