/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.CVCObject;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.FieldFactory;
import org.ejbca.cvc.GenericPublicKeyField;
import org.ejbca.cvc.KeyFactory;
import org.ejbca.cvc.SequenceFactory;
import org.ejbca.cvc.exception.ParseException;

public final class CertificateParser {
    public static CVCObject parseCVCObject(byte[] byArray) {
        return CertificateParser.decode(byArray, null);
    }

    public static CVCertificate parseCertificate(byte[] byArray) {
        return (CVCertificate)CertificateParser.decode(byArray, CVCTagEnum.CV_CERTIFICATE);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CVCObject decode(byte[] byArray, CVCTagEnum cVCTagEnum) {
        ByteArrayInputStream byteArrayInputStream;
        block9: {
            ByteArrayInputStream byteArrayInputStream2;
            Object var2_5 = null;
            byteArrayInputStream = byteArrayInputStream2;
            byteArrayInputStream2 = new ByteArrayInputStream(byArray);
            CVCObject cVCObject = CertificateParser.decode(new DataInputStream(byteArrayInputStream), cVCTagEnum);
            try {
                byteArrayInputStream.close();
                return cVCObject;
            }
            catch (IOException iOException) {
                throw new ParseException(iOException);
            }
            catch (Throwable throwable) {
                break block9;
            }
            catch (Throwable throwable) {
                byteArrayInputStream = var2_5;
            }
        }
        if (byteArrayInputStream == null) throw byArray;
        byteArrayInputStream.close();
        throw byArray;
    }

    public static CVCObject decode(DataInputStream dataInputStream, CVCTagEnum cVCTagEnum) {
        Object object = CertificateParser.findTagFromValue(CertificateParser.decodeTag(dataInputStream));
        if (cVCTagEnum != null && object != cVCTagEnum) {
            throw new ParseException("Expected first tag " + (Object)((Object)cVCTagEnum) + " but found " + object);
        }
        int n2 = CVCObject.decodeLength(dataInputStream);
        if (!((CVCTagEnum)((Object)object)).isSequence()) {
            byte[] byArray = new byte[n2];
            dataInputStream.read(byArray, 0, n2);
            return FieldFactory.decodeField((CVCTagEnum)((Object)object), byArray);
        }
        n2 = dataInputStream.available() - n2;
        object = SequenceFactory.createSequence((CVCTagEnum)((Object)object));
        while (dataInputStream.available() > n2) {
            ((AbstractSequence)object).addSubfield(CertificateParser.decode(dataInputStream, null));
        }
        if (object instanceof GenericPublicKeyField) {
            object = KeyFactory.createInstance((GenericPublicKeyField)object);
        }
        return object;
    }

    public static CVCTagEnum findTagFromValue(int n2) {
        CVCTagEnum cVCTagEnum3;
        block3: {
            CVCTagEnum cVCTagEnum2 = null;
            for (CVCTagEnum cVCTagEnum3 : CVCTagEnum.values()) {
                if (cVCTagEnum3.getValue() != n2) {
                    continue;
                }
                break block3;
            }
            cVCTagEnum3 = cVCTagEnum2;
        }
        if (cVCTagEnum3 != null) {
            return cVCTagEnum3;
        }
        throw new ParseException("Unknown CVC tag value " + Integer.toHexString(n2));
    }

    public static int decodeTag(DataInputStream dataInputStream) {
        int n2 = dataInputStream.readUnsignedByte();
        if ((n2 & 0x1F) == 31) {
            byte by = dataInputStream.readByte();
            n2 = (n2 << 8) + by;
        }
        return n2;
    }
}

