/*
 * Decompiled with CFR 0.152.
 */
package org.eid_bc.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eid_bc.bouncycastle.crypto.tls.OCSPStatusRequest;
import org.eid_bc.bouncycastle.crypto.tls.TlsFatalAlert;
import org.eid_bc.bouncycastle.crypto.tls.TlsUtils;

public class CertificateStatusRequest {
    protected short statusType;
    protected Object request;

    public CertificateStatusRequest(short statusType, Object request) {
        if (!CertificateStatusRequest.isCorrectType(statusType, request)) {
            throw new IllegalArgumentException("'request' is not an instance of the correct type");
        }
        this.statusType = statusType;
        this.request = request;
    }

    public short getStatusType() {
        return this.statusType;
    }

    public Object getRequest() {
        return this.request;
    }

    public OCSPStatusRequest getOCSPStatusRequest() {
        if (!CertificateStatusRequest.isCorrectType((short)1, this.request)) {
            throw new IllegalStateException("'request' is not an OCSPStatusRequest");
        }
        return (OCSPStatusRequest)this.request;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.statusType, output);
        switch (this.statusType) {
            case 1: {
                ((OCSPStatusRequest)this.request).encode(output);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static CertificateStatusRequest parse(InputStream input) throws IOException {
        OCSPStatusRequest result;
        short status_type = TlsUtils.readUint8(input);
        switch (status_type) {
            case 1: {
                result = OCSPStatusRequest.parse(input);
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new CertificateStatusRequest(status_type, result);
    }

    protected static boolean isCorrectType(short statusType, Object request) {
        switch (statusType) {
            case 1: {
                return request instanceof OCSPStatusRequest;
            }
        }
        throw new IllegalArgumentException("'statusType' is an unsupported CertificateStatusType");
    }
}

