/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.FileInfo;
import net.sf.scuba.smartcards.FileSystemStructured;

public class CardFileInputStream
extends InputStream {
    private static final Logger LOGGER = Logger.getLogger("net.sf.scuba");
    private FileInfo[] path;
    private final byte[] buffer;
    private int bufferLength;
    private int offsetBufferInFile;
    private int offsetInBuffer;
    private int markedOffset;
    private int fileLength;
    private FileSystemStructured fs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardFileInputStream(int maxBlockSize, FileSystemStructured fs) throws CardServiceException {
        FileSystemStructured var3 = this.fs = fs;
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            Object[] fsPath = fs.getSelectedPath();
            if (fsPath == null || fsPath.length < 1) {
                throw new CardServiceException("No valid file selected, path = " + Arrays.toString(fsPath));
            }
            this.path = new FileInfo[fsPath.length];
            System.arraycopy(fsPath, 0, this.path, 0, fsPath.length);
            this.fileLength = ((FileInfo)fsPath[fsPath.length - 1]).getFileLength();
            this.buffer = new byte[maxBlockSize];
            this.bufferLength = 0;
            this.offsetBufferInFile = 0;
            this.offsetInBuffer = 0;
            this.markedOffset = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        FileSystemStructured var1 = this.fs;
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            int le;
            try {
                if (!Arrays.equals(this.path, this.fs.getSelectedPath())) {
                    for (FileInfo fileInfo : this.path) {
                        this.fs.selectFile(fileInfo.getFID());
                    }
                }
            }
            catch (CardServiceException var10) {
                LOGGER.log(Level.WARNING, "Unexpected exception", var10);
                throw new IOException("Unexpected exception", var10);
            }
            int offsetInFile = this.offsetBufferInFile + this.offsetInBuffer;
            if (offsetInFile >= this.fileLength) {
                return -1;
            }
            if (this.offsetInBuffer >= this.bufferLength) {
                le = Math.min(this.buffer.length, this.fileLength - offsetInFile);
                try {
                    int newOffsetBufferInFile = this.offsetBufferInFile + this.bufferLength;
                    int newOffsetInBuffer = 0;
                    int newBufferLength = this.fillBufferFromFile(this.path, newOffsetBufferInFile, le);
                    this.offsetBufferInFile = newOffsetBufferInFile;
                    this.offsetInBuffer = newOffsetInBuffer;
                    this.bufferLength = newBufferLength;
                }
                catch (CardServiceException var8) {
                    throw new IOException("Unexpected exception", var8);
                }
                catch (Exception var9) {
                    throw new IOException("Unexpected exception", var9);
                }
            }
            le = this.buffer[this.offsetInBuffer] & 0xFF;
            ++this.offsetInBuffer;
            return le;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) {
        FileSystemStructured var3 = this.fs;
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            if (n < (long)(this.bufferLength - this.offsetInBuffer)) {
                this.offsetInBuffer = (int)((long)this.offsetInBuffer + n);
            } else {
                int offsetInFile = this.offsetBufferInFile + this.offsetInBuffer;
                this.offsetBufferInFile = (int)((long)offsetInFile + n);
                this.offsetInBuffer = 0;
                this.bufferLength = 0;
                int n2 = this.offsetBufferInFile + this.offsetInBuffer;
            }
            return n;
        }
    }

    @Override
    public synchronized int available() {
        return this.bufferLength - this.offsetInBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readLimit) {
        FileSystemStructured var2 = this.fs;
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            this.markedOffset = this.offsetBufferInFile + this.offsetInBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        FileSystemStructured var1 = this.fs;
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            if (this.markedOffset < 0) {
                throw new IOException("Mark not set");
            }
            this.offsetBufferInFile = this.markedOffset;
            this.offsetInBuffer = 0;
            this.bufferLength = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        FileSystemStructured var1 = this.fs;
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            return true;
        }
    }

    public int getLength() {
        return this.fileLength;
    }

    public int getPostion() {
        return this.offsetBufferInFile + this.offsetInBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fillBufferFromFile(FileInfo[] path, int offsetInFile, int le) throws CardServiceException {
        FileSystemStructured var4 = this.fs;
        FileSystemStructured fileSystemStructured = this.fs;
        synchronized (fileSystemStructured) {
            if (le > this.buffer.length) {
                throw new IllegalArgumentException("length too big");
            }
            if (!Arrays.equals(this.fs.getSelectedPath(), path)) {
                FileInfo[] var5 = path;
                int var6 = path.length;
                for (int var7 = 0; var7 < var6; ++var7) {
                    FileInfo fileInfo = var5[var7];
                    this.fs.selectFile(fileInfo.getFID());
                }
            }
            byte[] data = this.fs.readBinary(offsetInFile, le);
            System.arraycopy(data, 0, this.buffer, 0, data.length);
            return data.length;
        }
    }
}

