/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.CVCTagEnum;

public abstract class CVCObject
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final int CVC_VERSION = 0;
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final int INT_LENGTH = 4;
    public static final int LONG_LENGTH = 8;
    public final CVCTagEnum tag;
    public AbstractSequence parent;

    public CVCObject(CVCTagEnum cVCTagEnum) {
        this.tag = cVCTagEnum;
    }

    public static byte[] encodeLength(int n2) {
        int n3 = 0;
        if (n2 > 127) {
            n3 = 1;
            if (n2 > 255) {
                n3 = 2;
            }
        }
        int n4 = n3;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n4 + 1);
        if (n4 == 0) {
            byteBuffer.put(0, (byte)n2);
        } else {
            byteBuffer.put(0, (byte)(n3 + 128));
            if (n3 == 1) {
                byteBuffer.put(1, (byte)n2);
            } else {
                byteBuffer.putShort(1, (short)n2);
            }
        }
        return byteBuffer.array();
    }

    public static int decodeLength(DataInputStream dataInputStream) {
        int n2 = dataInputStream.read();
        if (n2 > 127) {
            n2 = (n2 & 0xF) == 1 ? dataInputStream.readUnsignedByte() : (int)dataInputStream.readShort();
        }
        return n2;
    }

    public static byte[] toByteArray(Integer n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n2);
        return CVCObject.trimByteArray(byteBuffer.array());
    }

    public static byte[] toByteArray(Long l2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(l2);
        return CVCObject.trimByteArray(byteBuffer.array());
    }

    public static byte[] trimByteArray(byte[] byArray) {
        boolean bl = false;
        int n2 = 0;
        while (true) {
            if (n2 >= byArray.length || (bl = byArray[n2] != 0)) {
                byte[] byArray2;
                if (bl) {
                    byArray2 = new byte[byArray.length - n2];
                    System.arraycopy(byArray, n2, byArray2, 0, byArray.length - n2);
                } else {
                    byte[] byArray3 = new byte[1];
                    byArray2 = byArray3;
                    byArray3[0] = 0;
                }
                return byArray2;
            }
            ++n2;
        }
    }

    public CVCTagEnum getTag() {
        return this.tag;
    }

    public AbstractSequence getParent() {
        return this.parent;
    }

    public void setParent(AbstractSequence abstractSequence) {
        this.parent = abstractSequence;
    }

    public abstract int encode(DataOutputStream var1);

    public String getAsText() {
        return this.getAsText("", true);
    }

    public String getAsText(boolean bl) {
        return this.getAsText("", bl);
    }

    public String getAsText(String string) {
        return this.getAsText(string, true);
    }

    public String getAsText(String string, boolean bl) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer2();
        stringBuffer.append(string);
        if (bl) {
            stringBuffer2.append(Integer.toHexString(this.getTag().getValue())).append(' ');
        }
        StringBuffer stringBuffer3 = stringBuffer2;
        stringBuffer3.append(this.getTag().name()).append("  ");
        return stringBuffer3.toString();
    }
}

