/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.ByteField;
import org.ejbca.cvc.CVCObject;
import org.ejbca.cvc.CVCPublicKey;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.GenericPublicKeyField;
import org.ejbca.cvc.OIDField;

public class PublicKeyRSA
extends CVCPublicKey
implements RSAPublicKey {
    public static final long serialVersionUID = 1L;
    public static CVCTagEnum[] allowedFields = new CVCTagEnum[]{CVCTagEnum.OID, CVCTagEnum.MODULUS, CVCTagEnum.EXPONENT};

    public PublicKeyRSA(GenericPublicKeyField genericPublicKeyField) {
        ByteField byteField = (ByteField)genericPublicKeyField.getSubfield(CVCTagEnum.MODULUS);
        byteField.setShowBitLength(true);
        this.addSubfield(genericPublicKeyField.getSubfield(CVCTagEnum.OID));
        this.addSubfield(byteField);
        this.addSubfield(genericPublicKeyField.getSubfield(CVCTagEnum.EXPONENT));
    }

    public PublicKeyRSA(OIDField oIDField, RSAPublicKey rSAPublicKey) {
        PublicKeyRSA publicKeyRSA = this;
        publicKeyRSA.addSubfield(oIDField);
        publicKeyRSA.addSubfield(new ByteField(CVCTagEnum.MODULUS, CVCObject.trimByteArray(rSAPublicKey.getModulus().toByteArray()), true));
        publicKeyRSA.addSubfield(new ByteField(CVCTagEnum.EXPONENT, CVCObject.trimByteArray(rSAPublicKey.getPublicExponent().toByteArray())));
    }

    @Override
    public CVCTagEnum[] getAllowedFields() {
        return allowedFields;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public String getFormat() {
        return "CVC";
    }

    @Override
    public BigInteger getPublicExponent() {
        try {
            CVCObject cVCObject = (ByteField)((AbstractSequence)cVCObject).getSubfield(CVCTagEnum.EXPONENT);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException(noSuchFieldException);
        }
        return new BigInteger(1, ((ByteField)cVCObject).getData());
    }

    @Override
    public BigInteger getModulus() {
        try {
            CVCObject cVCObject = (ByteField)((AbstractSequence)cVCObject).getSubfield(CVCTagEnum.MODULUS);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException(noSuchFieldException);
        }
        return new BigInteger(1, ((ByteField)cVCObject).getData());
    }
}

