/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.security.NoSuchAlgorithmException;
import org.eid_bc.bouncycastle.asn1.ASN1Encodable;
import org.eid_bc.bouncycastle.asn1.ASN1EncodableVector;
import org.eid_bc.bouncycastle.asn1.ASN1Integer;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.asn1.ASN1Primitive;
import org.eid_bc.bouncycastle.asn1.DLSequence;
import org.jmrtd.lds.SecurityInfo;

public class ActiveAuthenticationInfo
extends SecurityInfo {
    public static final long serialVersionUID = 6830847342039845308L;
    public static final int VERSION_1 = 1;
    public static final String ECDSA_PLAIN_SIGNATURES = "0.4.0.127.0.7.1.1.4.1";
    public static final String ECDSA_PLAIN_SHA1_OID = "0.4.0.127.0.7.1.1.4.1.1";
    public static final String ECDSA_PLAIN_SHA224_OID = "0.4.0.127.0.7.1.1.4.1.2";
    public static final String ECDSA_PLAIN_SHA256_OID = "0.4.0.127.0.7.1.1.4.1.3";
    public static final String ECDSA_PLAIN_SHA384_OID = "0.4.0.127.0.7.1.1.4.1.4";
    public static final String ECDSA_PLAIN_SHA512_OID = "0.4.0.127.0.7.1.1.4.1.5";
    public static final String ECDSA_PLAIN_RIPEMD160_OID = "0.4.0.127.0.7.1.1.4.1.6";
    public String oid;
    public int version;
    public String signatureAlgorithmOID;

    public ActiveAuthenticationInfo(String string, int n2, String string2) {
        this.oid = string;
        this.version = n2;
        this.signatureAlgorithmOID = string2;
        this.checkFields();
    }

    public ActiveAuthenticationInfo(String string) {
        this("2.23.136.1.1.5", 1, string);
    }

    public static String lookupMnemonicByOID(String string) {
        if (ECDSA_PLAIN_SHA1_OID.equals(string)) {
            return "SHA1withECDSA";
        }
        if (ECDSA_PLAIN_SHA224_OID.equals(string)) {
            return "SHA224withECDSA";
        }
        if (ECDSA_PLAIN_SHA256_OID.equals(string)) {
            return "SHA256withECDSA";
        }
        if (ECDSA_PLAIN_SHA384_OID.equals(string)) {
            return "SHA384withECDSA";
        }
        if (ECDSA_PLAIN_SHA512_OID.equals(string)) {
            return "SHA512withECDSA";
        }
        if (ECDSA_PLAIN_RIPEMD160_OID.equals(string)) {
            return "RIPEMD160withECDSA";
        }
        throw new NoSuchAlgorithmException("Unknown OID " + string);
    }

    public static boolean checkRequiredIdentifier(String string) {
        return "2.23.136.1.1.5".equals(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkFields() {
        try {
            if (!ActiveAuthenticationInfo.checkRequiredIdentifier(this.oid)) throw new IllegalArgumentException("Wrong identifier: " + this.oid);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Malformed ActiveAuthenticationInfo", exception);
        }
        if (this.version != 1) throw new IllegalArgumentException("Wrong version: " + this.version);
        if (ECDSA_PLAIN_SHA1_OID.equals(this.signatureAlgorithmOID)) return;
        if (ECDSA_PLAIN_SHA224_OID.equals(this.signatureAlgorithmOID)) return;
        if (ECDSA_PLAIN_SHA256_OID.equals(this.signatureAlgorithmOID)) return;
        if (ECDSA_PLAIN_SHA384_OID.equals(this.signatureAlgorithmOID)) return;
        if (ECDSA_PLAIN_SHA512_OID.equals(this.signatureAlgorithmOID)) return;
        if (ECDSA_PLAIN_RIPEMD160_OID.equals(this.signatureAlgorithmOID)) return;
        throw new IllegalArgumentException("Wrong signature algorithm OID: " + this.signatureAlgorithmOID);
    }

    private String toProtocolOIDString(String string) {
        if ("2.23.136.1.1.5".equals(string)) {
            string = "id-AA";
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String toSignatureAlgorithmOIDString(String string) {
        if (ECDSA_PLAIN_SHA1_OID.equals(string)) return "ecdsa-plain-SHA224";
        if (ECDSA_PLAIN_SHA224_OID.equals(string)) {
            return "ecdsa-plain-SHA224";
        }
        if (ECDSA_PLAIN_SHA256_OID.equals(string)) {
            return "ecdsa-plain-SHA256";
        }
        if (ECDSA_PLAIN_SHA384_OID.equals(string)) {
            return "ecdsa-plain-SHA384";
        }
        if (ECDSA_PLAIN_SHA512_OID.equals(string)) {
            return "ecdsa-plain-SHA512";
        }
        if (!ECDSA_PLAIN_RIPEMD160_OID.equals(string)) return string;
        return "ecdsa-plain-RIPEMD160";
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector().add((ASN1Encodable)new ASN1ObjectIdentifier(((ActiveAuthenticationInfo)((Object)string)).oid));
        aSN1EncodableVector2.add((ASN1Encodable)new ASN1Integer((long)((ActiveAuthenticationInfo)((Object)string)).version));
        String string = ((ActiveAuthenticationInfo)((Object)string)).signatureAlgorithmOID;
        if (string != null) {
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier(string));
        }
        return new DLSequence(aSN1EncodableVector2);
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public String getProtocolOIDString() {
        ActiveAuthenticationInfo activeAuthenticationInfo = this;
        return activeAuthenticationInfo.toProtocolOIDString(activeAuthenticationInfo.oid);
    }

    public String getSignatureAlgorithmOID() {
        return this.signatureAlgorithmOID;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ActiveAuthenticationInfo");
        stringBuilder.append(" [");
        ActiveAuthenticationInfo activeAuthenticationInfo = this;
        stringBuilder.append("protocol: " + activeAuthenticationInfo.toProtocolOIDString(activeAuthenticationInfo.oid));
        stringBuilder.append(", ");
        stringBuilder.append("version: " + this.version);
        stringBuilder.append(", ");
        stringBuilder.append("signatureAlgorithmOID: " + ActiveAuthenticationInfo.toSignatureAlgorithmOIDString(this.getSignatureAlgorithmOID()));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == activeAuthenticationInfo2) {
            return true;
        }
        if (!ActiveAuthenticationInfo.class.equals(object.getClass())) {
            return false;
        }
        ActiveAuthenticationInfo activeAuthenticationInfo = activeAuthenticationInfo2;
        ActiveAuthenticationInfo activeAuthenticationInfo2 = (ActiveAuthenticationInfo)object;
        return activeAuthenticationInfo.getDERObject().equals((Object)activeAuthenticationInfo2.getDERObject());
    }

    public int hashCode() {
        int n2 = 12345;
        int n3 = 3;
        String string = this.oid;
        int n4 = (string == null ? 0 : string.hashCode()) * n3 + n2 + this.version * 5;
        n2 = 11;
        String string2 = this.signatureAlgorithmOID;
        return n4 + (string2 == null ? 1 : string2.hashCode()) * n2;
    }
}

