/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eid_bc.bouncycastle.asn1.ASN1Encodable;
import org.eid_bc.bouncycastle.asn1.ASN1EncodableVector;
import org.eid_bc.bouncycastle.asn1.ASN1InputStream;
import org.eid_bc.bouncycastle.asn1.ASN1Set;
import org.eid_bc.bouncycastle.asn1.DLSet;
import org.jmrtd.lds.SecurityInfo;

public class CardAccessFile
implements Serializable {
    public static final long serialVersionUID = -3536507558193769951L;
    public Set<SecurityInfo> securityInfos;

    public CardAccessFile(Collection<SecurityInfo> collection) {
        if (collection != null) {
            this.securityInfos = new HashSet<SecurityInfo>(collection);
            return;
        }
        throw new IllegalArgumentException("Null securityInfos");
    }

    public CardAccessFile(InputStream inputStream) {
        this.readContent(inputStream);
    }

    public void readContent(InputStream inputStream) {
        this.securityInfos = new HashSet<SecurityInfo>();
        inputStream = (ASN1Set)new ASN1InputStream(inputStream).readObject();
        for (int i2 = 0; i2 < inputStream.size(); ++i2) {
            SecurityInfo securityInfo = SecurityInfo.getInstance(inputStream.getObjectAt(i2).toASN1Primitive());
            if (securityInfo == null) continue;
            this.securityInfos.add(securityInfo);
        }
    }

    public void writeContent(OutputStream outputStream) {
        ASN1EncodableVector aSN1EncodableVector;
        CardAccessFile cardAccessFile = cardAccessFile2;
        CardAccessFile cardAccessFile2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        Iterator<SecurityInfo> iterator = cardAccessFile.securityInfos.iterator();
        while (iterator.hasNext()) {
            cardAccessFile2.add((ASN1Encodable)iterator.next().getDERObject());
        }
        outputStream.write(new DLSet((ASN1EncodableVector)cardAccessFile2).getEncoded("DER"));
    }

    public Collection<SecurityInfo> getSecurityInfos() {
        return this.securityInfos;
    }

    public String toString() {
        return "CardAccessFile [" + this.securityInfos.toString() + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object set) {
        if (set == null) {
            return false;
        }
        if (!set.getClass().equals(CardAccessFile.class)) {
            return false;
        }
        CardAccessFile cardAccessFile = set2;
        Set<SecurityInfo> set2 = (CardAccessFile)((Object)set);
        set = cardAccessFile.securityInfos;
        if (set == null) {
            if (((CardAccessFile)((Object)set2)).securityInfos != null) return false;
            return true;
        }
        set2 = ((CardAccessFile)((Object)set2)).securityInfos;
        if (set2 == null) {
            if (set != null) return false;
            return true;
        }
        boolean bl = set.equals(set2);
        return bl;
    }

    public int hashCode() {
        return this.securityInfos.hashCode() * 7 + 61;
    }
}

