/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eid_bc.bouncycastle.asn1.ASN1Integer;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.asn1.ASN1Primitive;
import org.eid_bc.bouncycastle.asn1.ASN1Sequence;
import org.eid_bc.bouncycastle.asn1.eac.EACObjectIdentifiers;
import org.eid_bc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.eid_bc.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.eid_bc.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.jmrtd.Util;
import org.jmrtd.lds.AbstractLDSInfo;
import org.jmrtd.lds.ActiveAuthenticationInfo;
import org.jmrtd.lds.ChipAuthenticationInfo;
import org.jmrtd.lds.ChipAuthenticationPublicKeyInfo;
import org.jmrtd.lds.PACEDomainParameterInfo;
import org.jmrtd.lds.PACEInfo;
import org.jmrtd.lds.TerminalAuthenticationInfo;

public abstract class SecurityInfo
extends AbstractLDSInfo {
    public static final long serialVersionUID = -7919854443619069808L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final String ID_AA = "2.23.136.1.1.5";
    public static final String ID_PK_DH = EACObjectIdentifiers.id_PK_DH.getId();
    public static final String ID_PK_ECDH = EACObjectIdentifiers.id_PK_ECDH.getId();
    public static final String ID_CA_DH_3DES_CBC_CBC = EACObjectIdentifiers.id_CA_DH_3DES_CBC_CBC.getId();
    public static final String ID_CA_ECDH_3DES_CBC_CBC = EACObjectIdentifiers.id_CA_ECDH_3DES_CBC_CBC.getId();
    public static final String ID_CA_DH_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.3.1.2";
    public static final String ID_CA_DH_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.3.1.3";
    public static final String ID_CA_DH_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.3.1.4";
    public static final String ID_CA_ECDH_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.3.2.2";
    public static final String ID_CA_ECDH_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.3.2.3";
    public static final String ID_CA_ECDH_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.3.2.4";
    public static final String ID_TA = EACObjectIdentifiers.id_TA.getId();
    public static final String ID_TA_RSA = EACObjectIdentifiers.id_TA_RSA.getId();
    public static final String ID_TA_RSA_V1_5_SHA_1 = EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_1.getId();
    public static final String ID_TA_RSA_V1_5_SHA_256 = EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_256.getId();
    public static final String ID_TA_RSA_PSS_SHA_1 = EACObjectIdentifiers.id_TA_RSA_PSS_SHA_1.getId();
    public static final String ID_TA_RSA_PSS_SHA_256 = EACObjectIdentifiers.id_TA_RSA_PSS_SHA_256.getId();
    public static final String ID_TA_ECDSA = EACObjectIdentifiers.id_TA_ECDSA.getId();
    public static final String ID_TA_ECDSA_SHA_1 = EACObjectIdentifiers.id_TA_ECDSA_SHA_1.getId();
    public static final String ID_TA_ECDSA_SHA_224 = EACObjectIdentifiers.id_TA_ECDSA_SHA_224.getId();
    public static final String ID_TA_ECDSA_SHA_256 = EACObjectIdentifiers.id_TA_ECDSA_SHA_256.getId();
    public static final String ID_EC_PUBLIC_KEY_TYPE = X9ObjectIdentifiers.id_publicKeyType.getId();
    public static final String ID_EC_PUBLIC_KEY = X9ObjectIdentifiers.id_ecPublicKey.getId();
    public static final String ID_BSI = "0.4.0.127.0.7";
    public static final String ID_PACE = "0.4.0.127.0.7.2.2.4";
    public static final String ID_PACE_DH_GM = "0.4.0.127.0.7.2.2.4.1";
    public static final String ID_PACE_DH_GM_3DES_CBC_CBC = "0.4.0.127.0.7.2.2.4.1.1";
    public static final String ID_PACE_DH_GM_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.4.1.2";
    public static final String ID_PACE_DH_GM_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.4.1.3";
    public static final String ID_PACE_DH_GM_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.4.1.4";
    public static final String ID_PACE_ECDH_GM = "0.4.0.127.0.7.2.2.4.2";
    public static final String ID_PACE_ECDH_GM_3DES_CBC_CBC = "0.4.0.127.0.7.2.2.4.2.1";
    public static final String ID_PACE_ECDH_GM_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.4.2.2";
    public static final String ID_PACE_ECDH_GM_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.4.2.3";
    public static final String ID_PACE_ECDH_GM_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.4.2.4";
    public static final String ID_PACE_DH_IM = "0.4.0.127.0.7.2.2.4.3";
    public static final String ID_PACE_DH_IM_3DES_CBC_CBC = "0.4.0.127.0.7.2.2.4.3.1";
    public static final String ID_PACE_DH_IM_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.4.3.2";
    public static final String ID_PACE_DH_IM_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.4.3.3";
    public static final String ID_PACE_DH_IM_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.4.3.4";
    public static final String ID_PACE_ECDH_IM = "0.4.0.127.0.7.2.2.4.4";
    public static final String ID_PACE_ECDH_IM_3DES_CBC_CBC = "0.4.0.127.0.7.2.2.4.4.1";
    public static final String ID_PACE_ECDH_IM_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.4.4.2";
    public static final String ID_PACE_ECDH_IM_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.4.4.3";
    public static final String ID_PACE_ECDH_IM_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.4.4.4";
    public static final String ID_PACE_ECDH_CAM = "0.4.0.127.0.7.2.2.4.6";
    public static final String ID_PACE_ECDH_CAM_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.4.6.2";
    public static final String ID_PACE_ECDH_CAM_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.4.6.3";
    public static final String ID_PACE_ECDH_CAM_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.4.6.4";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SecurityInfo getInstance(ASN1Primitive aSN1Primitive) {
        try {
            aSN1Primitive = (ASN1Sequence)aSN1Primitive;
            String string = ((ASN1ObjectIdentifier)aSN1Primitive.getObjectAt(0)).getId();
            ASN1Primitive aSN1Primitive2 = aSN1Primitive.getObjectAt(1).toASN1Primitive();
            ASN1Primitive aSN1Primitive3 = null;
            if (aSN1Primitive.size() == 3) {
                aSN1Primitive3 = aSN1Primitive.getObjectAt(2).toASN1Primitive();
            }
            if (ActiveAuthenticationInfo.checkRequiredIdentifier(string)) {
                int n2 = ((ASN1Integer)aSN1Primitive2).getValue().intValue();
                if (aSN1Primitive3 == null) {
                    return new ActiveAuthenticationInfo(string, n2, null);
                }
                String string2 = ((ASN1ObjectIdentifier)aSN1Primitive3).getId();
                return new ActiveAuthenticationInfo(string, n2, string2);
            }
            if (ChipAuthenticationPublicKeyInfo.checkRequiredIdentifier(string)) {
                aSN1Primitive = SubjectPublicKeyInfo.getInstance((Object)aSN1Primitive2);
                if (aSN1Primitive3 == null) {
                    return new ChipAuthenticationPublicKeyInfo(string, Util.toPublicKey((SubjectPublicKeyInfo)aSN1Primitive));
                }
                BigInteger bigInteger = ((ASN1Integer)aSN1Primitive3).getValue();
                return new ChipAuthenticationPublicKeyInfo(string, Util.toPublicKey((SubjectPublicKeyInfo)aSN1Primitive), bigInteger);
            }
            if (ChipAuthenticationInfo.checkRequiredIdentifier(string)) {
                int n3 = ((ASN1Integer)aSN1Primitive2).getValue().intValue();
                if (aSN1Primitive3 == null) {
                    return new ChipAuthenticationInfo(string, n3);
                }
                BigInteger bigInteger = ((ASN1Integer)aSN1Primitive3).getValue();
                return new ChipAuthenticationInfo(string, n3, bigInteger);
            }
            if (TerminalAuthenticationInfo.checkRequiredIdentifier(string)) {
                int n4 = ((ASN1Integer)aSN1Primitive2).getValue().intValue();
                if (aSN1Primitive3 == null) {
                    return new TerminalAuthenticationInfo(string, n4);
                }
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive3;
                return new TerminalAuthenticationInfo(string, n4, aSN1Sequence);
            }
            if (PACEInfo.checkRequiredIdentifier(string)) {
                int n5;
                int n6 = ((ASN1Integer)aSN1Primitive2).getValue().intValue();
                int n7 = -1;
                if (aSN1Primitive3 == null) return new PACEInfo(string, n6, n5);
                n5 = ((ASN1Integer)aSN1Primitive3).getValue().intValue();
                return new PACEInfo(string, n6, n5);
            }
            if (!PACEDomainParameterInfo.checkRequiredIdentifier(string)) {
                LOGGER.warning("Unsupported SecurityInfo, oid = " + string);
                return null;
            }
            aSN1Primitive = AlgorithmIdentifier.getInstance((Object)aSN1Primitive2);
            if (aSN1Primitive3 != null) {
                BigInteger bigInteger = ((ASN1Integer)aSN1Primitive3).getValue();
                return new PACEDomainParameterInfo(string, (AlgorithmIdentifier)aSN1Primitive, bigInteger);
            }
            return new PACEDomainParameterInfo(string, (AlgorithmIdentifier)aSN1Primitive);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Unexpected exception", exception);
            throw new IllegalArgumentException("Malformed input stream.");
        }
    }

    @Deprecated
    public abstract ASN1Primitive getDERObject();

    @Override
    public void writeObject(OutputStream outputStream) {
        if ((object = ((SecurityInfo)object).getDERObject()) != null) {
            byte[] byArray = object.getEncoded("DER");
            Object object = byArray;
            if (byArray != null) {
                outputStream.write((byte[])object);
                return;
            }
            throw new IOException("Could not decode from DER.");
        }
        throw new IOException("Could not decode from DER.");
    }

    public abstract String getObjectIdentifier();

    public abstract String getProtocolOIDString();
}

