/*
 * Decompiled with CFR 0.152.
 */
package net.security.device.api.id.oaid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.Parcel;
import net.security.device.api.LogUtil;
import net.security.device.api.id.IOAID;
import net.security.device.api.id.IOAIDGetter;

public class SamsungImpl
implements IOAID {
    private final Context context;

    public SamsungImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        if (this.context == null) {
            return false;
        }
        try {
            PackageManager pm = this.context.getPackageManager();
            if (pm != null) {
                PackageInfo pi = pm.getPackageInfo("com.samsung.android.deviceidservice", 0);
                return pi != null;
            }
        }
        catch (Exception e) {
            LogUtil.e(e.toString());
        }
        return false;
    }

    @Override
    public void doGet(final IOAIDGetter getter) {
        if (this.context == null) {
            getter.onOAIDGetError(new NullPointerException("OAID context is null"));
            return;
        }
        Intent intent = new Intent();
        intent.setClassName("com.samsung.android.deviceidservice", "com.samsung.android.deviceidservice.DeviceIdService");
        try {
            boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    LogUtil.d("Samsung DeviceIdService connected");
                    try {
                        Parcel obtain = Parcel.obtain();
                        Parcel obtain2 = Parcel.obtain();
                        try {
                            String oaid = null;
                            obtain.writeInterfaceToken("com.samsung.android.deviceidservice.IDeviceIdService");
                            if (service.transact(1, obtain, obtain2, 0)) {
                                obtain2.readException();
                                oaid = obtain2.readString();
                            }
                            if (oaid == null || oaid.length() == 0) {
                                throw new RuntimeException("Samsung OAID get failed");
                            }
                            getter.onOAIDGetComplete(oaid);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        finally {
                            obtain2.recycle();
                            obtain.recycle();
                            SamsungImpl.this.context.unbindService((ServiceConnection)this);
                        }
                    }
                    catch (Exception e) {
                        LogUtil.e(e.toString());
                        getter.onOAIDGetError(e);
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    LogUtil.d("Samsung DeviceIdService disconnected");
                }
            }, 1);
            if (!isBinded) {
                throw new RuntimeException("Samsung DeviceIdService bind failed");
            }
        }
        catch (Exception e) {
            getter.onOAIDGetError(e);
        }
    }
}

