/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.ui;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.text.TextUtils;
import com.dtf.face.log.RecordLevel;
import com.dtf.face.log.RecordService;
import com.dtf.face.ui.ZimActivityLifeCircle;
import com.dtf.face.utils.MobileUtil;
import java.util.ArrayList;
import java.util.List;

public class FaceBaseActivity
extends Activity {
    public static final String FINISH_WITH_EXCEPTION = "FINISH_WITH_EXCEPTION";
    public static final int TOYGER_PERMISSION_REQUEST_CODE = 1024;
    public static String S_LANGUAGE = "";

    public FaceBaseActivity() {
        FaceBaseActivity faceBaseActivity = this;
        faceBaseActivity.resetLanguage(false);
    }

    private void restartApp() {
        PackageManager packageManager = this.getPackageManager();
        if (packageManager != null) {
            packageManager = packageManager.getLaunchIntentForPackage(this.getPackageName());
            int n = Integer.MAX_VALUE;
            packageManager = Build.VERSION.SDK_INT < 30 ? PendingIntent.getActivity((Context)this, (int)n, (Intent)packageManager, (int)0x10000000) : PendingIntent.getActivity((Context)this, (int)n, (Intent)packageManager, (int)0x14000000);
            long l = System.currentTimeMillis() + 100L;
            ((AlarmManager)this.getSystemService("alarm")).set(1, l, (PendingIntent)packageManager);
            Process.killProcess((int)Process.myPid());
        }
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null && TextUtils.equals((CharSequence)bundle.getString(FINISH_WITH_EXCEPTION), (CharSequence)"T")) {
            if (S_LANGUAGE.equals(MobileUtil.getSystemLanguage())) {
                FaceBaseActivity faceBaseActivity = this;
                faceBaseActivity.restartApp();
                faceBaseActivity.finish();
                return;
            }
            S_LANGUAGE = S_LANGUAGE + FINISH_WITH_EXCEPTION + MobileUtil.getSystemLanguage();
        }
        ZimActivityLifeCircle.getInstance().onActivityCreated(this);
    }

    public void onResume() {
        super.onResume();
        ZimActivityLifeCircle.getInstance().onActivityResumed(this);
    }

    public void onDestroy() {
        super.onDestroy();
        ZimActivityLifeCircle.getInstance().onActivityDestroyed(this);
    }

    public void finish() {
        super.finish();
        ZimActivityLifeCircle.getInstance().onActivityDestroyed(this);
    }

    public void onRestoreInstanceState(Bundle bundle) {
        super.onRestoreInstanceState(bundle);
    }

    public void onSaveInstanceState(Bundle bundle) {
        Bundle bundle2 = bundle;
        bundle2.putString(FINISH_WITH_EXCEPTION, "T");
        super.onSaveInstanceState(bundle2);
    }

    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        FaceBaseActivity faceBaseActivity = this;
        super.onRequestPermissionsResult(n, stringArray, nArray);
        List<String> list = faceBaseActivity.genUnGrantedToygerPermissions();
        if (n == 1024 && list.size() <= 0) {
            String[] stringArray2 = new String[4];
            stringArray = stringArray2;
            stringArray2[0] = "status";
            stringArray2[1] = "permissions granted, after user comfirm, enter sdk";
            stringArray2[2] = "android_sdk";
            stringArray2[3] = String.valueOf(Build.VERSION.SDK_INT);
            RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "androidPermission", stringArray);
        } else {
            String[] stringArray3 = new String[4];
            stringArray = stringArray3;
            stringArray3[0] = "status";
            stringArray3[1] = "permissions not granted after user confirm, exit sdk";
            stringArray3[2] = "android_sdk";
            stringArray3[3] = String.valueOf(Build.VERSION.SDK_INT);
            RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "androidPermission", stringArray);
        }
        this.onRequestPermissionsEnd(list);
    }

    public void onRequestPermissionsEnd(List<String> list) {
    }

    public boolean checkAndRequestPermissions() {
        List<String> list;
        if (Build.VERSION.SDK_INT >= 23 && (list = stringArray3.genUnGrantedToygerPermissions()).size() > 0) {
            String[] stringArray = stringArray3;
            String[] stringArray2 = new String[4];
            String[] stringArray3 = stringArray2;
            stringArray2[0] = "status";
            stringArray2[1] = "permissions not granted, left size=" + list.size();
            stringArray2[2] = "android_sdk";
            stringArray2[3] = String.valueOf(Build.VERSION.SDK_INT);
            RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, "androidPermission", stringArray3);
            stringArray.requestPermissions(list.toArray(new String[0]), 1024);
            return false;
        }
        return true;
    }

    public List<String> genUnGrantedToygerPermissions() {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 23) {
            for (String string2 : this.getSDKRequestPermissions()) {
                if (this.checkSelfPermission(string2) == 0) continue;
                arrayList2.add(string2);
            }
        }
        return arrayList2;
    }

    public List<String> getSDKRequestPermissions() {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        if (this.needCameraPermission()) {
            arrayList2.add("android.permission.CAMERA");
        }
        if (this.needAudioPermission()) {
            arrayList2.add("android.permission.RECORD_AUDIO");
        }
        return arrayList2;
    }

    public boolean needCameraPermission() {
        return true;
    }

    public boolean needAudioPermission() {
        return false;
    }

    public void resetLanguage(boolean bl) {
        if (bl) {
            S_LANGUAGE = MobileUtil.getSystemLanguage();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)S_LANGUAGE)) {
            S_LANGUAGE = MobileUtil.getSystemLanguage();
        }
    }

    public boolean isLanguageChange() {
        return S_LANGUAGE.contains(FINISH_WITH_EXCEPTION);
    }
}

