/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.utils;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.dtf.face.log.RecordLevel;
import com.dtf.face.log.RecordService;
import com.dtf.face.network.APICallback;
import com.dtf.face.thread.ThreadControl;
import com.dtf.face.utils.DownloadUtil;
import com.dtf.face.utils.FileUtil;
import com.dtf.face.utils.LocalPreferencesUtil;
import com.dtf.face.utils.MiscUtil;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class ModelDownloadUtil {
    public static final String ANT_FACE_MODEL_URL = "https://gw.alipayobjects.com/render/p/yuyan_npm/@alipay_dtfconfig/1.0.1/lib/toyger.face.android.wasm";
    public static final String OSS_FACE_MODEL_URL = "https://cn-shanghai-aliyun-cloudauth.oss-cn-shanghai.aliyuncs.com/model/toyger.face.dat";
    public static final String FACE_MODEL_MD5 = "fd4ddd72c85fd5fe2913be520df32ed0";
    public static Map<String, CopyOnWriteArrayList<APICallback<String>>> sDownLoadCallBack;
    public static List<String> sFaceModelDownLoadUrls;
    public static List<String> sFaceModelDownLoadFailedUrls;
    public static AtomicInteger sDownloadCount;
    public static String sFaceModelCurrentUrl = "";

    public static void downloadFaceModelAsync(final Context context, final List<String> list, final boolean bl, final APICallback<String> aPICallback) {
        ThreadControl.sSingleExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                ModelDownloadUtil.downloadFaceModel(context, list, bl, aPICallback);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void downloadFaceModel(Context var0, List<String> var1_2, boolean var2_3, APICallback<String> var3_7) {
        var4_8 = ModelDownloadUtil.hasAssetFaceModel(var0);
        if (!var4_8) {
            var4_8 = ModelDownloadUtil.hasLocalFaceModel(var0);
        }
        if (var4_8) {
            if (var3_7 != null) {
                var3_7.onSuccess("SUCCESS");
            }
            return;
        }
        var4_9 = ModelDownloadUtil.class;
        synchronized (ModelDownloadUtil.class) {
            block35: {
                block34: {
                    block31: {
                        ModelDownloadUtil.initParameters();
                        if (!ModelDownloadUtil.hasLocalFaceModel(var0)) ** GOTO lbl18
                        if (var3_7 == null) ** GOTO lbl16
                        var3_7.onSuccess("SUCCESS");
lbl16:
                        // 2 sources

                        // ** MonitorExit[var4_9] (shouldn't be in output)
                        return;
lbl18:
                        // 1 sources

                        v0 = var2_3;
                        var2_4 = RecordService.getInstance();
                        var5_10 /* !! */  = RecordLevel.LOG_ERROR;
                        var6_11 = "modelDownload";
                        v1 = new String[2];
                        var7_12 = v1;
                        v1[0] = "status";
                        var8_13 = 1;
                        var9_14 = v0 != false ? "preload" : "backup";
                        var7_12[var8_13] = var9_14;
                        var2_4.recordEvent(var5_10 /* !! */ , var6_11, var7_12);
                        if (var1_2 == null) break block31;
                        var2_5 = 0;
                        while (true) {
                            block32: {
                                block33: {
                                    if (var2_5 >= var1_2.size()) break;
                                    var5_10 /* !! */  = (String)var1_2.get(var2_5);
                                    var6_11 = var5_10 /* !! */ .toLowerCase();
                                    if (TextUtils.isEmpty((CharSequence)var5_10 /* !! */ )) break block32;
                                    if (var6_11.startsWith("http")) break block33;
                                    if (!var6_11.startsWith("www")) break block32;
                                }
                                if (ModelDownloadUtil.sFaceModelDownLoadUrls.contains((Object)var5_10 /* !! */ )) break block32;
                                if (ModelDownloadUtil.sFaceModelDownLoadFailedUrls.contains((Object)var5_10 /* !! */ )) break block32;
                                if (ModelDownloadUtil.sFaceModelCurrentUrl.equals((Object)var5_10 /* !! */ )) break block32;
                                ModelDownloadUtil.sFaceModelDownLoadUrls.add(0, (String)var5_10 /* !! */ );
                            }
                            ++var2_5;
                        }
                    }
                    if (ModelDownloadUtil.sDownLoadCallBack.get("fd4ddd72c85fd5fe2913be520df32ed0") == null) ** GOTO lbl74
                    if (var3_7 == null) break block34;
                    ModelDownloadUtil.sDownLoadCallBack.get("fd4ddd72c85fd5fe2913be520df32ed0").add(var3_7);
                }
                // ** MonitorExit[var4_9] (shouldn't be in output)
                return;
lbl74:
                // 1 sources

                v3 = var3_7;
                var1_2 = v4;
                v4 = new CopyOnWriteArrayList<APICallback<String>>();
                if (v3 != null) {
                    var1_2.add(var3_7);
                }
                v5 = var4_9;
                ModelDownloadUtil.sDownLoadCallBack.put("fd4ddd72c85fd5fe2913be520df32ed0", var1_2);
                // ** MonitorExit[v5] (shouldn't be in output)
                if (ModelDownloadUtil.sFaceModelDownLoadUrls.contains("https://gw.alipayobjects.com/render/p/yuyan_npm/@alipay_dtfconfig/1.0.1/lib/toyger.face.android.wasm") || ModelDownloadUtil.sFaceModelDownLoadFailedUrls.contains("https://gw.alipayobjects.com/render/p/yuyan_npm/@alipay_dtfconfig/1.0.1/lib/toyger.face.android.wasm") || ModelDownloadUtil.sFaceModelCurrentUrl.equals("https://gw.alipayobjects.com/render/p/yuyan_npm/@alipay_dtfconfig/1.0.1/lib/toyger.face.android.wasm")) break block35;
                ModelDownloadUtil.sFaceModelDownLoadUrls.add("https://gw.alipayobjects.com/render/p/yuyan_npm/@alipay_dtfconfig/1.0.1/lib/toyger.face.android.wasm");
            }
            if (!(ModelDownloadUtil.sFaceModelDownLoadUrls.contains("https://cn-shanghai-aliyun-cloudauth.oss-cn-shanghai.aliyuncs.com/model/toyger.face.dat") || ModelDownloadUtil.sFaceModelDownLoadFailedUrls.contains("https://cn-shanghai-aliyun-cloudauth.oss-cn-shanghai.aliyuncs.com/model/toyger.face.dat") || ModelDownloadUtil.sFaceModelCurrentUrl.equals("https://cn-shanghai-aliyun-cloudauth.oss-cn-shanghai.aliyuncs.com/model/toyger.face.dat"))) {
                ModelDownloadUtil.sFaceModelDownLoadUrls.add("https://cn-shanghai-aliyun-cloudauth.oss-cn-shanghai.aliyuncs.com/model/toyger.face.dat");
            }
            var0_1 = System.currentTimeMillis();
            var2_6 = v6;
            v6 = new APICallback<File>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(File object) {
                    iterator.logEnd(true);
                    Iterator iterator = ModelDownloadUtil.class;
                    synchronized (ModelDownloadUtil.class) {
                        block5: {
                            object = (List)sDownLoadCallBack.remove(ModelDownloadUtil.FACE_MODEL_MD5);
                            // ** MonitorExit[this] (shouldn't be in output)
                            if (object == null) break block5;
                            iterator = object.iterator();
                            while (iterator.hasNext()) {
                                ((APICallback)iterator.next()).onSuccess("SUCCESS");
                            }
                        }
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onError(String string, String string2, String string3) {
                    iterator.logEnd(false);
                    Iterator iterator = ModelDownloadUtil.class;
                    synchronized (ModelDownloadUtil.class) {
                        block5: {
                            List list = (List)sDownLoadCallBack.remove(ModelDownloadUtil.FACE_MODEL_MD5);
                            // ** MonitorExit[this] (shouldn't be in output)
                            if (list == null) break block5;
                            iterator = list.iterator();
                            while (iterator.hasNext()) {
                                ((APICallback)iterator.next()).onError(string, string2, string3);
                            }
                        }
                        return;
                    }
                }

                public void logEnd(boolean bl) {
                    RecordService recordService = RecordService.getInstance();
                    RecordLevel recordLevel = RecordLevel.LOG_ERROR;
                    String string = "modelDownload";
                    String[] stringArray = new String[8];
                    String[] stringArray2 = stringArray;
                    stringArray[0] = "status";
                    stringArray[1] = "total";
                    stringArray[2] = "result";
                    int n = 3;
                    String string2 = bl ? "1" : "0";
                    String[] stringArray3 = stringArray2;
                    String[] stringArray4 = stringArray2;
                    stringArray3[n] = string2;
                    stringArray4[4] = "cost";
                    stringArray3[5] = String.valueOf(System.currentTimeMillis() - var0_1);
                    stringArray4[6] = "count";
                    stringArray3[7] = String.valueOf(sDownloadCount.get());
                    recordService.recordEvent(recordLevel, string, stringArray4);
                    sDownloadCount.set(0);
                    sFaceModelDownLoadUrls.clear();
                }
            };
            ModelDownloadUtil.downloadFaceModel("fd4ddd72c85fd5fe2913be520df32ed0", ModelDownloadUtil.getLocalStoreDir(var0), null, var2_6);
            return;
        }
    }

    public static synchronized void initParameters() {
        if (sFaceModelDownLoadUrls == null) {
            sFaceModelDownLoadUrls = new CopyOnWriteArrayList<String>();
        }
        if (sDownloadCount == null) {
            sDownloadCount = new AtomicInteger(0);
        }
        if (sDownLoadCallBack == null) {
            sDownLoadCallBack = new ConcurrentHashMap<String, CopyOnWriteArrayList<APICallback<String>>>();
        }
        if (sFaceModelDownLoadFailedUrls == null) {
            sFaceModelDownLoadFailedUrls = new CopyOnWriteArrayList<String>();
        }
    }

    public static void downloadFaceModel(final String string, final String string2, final String string3, final APICallback<File> aPICallback) {
        APICallback<Pair<File, String>> aPICallback2;
        if (sFaceModelDownLoadUrls.size() == 0) {
            if (aPICallback != null) {
                aPICallback.onError("RETRY-OVER", null, null);
            }
            return;
        }
        sDownloadCount.incrementAndGet();
        final long l = System.currentTimeMillis();
        sFaceModelCurrentUrl = sFaceModelDownLoadUrls.remove(0);
        String[] stringArray = new String[6];
        Object object = stringArray;
        stringArray[0] = "status";
        stringArray[1] = "start";
        stringArray[2] = "url";
        stringArray[3] = sFaceModelCurrentUrl;
        stringArray[4] = "left";
        stringArray[5] = String.valueOf(sFaceModelDownLoadUrls.size());
        RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "modelDownload", (String)object);
        object = aPICallback2;
        aPICallback2 = new APICallback<Pair<File, String>>(){

            @Override
            public void onSuccess(Pair<File, String> pair) {
                block5: {
                    block8: {
                        block7: {
                            Object object;
                            block6: {
                                if (pair == null) break block5;
                                object = pair.second;
                                object = object != null ? ((String)object).toLowerCase() : "";
                                if (((String)object).startsWith("http") || ((String)object).startsWith("www")) break block6;
                                object = aPICallback;
                                if (object != null) {
                                    object.onSuccess(pair.first);
                                }
                                break block7;
                            }
                            LocalPreferencesUtil.putString("modelUrl", (String)pair.second);
                            object = aPICallback;
                            if (object == null) break block8;
                            object.onSuccess(pair.first);
                        }
                        this.logEnd(true, null);
                        return;
                    }
                    this.onError("MD5-ERROR", "Rename MD5 error", null);
                    return;
                }
                this.onError("NULL-PARAMS", "Null file", null);
            }

            @Override
            public void onError(String string4, String string22, String string32) {
                this.logEnd(false, string4 + "-" + string22 + "-" + string32);
                if (!sFaceModelDownLoadFailedUrls.contains(sFaceModelCurrentUrl)) {
                    sFaceModelDownLoadFailedUrls.add(sFaceModelCurrentUrl);
                }
                sFaceModelCurrentUrl = "";
                ModelDownloadUtil.downloadFaceModel(string, string2, string3, aPICallback);
            }

            public void logEnd(boolean bl, String string4) {
                RecordService recordService = RecordService.getInstance();
                RecordLevel recordLevel = RecordLevel.LOG_ERROR;
                String string22 = "modelDownload";
                String[] stringArray = new String[10];
                String[] stringArray2 = stringArray;
                stringArray[0] = "status";
                stringArray[1] = "end";
                stringArray[2] = "url";
                stringArray[3] = sFaceModelCurrentUrl;
                stringArray[4] = "result";
                int n = 5;
                String string32 = bl ? "1" : "0";
                stringArray2[n] = string32;
                stringArray2[6] = "msg";
                n = 7;
                if (string4 == null) {
                    string4 = "";
                }
                String[] stringArray3 = stringArray2;
                String[] stringArray4 = stringArray2;
                stringArray3[n] = string4;
                stringArray4[8] = "totalCost";
                stringArray3[9] = String.valueOf(System.currentTimeMillis() - l);
                recordService.recordEvent(recordLevel, string22, stringArray4);
            }
        };
        DownloadUtil.downloadFileAsync(sFaceModelCurrentUrl, string2, string3, string, 0, (APICallback<Pair<File, String>>)object);
    }

    public static boolean hasAssetFaceModel(Context context) {
        boolean bl;
        block3: {
            bl = false;
            AssetFileDescriptor assetFileDescriptor = context.getAssets().openFd("toyger.face.dat");
            if (assetFileDescriptor == null) break block3;
            bl = true;
            try {
                assetFileDescriptor.close();
            }
            catch (Throwable throwable) {
                Log.getStackTraceString((Throwable)throwable);
            }
        }
        return bl;
    }

    public static boolean hasLocalFaceModel(Context context) {
        return ModelDownloadUtil.chooseValidFaceModel(context) != null;
    }

    public static File chooseValidFaceModel(Context fileArray) {
        if (TextUtils.isEmpty((CharSequence)(fileArray = ModelDownloadUtil.getLocalStoreDir((Context)fileArray)))) {
            return null;
        }
        if ((fileArray = new File((String)fileArray).listFiles()) != null && fileArray.length > 0) {
            for (File file : fileArray) {
                if (!FACE_MODEL_MD5.equals(MiscUtil.getFileMd5(file.getAbsolutePath()))) continue;
                return file;
            }
            return null;
        }
        return null;
    }

    public static void cleanLocalModel(Context object) {
        String[] stringArray = object;
        String[] stringArray2 = new String[2];
        object = stringArray2;
        stringArray2[0] = "status";
        stringArray2[1] = "clean";
        RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "modelDownload", (String)object);
        LocalPreferencesUtil.putString("modelUrl", null);
        object = ModelDownloadUtil.getLocalStoreDir((Context)stringArray);
        if (!TextUtils.isEmpty((CharSequence)object)) {
            FileUtil.deleteDirChildren((String)object);
        }
    }

    public static String getLocalStoreDir(Context object) {
        if (object == null) {
            return null;
        }
        if ((object = FileUtil.getFilePath(object)) != null) {
            object = (String)object + File.separator + "dtf" + File.separator + "model";
            FileUtil.mkDir(new File((String)object));
            return object;
        }
        return null;
    }
}

