/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.tlv.TLVOutputStream;
import org.jmrtd.cbeff.BiometricDataBlock;
import org.jmrtd.lds.DataGroup;

public abstract class CBEFFDataGroup<R extends BiometricDataBlock>
extends DataGroup {
    public static final long serialVersionUID = 2702959939408371946L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public Random random;
    public List<R> subRecords;

    public CBEFFDataGroup(int n2, List<R> list) {
        super(n2);
        this.addAll(list);
        this.random = new Random();
    }

    public CBEFFDataGroup(int n2, InputStream inputStream) {
        super(n2, inputStream);
        this.random = new Random();
    }

    public void add(R r2) {
        if (this.subRecords == null) {
            this.subRecords = new ArrayList<R>();
        }
        this.subRecords.add(r2);
    }

    public void addAll(List<R> list) {
        if (this.subRecords == null) {
            this.subRecords = new ArrayList<R>();
        }
        this.subRecords.addAll(list);
    }

    public void remove(int n2) {
        if (this.subRecords == null) {
            this.subRecords = new ArrayList<R>();
        }
        this.subRecords.remove(n2);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder;
        CBEFFDataGroup cBEFFDataGroup = serializable;
        Serializable serializable = stringBuilder;
        new StringBuilder().append("CBEFFDataGroup [");
        List<R> list = cBEFFDataGroup.subRecords;
        if (list == null) {
            ((StringBuilder)serializable).append("null");
        } else {
            boolean bl = true;
            for (Object object : list) {
                if (!bl) {
                    ((StringBuilder)serializable).append(", ");
                } else {
                    bl = false;
                }
                object = object == null ? "null" : object.toString();
                ((StringBuilder)serializable).append((String)object);
            }
        }
        Serializable serializable2 = serializable;
        ((StringBuilder)serializable2).append(']');
        return ((StringBuilder)serializable2).toString();
    }

    public List<R> getSubRecords() {
        if (this.subRecords == null) {
            this.subRecords = new ArrayList<R>();
        }
        return new ArrayList<R>(this.subRecords);
    }

    public boolean equals(Object list) {
        int n2;
        block13: {
            if (list == null) {
                return false;
            }
            if (list == object) {
                return true;
            }
            if (!(list instanceof CBEFFDataGroup)) {
                return false;
            }
            CBEFFDataGroup cBEFFDataGroup = object;
            Object object = (CBEFFDataGroup)((Object)list);
            list = cBEFFDataGroup.getSubRecords();
            object = ((CBEFFDataGroup)object).getSubRecords();
            n2 = list.size();
            try {
                if (n2 == object.size()) break block13;
                return false;
            }
            catch (ClassCastException classCastException) {
                LOGGER.log(Level.WARNING, "Wrong class", classCastException);
                return false;
            }
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            BiometricDataBlock biometricDataBlock;
            BiometricDataBlock biometricDataBlock2;
            block14: {
                biometricDataBlock2 = (BiometricDataBlock)list.get(i2);
                biometricDataBlock = (BiometricDataBlock)object.get(i2);
                if (biometricDataBlock2 != null) break block14;
                if (biometricDataBlock == null) continue;
                return false;
            }
            if (biometricDataBlock2.equals(biometricDataBlock)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 1234567891;
        for (BiometricDataBlock biometricDataBlock : this.getSubRecords()) {
            if (biometricDataBlock == null) {
                n2 = n2 * 3 + 5;
                continue;
            }
            n2 = (n2 + biometricDataBlock.hashCode()) * 5 + 7;
        }
        return n2 * 7 + 11;
    }

    public void writeOptionalRandomData(OutputStream outputStream) {
        if (this.subRecords.isEmpty()) {
            Object object;
            if (outputStream instanceof TLVOutputStream) {
                outputStream = (TLVOutputStream)outputStream;
                object = outputStream;
            } else {
                TLVOutputStream tLVOutputStream;
                object = tLVOutputStream;
                tLVOutputStream = new TLVOutputStream(outputStream);
            }
            Object object2 = object;
            object2.writeTag(83);
            byte[] byArray = new byte[8];
            this.random.nextBytes(byArray);
            object2.writeValue(byArray);
        }
    }
}

