/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.ui.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JsPromptResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.AbsoluteLayout;
import android.widget.ProgressBar;
import com.dtf.face.ToygerConfig;
import com.dtf.face.ui.FaceLoadingActivity;

public class ToygerWebView
extends WebView {
    public ProgressBar mProgressBar;
    public Handler mHandler;

    public ToygerWebView(Context context, AttributeSet attributeSet) {
        ToygerWebView toygerWebView = this;
        super(ToygerWebView.getFixedContext(context), attributeSet);
        toygerWebView.mProgressBar = new ProgressBar(context, null, 16842872);
        toygerWebView.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(-1, 3, 0, 0));
        toygerWebView.addView((View)toygerWebView.mProgressBar);
        toygerWebView.init();
    }

    public static Context getFixedContext(Context context) {
        int n = Build.VERSION.SDK_INT;
        if (n >= 21 && n < 23) {
            return context.createConfigurationContext(new Configuration());
        }
        return context;
    }

    public void init() {
        ToygerWebView toygerWebView = this;
        toygerWebView.removeJavascriptInterface("searchBoxJavaBridge_");
        toygerWebView.removeJavascriptInterface("accessibility");
        toygerWebView.removeJavascriptInterface("accessibilityTraversal");
        WebSettings webSettings = toygerWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setCacheMode(-1);
        webSettings.setDomStorageEnabled(true);
        webSettings.setDatabaseEnabled(true);
        webSettings.setAllowFileAccess(false);
        webSettings.setSavePassword(false);
        webSettings.setSupportZoom(false);
        webSettings.setBuiltInZoomControls(false);
        toygerWebView.setWebChromeClient(new ToygerWebChromeClient());
        toygerWebView.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
                super.onReceivedError(webView, webResourceRequest, webResourceError);
                Object object = webView.getParent();
                if (object instanceof FaceLoadingActivity && !(object = (FaceLoadingActivity)((Object)object)).isDestroyed() && !object.isFinishing()) {
                    ((FaceLoadingActivity)((Object)object)).sendErrorCode(Integer.toString(2002));
                }
            }
        });
    }

    public void setWebChromeClient(WebChromeClient webChromeClient) {
        if (webChromeClient != null && webChromeClient instanceof ToygerWebChromeClient) {
            super.setWebChromeClient(webChromeClient);
        }
    }

    public void setHandler(Handler handler) {
        this.mHandler = handler;
    }

    public void onScrollChanged(int n, int n2, int n3, int n4) {
        ToygerWebView toygerWebView = toygerWebView3;
        ToygerWebView toygerWebView2 = toygerWebView3;
        ToygerWebView toygerWebView3 = (AbsoluteLayout.LayoutParams)toygerWebView2.mProgressBar.getLayoutParams();
        ((AbsoluteLayout.LayoutParams)toygerWebView3).x = n;
        ((AbsoluteLayout.LayoutParams)toygerWebView2.mProgressBar.getLayoutParams()).y = n2;
        toygerWebView2.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)toygerWebView3);
        super.onScrollChanged(n, n2, n3, n4);
    }

    public class ToygerWebChromeClient
    extends WebChromeClient {
        public void onProgressChanged(WebView webView, int n) {
            if (n == 100) {
                ToygerWebView.this.mProgressBar.setVisibility(8);
            } else {
                if (ToygerWebView.this.mProgressBar.getVisibility() == 8) {
                    ToygerWebView.this.mProgressBar.setVisibility(0);
                }
                ToygerWebView.this.mProgressBar.setProgress(n);
            }
            super.onProgressChanged(webView, n);
        }

        public boolean onJsPrompt(WebView object, String string, String string2, String string3, JsPromptResult jsPromptResult) {
            ToygerWebChromeClient toygerWebChromeClient;
            if ("face_auth".endsWith(string2)) {
                super.onJsPrompt(object, string, string2, string3, jsPromptResult);
                object = ToygerConfig.getInstance().getSuitableType();
                if (TextUtils.equals((CharSequence)object, (CharSequence)"2")) {
                    object = "0";
                    ToygerConfig.getInstance().setSuitableType((String)object);
                }
                Object object2 = object;
                ToygerWebChromeClient toygerWebChromeClient2 = toygerWebChromeClient;
                jsPromptResult.cancel();
                toygerWebChromeClient = toygerWebChromeClient2.ToygerWebView.this.mHandler;
                object = toygerWebChromeClient2.ToygerWebView.this.mHandler;
                int n = TextUtils.equals((CharSequence)object2, (CharSequence)"1") ? 915 : 905;
                toygerWebChromeClient.sendMessage(object.obtainMessage(n));
                return true;
            }
            if ("face_auth_elderly".endsWith(string2)) {
                super.onJsPrompt(object, string, string2, string3, jsPromptResult);
                ToygerConfig.getInstance().setSuitableType("1");
                jsPromptResult.cancel();
                toygerWebChromeClient.ToygerWebView.this.mHandler.sendMessage(toygerWebChromeClient.ToygerWebView.this.mHandler.obtainMessage(915));
                return true;
            }
            if ("navi_close".endsWith(string2)) {
                super.onJsPrompt(object, string, string2, string3, jsPromptResult);
                jsPromptResult.cancel();
                toygerWebChromeClient.ToygerWebView.this.mHandler.sendMessage(toygerWebChromeClient.ToygerWebView.this.mHandler.obtainMessage(906));
                return true;
            }
            if ("guide_log".endsWith(string2)) {
                ToygerWebChromeClient toygerWebChromeClient3 = toygerWebChromeClient;
                super.onJsPrompt(object, string, string2, string3, jsPromptResult);
                jsPromptResult.cancel();
                toygerWebChromeClient = toygerWebChromeClient3.ToygerWebView.this.mHandler.obtainMessage(907);
                toygerWebChromeClient3.ToygerWebView.this.mHandler.obtainMessage(907).obj = string3;
                toygerWebChromeClient3.ToygerWebView.this.mHandler.sendMessage((Message)toygerWebChromeClient);
                return true;
            }
            return super.onJsPrompt(object, string, string2, string3, jsPromptResult);
        }

        public void onReceivedTitle(WebView webView, String string) {
            super.onReceivedTitle(webView, string);
            if (string != null && (string.contains("404") || string.contains("500"))) {
                ToygerWebView.this.mHandler.sendMessage(ToygerWebView.this.mHandler.obtainMessage(908));
            }
        }
    }
}

