/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.Serializable;
import org.ejbca.cvc.AccessRights;
import org.ejbca.cvc.util.StringConverter;

public class AccessRightAuthTerm
implements AccessRights,
Serializable {
    public static final long serialVersionUID = 1L;
    public static final int MAX_BIT = 37;
    public static final int BIT_WRITE_DG17 = 37;
    public static final int BIT_WRITE_DG18 = 36;
    public static final int BIT_WRITE_DG19 = 35;
    public static final int BIT_WRITE_DG20 = 34;
    public static final int BIT_WRITE_DG21 = 33;
    public static final int BIT_READ_DG21 = 28;
    public static final int BIT_READ_DG20 = 27;
    public static final int BIT_READ_DG19 = 26;
    public static final int BIT_READ_DG18 = 25;
    public static final int BIT_READ_DG17 = 24;
    public static final int BIT_READ_DG16 = 23;
    public static final int BIT_READ_DG15 = 22;
    public static final int BIT_READ_DG14 = 21;
    public static final int BIT_READ_DG13 = 20;
    public static final int BIT_READ_DG12 = 19;
    public static final int BIT_READ_DG11 = 18;
    public static final int BIT_READ_DG10 = 17;
    public static final int BIT_READ_DG9 = 16;
    public static final int BIT_READ_DG8 = 15;
    public static final int BIT_READ_DG7 = 14;
    public static final int BIT_READ_DG6 = 13;
    public static final int BIT_READ_DG5 = 12;
    public static final int BIT_READ_DG4 = 11;
    public static final int BIT_READ_DG3 = 10;
    public static final int BIT_READ_DG2 = 9;
    public static final int BIT_READ_DG1 = 8;
    public static final int BIT_INSTALL_QUALIFIED_CERT = 7;
    public static final int BIT_INSTALL_CERT = 6;
    public static final int BIT_PIN_MANAGEMENT = 5;
    public static final int BIT_CAN_ALLOWED = 4;
    public static final int BIT_PRIVILEGED_TERMINAL = 3;
    public static final int BIT_RESTRICTED_IDENTIFICATION = 2;
    public static final int BIT_COMMUNITY_ID_VERIFICATION = 1;
    public static final int BIT_AGE_VERIFICATION = 0;
    public final byte[] bytes;

    public AccessRightAuthTerm() {
        this.bytes = new byte[5];
    }

    public AccessRightAuthTerm(byte[] byArray) {
        if (byArray.length == 5) {
            AccessRightAuthTerm accessRightAuthTerm = this;
            accessRightAuthTerm.bytes = (byte[])byArray.clone();
            accessRightAuthTerm.bytes[0] = (byte)(accessRightAuthTerm.bytes[0] & 0xFFFFFF3F);
            return;
        }
        throw new IllegalArgumentException("byte array length must be 5, was " + byArray.length);
    }

    public static String flagToString(int n2) {
        if (n2 >= 0 && n2 <= 37) {
            if (n2 >= 33) {
                return "W-DG" + (54 - n2);
            }
            if (n2 > 28) {
                return "RFU-" + n2;
            }
            if (n2 >= 8) {
                return "R-DG" + (n2 - 8 + 1);
            }
            switch (n2) {
                default: {
                    throw new IllegalStateException();
                }
                case 7: {
                    return "Install Qualified Certificate";
                }
                case 6: {
                    return "Install Certificate";
                }
                case 5: {
                    return "PIN Management";
                }
                case 4: {
                    return "CAN Allowed";
                }
                case 3: {
                    return "Privileged Terminal";
                }
                case 2: {
                    return "Restricted Identification";
                }
                case 1: {
                    return "Community ID Verification";
                }
                case 0: 
            }
            return "Age Verification";
        }
        throw new ArrayIndexOutOfBoundsException(n2);
    }

    public boolean getFlag(int n2) {
        if (n2 >= 0 && n2 <= 37) {
            return (this.bytes[this.bytes.length - 1 - (n2 >> 3)] >> (n2 & 7) & 1) == 1;
        }
        throw new ArrayIndexOutOfBoundsException(n2);
    }

    public void setFlag(int n2, boolean bl) {
        if (n2 >= 0 && n2 <= 37) {
            Object object;
            object = ((AccessRightAuthTerm)object).bytes;
            int n3 = ((AccessRightAuthTerm)object).bytes.length - 1 - (n2 >> 3);
            n2 = 1 << (n2 & 7);
            object[n3] = (byte)(object[n3] & ~n2);
            byte by = ((AccessRightAuthTerm)object).bytes[n3];
            if (!bl) {
                n2 = 0;
            }
            object[n3] = (byte)(by | n2);
            return;
        }
        throw new ArrayIndexOutOfBoundsException(n2);
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.bytes.clone();
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 <= 37; ++i2) {
            if (!this.getFlag(i2)) continue;
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3.append(AccessRightAuthTerm.flagToString(i2));
            stringBuilder3.append(", ");
        }
        if (stringBuilder2.length() > 0) {
            StringBuilder stringBuilder4 = stringBuilder2;
            stringBuilder4.delete(stringBuilder4.length() - 2, stringBuilder2.length());
        }
        return stringBuilder2.toString();
    }

    @Override
    public String name() {
        return "ACCESS_RIGHT_AT_" + StringConverter.byteToHex(this.bytes);
    }
}

