/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class FragmentBuffer
implements Serializable {
    public static final long serialVersionUID = -3510872461790499721L;
    public static final int DEFAULT_SIZE = 2000;
    public byte[] buffer;
    public Collection<Fragment> fragments;

    public FragmentBuffer() {
        this(2000);
    }

    public FragmentBuffer(int n2) {
        FragmentBuffer fragmentBuffer = this;
        fragmentBuffer.buffer = new byte[n2];
        fragmentBuffer.fragments = new HashSet<Fragment>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setLength(int n2) {
        FragmentBuffer fragmentBuffer = this;
        synchronized (fragmentBuffer) {
            if (n2 > fragmentBuffer.buffer.length) {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
                this.buffer = byArray;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    public synchronized void updateFrom(FragmentBuffer fragmentBuffer) {
        for (Fragment fragment : fragmentBuffer.fragments) {
            this.addFragment(fragment.offset, fragmentBuffer.buffer, fragment.offset, fragment.length);
        }
    }

    public synchronized void addFragment(int n2, byte by) {
        this.addFragment(n2, new byte[]{by});
    }

    public synchronized void addFragment(int n2, byte[] byArray) {
        this.addFragment(n2, byArray, 0, byArray.length);
    }

    public synchronized void addFragment(int n2, byte[] object, int n3, int n4) {
        int n5 = n2 + n4;
        byte[] byArray = this.buffer;
        if (n5 > this.buffer.length) {
            this.setLength(Math.max(n5, byArray.length) * 2);
        }
        System.arraycopy(object, n3, this.buffer, n2, n4);
        object = new ArrayList<Fragment>(this.fragments).iterator();
        while (object.hasNext()) {
            Fragment fragment = (Fragment)object.next();
            if (fragment.getOffset() <= n2 && n2 + n4 <= fragment.getOffset() + fragment.getLength()) {
                return;
            }
            if (fragment.getOffset() <= n2 && n2 <= fragment.getOffset() + fragment.getLength()) {
                n4 = n2 + n4 - fragment.getOffset();
                n2 = fragment.getOffset();
                this.fragments.remove(fragment);
                continue;
            }
            if (n2 <= fragment.getOffset() && fragment.getOffset() + fragment.getLength() <= n2 + n4) {
                this.fragments.remove(fragment);
                continue;
            }
            if (n2 > fragment.getOffset() || fragment.getOffset() > n2 + n4) continue;
            n4 = fragment.getOffset() + fragment.getLength() - n2;
            this.fragments.remove(fragment);
        }
        this.fragments.add(Fragment.getInstance(n2, n4));
    }

    public synchronized int getPosition() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.buffer.length; ++i2) {
            if (!this.isCoveredByFragment(i2)) continue;
            n2 = i2 + 1;
        }
        return n2;
    }

    public synchronized int getBytesBuffered() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.buffer.length; ++i2) {
            if (!this.isCoveredByFragment(i2)) continue;
            ++n2;
        }
        return n2;
    }

    public synchronized boolean isCoveredByFragment(int n2) {
        return this.isCoveredByFragment(n2, 1);
    }

    public synchronized boolean isCoveredByFragment(int n2, int n3) {
        int n4;
        Fragment fragment;
        Iterator<Fragment> iterator = ((FragmentBuffer)((Object)iterator)).fragments.iterator();
        do {
            if (!iterator.hasNext()) {
                return false;
            }
            fragment = (Fragment)iterator.next();
            n4 = fragment.getOffset() + fragment.getLength();
        } while (fragment.getOffset() > n2 || n2 + n3 > n4);
        return true;
    }

    public synchronized int getBufferedLength(int n2) {
        int n3 = 0;
        if (n2 >= ((FragmentBuffer)this).buffer.length) {
            return 0;
        }
        for (Fragment fragment : ((FragmentBuffer)this).fragments) {
            int n4 = fragment.getOffset() + fragment.getLength();
            if (fragment.getOffset() > n2 || n2 >= n4 || (n4 -= n2) <= n3) {
                n4 = n3;
            }
            n3 = n4;
        }
        return n3;
    }

    public Collection<Fragment> getFragments() {
        return this.fragments;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        FragmentBuffer fragmentBuffer = this;
        synchronized (fragmentBuffer) {
            // ** MonitorExit[this] (shouldn't be in output)
            return fragmentBuffer.buffer.length;
        }
    }

    public synchronized Fragment getSmallestUnbufferedFragment(int n2, int n3) {
        Iterator<Fragment> iterator = ((FragmentBuffer)((Object)iterator)).fragments.iterator();
        int n4 = n3;
        n3 = n2;
        while (iterator.hasNext()) {
            Fragment fragment = (Fragment)iterator.next();
            if (fragment.getOffset() <= n3 && n3 + n4 <= fragment.getOffset() + fragment.getLength()) {
                n4 = 0;
                break;
            }
            if (fragment.getOffset() <= n3 && n3 < fragment.getOffset() + fragment.getLength()) {
                int n5 = n3;
                n3 = fragment.getOffset() + fragment.getLength();
                n4 = n5 + n4 - n3;
                continue;
            }
            if (n3 <= fragment.getOffset() && fragment.getOffset() + fragment.getLength() <= n3 + n4 || n2 > fragment.getOffset() || fragment.getOffset() >= n3 + n4) continue;
            n4 = fragment.getOffset() - n3;
        }
        return Fragment.getInstance(n3, n4);
    }

    public synchronized String toString() {
        return "FragmentBuffer [" + this.buffer.length + ", " + this.fragments + "]";
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!object.getClass().equals(FragmentBuffer.class)) {
            return false;
        }
        object = (FragmentBuffer)object;
        if (((FragmentBuffer)object).buffer == null) {
            if (this.buffer != null) return false;
        }
        if (!(((FragmentBuffer)object).buffer != null && this.buffer == null || ((FragmentBuffer)object).fragments == null && this.fragments != null || ((FragmentBuffer)object).fragments != null && this.fragments == null)) {
            if (!Arrays.equals(((FragmentBuffer)object).buffer, this.buffer)) return false;
            if (((FragmentBuffer)object).fragments.equals(this.fragments)) return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.buffer) * 3 + this.fragments.hashCode() * 2 + 7;
    }

    public static class Fragment
    implements Serializable {
        public static final long serialVersionUID = -3795931618553980328L;
        public int offset;
        public int length;

        public Fragment(int n2, int n3) {
            this.offset = n2;
            this.length = n3;
        }

        public static Fragment getInstance(int n2, int n3) {
            return new Fragment(n2, n3);
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            return "[" + this.offset + " .. " + (this.offset + this.length - 1) + " (" + this.length + ")]";
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!object.getClass().equals(Fragment.class)) {
                return false;
            }
            object = (Fragment)object;
            return ((Fragment)object).offset == this.offset && ((Fragment)object).length == this.length;
        }

        public int hashCode() {
            return this.offset * 2 + this.length * 3 + 5;
        }
    }
}

