/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.iso19794;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import net.sf.scuba.data.Gender;
import org.jmrtd.lds.AbstractImageInfo;

public class FaceImageInfo
extends AbstractImageInfo {
    public static final long serialVersionUID = -1751069410327594067L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final int EYE_COLOR_UNSPECIFIED = 0;
    public static final int EYE_COLOR_BLACK = 1;
    public static final int EYE_COLOR_BLUE = 2;
    public static final int EYE_COLOR_BROWN = 3;
    public static final int EYE_COLOR_GRAY = 4;
    public static final int EYE_COLOR_GREEN = 5;
    public static final int EYE_COLOR_MULTI_COLORED = 6;
    public static final int EYE_COLOR_PINK = 7;
    public static final int EYE_COLOR_UNKNOWN = 255;
    public static final int HAIR_COLOR_UNSPECIFIED = 0;
    public static final int HAIR_COLOR_BALD = 1;
    public static final int HAIR_COLOR_BLACK = 2;
    public static final int HAIR_COLOR_BLONDE = 3;
    public static final int HAIR_COLOR_BROWN = 4;
    public static final int HAIR_COLOR_GRAY = 5;
    public static final int HAIR_COLOR_WHITE = 6;
    public static final int HAIR_COLOR_RED = 7;
    public static final int HAIR_COLOR_GREEN = 8;
    public static final int HAIR_COLOR_BLUE = 9;
    public static final int HAIR_COLOR_UNKNOWN = 255;
    public static final int FEATURE_FEATURES_ARE_SPECIFIED_FLAG = 1;
    public static final int FEATURE_GLASSES_FLAG = 2;
    public static final int FEATURE_MOUSTACHE_FLAG = 4;
    public static final int FEATURE_BEARD_FLAG = 8;
    public static final int FEATURE_TEETH_VISIBLE_FLAG = 16;
    public static final int FEATURE_BLINK_FLAG = 32;
    public static final int FEATURE_MOUTH_OPEN_FLAG = 64;
    public static final int FEATURE_LEFT_EYE_PATCH_FLAG = 128;
    public static final int FEATURE_RIGHT_EYE_PATCH = 256;
    public static final int FEATURE_DARK_GLASSES = 512;
    public static final int FEATURE_DISTORTING_MEDICAL_CONDITION = 1024;
    public static final short EXPRESSION_UNSPECIFIED = 0;
    public static final short EXPRESSION_NEUTRAL = 1;
    public static final short EXPRESSION_SMILE_CLOSED = 2;
    public static final short EXPRESSION_SMILE_OPEN = 3;
    public static final short EXPRESSION_RAISED_EYEBROWS = 4;
    public static final short EXPRESSION_EYES_LOOKING_AWAY = 5;
    public static final short EXPRESSION_SQUINTING = 6;
    public static final short EXPRESSION_FROWNING = 7;
    public static final int FACE_IMAGE_TYPE_BASIC = 0;
    public static final int FACE_IMAGE_TYPE_FULL_FRONTAL = 1;
    public static final int FACE_IMAGE_TYPE_TOKEN_FRONTAL = 2;
    public static final int IMAGE_DATA_TYPE_JPEG = 0;
    public static final int IMAGE_DATA_TYPE_JPEG2000 = 1;
    public static final int IMAGE_COLOR_SPACE_UNSPECIFIED = 0;
    public static final int IMAGE_COLOR_SPACE_RGB24 = 1;
    public static final int IMAGE_COLOR_SPACE_YUV422 = 2;
    public static final int IMAGE_COLOR_SPACE_GRAY8 = 3;
    public static final int IMAGE_COLOR_SPACE_OTHER = 4;
    public static final int SOURCE_TYPE_UNSPECIFIED = 0;
    public static final int SOURCE_TYPE_STATIC_PHOTO_UNKNOWN_SOURCE = 1;
    public static final int SOURCE_TYPE_STATIC_PHOTO_DIGITAL_CAM = 2;
    public static final int SOURCE_TYPE_STATIC_PHOTO_SCANNER = 3;
    public static final int SOURCE_TYPE_VIDEO_FRAME_UNKNOWN_SOURCE = 4;
    public static final int SOURCE_TYPE_VIDEO_FRAME_ANALOG_CAM = 5;
    public static final int SOURCE_TYPE_VIDEO_FRAME_DIGITAL_CAM = 6;
    public static final int SOURCE_TYPE_UNKNOWN = 7;
    public static final int YAW = 0;
    public static final int PITCH = 1;
    public static final int ROLL = 2;
    public long recordLength;
    public Gender gender;
    public EyeColor eyeColor;
    public int hairColor;
    public int featureMask;
    public int expression;
    public int[] poseAngle;
    public int[] poseAngleUncertainty;
    public FeaturePoint[] featurePoints;
    public int faceImageType;
    public int imageDataType;
    public int colorSpace;
    public int sourceType;
    public int deviceType;
    public int quality;

    public FaceImageInfo(Gender gender, EyeColor eyeColor, int n2, int n3, int n4, int[] nArray, int[] nArray2, int n5, int n6, int n7, int n8, int n9, FeaturePoint[] featurePointArray, int n10, int n11, InputStream inputStream, int n12, int n13) {
        long l2 = n12;
        String string = FaceImageInfo.toMimeType(n13);
        super(0, n10, n11, inputStream, l2, string);
        if (inputStream != null) {
            if (gender == null) {
                gender = Gender.UNSPECIFIED;
            }
            this.gender = gender;
            if (eyeColor == null) {
                eyeColor = EyeColor.UNSPECIFIED;
            }
            this.eyeColor = eyeColor;
            this.featureMask = n2;
            this.hairColor = n3;
            this.expression = n4;
            this.colorSpace = n6;
            this.sourceType = n7;
            this.deviceType = n8;
            int n14 = featurePointArray == null ? 0 : featurePointArray.length;
            this.featurePoints = new FeaturePoint[n14];
            if (n14 > 0) {
                System.arraycopy(featurePointArray, 0, this.featurePoints, 0, n14);
            }
            this.poseAngle = new int[3];
            System.arraycopy(nArray, 0, this.poseAngle, 0, 3);
            this.poseAngleUncertainty = new int[3];
            System.arraycopy(nArray2, 0, this.poseAngleUncertainty, 0, 3);
            this.imageDataType = n13;
            this.recordLength = (long)(n14 * 8) + 20L + 12L + l2;
            this.faceImageType = n5;
            this.colorSpace = n6;
            this.sourceType = n7;
            this.deviceType = n8;
            this.quality = n9;
            return;
        }
        throw new IllegalArgumentException("Null image");
    }

    public FaceImageInfo(InputStream inputStream) {
        super(0);
        this.readObject(inputStream);
    }

    private void writeFacialRecordData(OutputStream outputStream) {
        DataOutputStream dataOutputStream;
        DataOutputStream dataOutputStream2 = dataOutputStream;
        dataOutputStream2(outputStream);
        dataOutputStream.writeShort(this.featurePoints.length);
        outputStream = this.gender;
        int n2 = outputStream == null ? Gender.UNSPECIFIED.toInt() : outputStream.toInt();
        dataOutputStream2.writeByte(n2);
        EyeColor eyeColor = this.eyeColor;
        int n3 = eyeColor == null ? EyeColor.UNSPECIFIED.toInt() : eyeColor.toInt();
        dataOutputStream2.writeByte(n3);
        dataOutputStream2.writeByte(this.hairColor);
        dataOutputStream2.writeByte((byte)(((long)this.featureMask & 0xFF0000L) >> 16));
        dataOutputStream2.writeByte((byte)(((long)this.featureMask & 0xFF00L) >> 8));
        dataOutputStream2.writeByte((byte)((long)this.featureMask & 0xFFL));
        dataOutputStream2.writeShort(this.expression);
        for (n3 = 0; n3 < 3; ++n3) {
            dataOutputStream2.writeByte(this.poseAngle[n3]);
        }
        for (n3 = 0; n3 < 3; ++n3) {
            dataOutputStream2.writeByte(this.poseAngleUncertainty[n3]);
        }
        FeaturePoint[] featurePointArray = this.featurePoints;
        int n4 = this.featurePoints.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            DataOutputStream dataOutputStream3 = dataOutputStream2;
            FeaturePoint featurePoint = featurePointArray[i2];
            dataOutputStream3.writeByte(featurePoint.getType());
            dataOutputStream3.writeByte(featurePoint.getMajorCode() << 4 | featurePoint.getMinorCode());
            dataOutputStream3.writeShort(featurePoint.getX());
            dataOutputStream3.writeShort(featurePoint.getY());
            dataOutputStream3.writeShort(0);
        }
        DataOutputStream dataOutputStream4 = dataOutputStream2;
        DataOutputStream dataOutputStream5 = dataOutputStream2;
        dataOutputStream2.writeByte(this.faceImageType);
        dataOutputStream2.writeByte(this.imageDataType);
        dataOutputStream2.writeShort(this.getWidth());
        dataOutputStream2.writeShort(this.getHeight());
        dataOutputStream2.writeByte(this.colorSpace);
        dataOutputStream2.writeByte(this.sourceType);
        dataOutputStream2.writeShort(this.deviceType);
        dataOutputStream5.writeShort(this.quality);
        this.writeImage(dataOutputStream5);
        dataOutputStream4.flush();
        dataOutputStream4.close();
    }

    private String hairColorToString() {
        switch (this.hairColor) {
            default: {
                return "unknown";
            }
            case 9: {
                return "blue";
            }
            case 8: {
                return "green";
            }
            case 7: {
                return "red";
            }
            case 6: {
                return "white";
            }
            case 5: {
                return "gray";
            }
            case 4: {
                return "brown";
            }
            case 3: {
                return "blonde";
            }
            case 2: {
                return "black";
            }
            case 1: {
                return "bald";
            }
            case 0: 
        }
        return "unspecified";
    }

    private String featureMaskToString() {
        StringBuilder stringBuilder;
        ArrayList<String> arrayList;
        if ((((FaceImageInfo)serializable).featureMask & 1) == 0) {
            return "";
        }
        Object object = arrayList;
        arrayList = new ArrayList<String>();
        if ((((FaceImageInfo)serializable).featureMask & 2) != 0) {
            object.add("glasses");
        }
        if ((((FaceImageInfo)serializable).featureMask & 4) != 0) {
            object.add("moustache");
        }
        if ((((FaceImageInfo)serializable).featureMask & 8) != 0) {
            object.add("beard");
        }
        if ((((FaceImageInfo)serializable).featureMask & 0x10) != 0) {
            object.add("teeth visible");
        }
        if ((((FaceImageInfo)serializable).featureMask & 0x20) != 0) {
            object.add("blink");
        }
        if ((((FaceImageInfo)serializable).featureMask & 0x40) != 0) {
            object.add("mouth open");
        }
        if ((((FaceImageInfo)serializable).featureMask & 0x80) != 0) {
            object.add("left eye patch");
        }
        if ((((FaceImageInfo)serializable).featureMask & 0x100) != 0) {
            object.add("right eye patch");
        }
        if ((((FaceImageInfo)serializable).featureMask & 0x200) != 0) {
            object.add("dark glasses");
        }
        if ((((FaceImageInfo)serializable).featureMask & 0x400) != 0) {
            object.add("distorting medical condition (which could impact feature point detection)");
        }
        Serializable serializable = stringBuilder;
        stringBuilder = new StringBuilder();
        object = object.iterator();
        while (object.hasNext()) {
            ((StringBuilder)serializable).append((String)object.next());
            if (!object.hasNext()) continue;
            ((StringBuilder)serializable).append(", ");
        }
        return ((StringBuilder)serializable).toString();
    }

    private String expressionToString() {
        switch (this.expression) {
            default: {
                return "unknown";
            }
            case 7: {
                return "frowning";
            }
            case 6: {
                return "squinting";
            }
            case 5: {
                return "eyes looking away from the camera";
            }
            case 4: {
                return "raised eyebrows";
            }
            case 3: {
                return "a smile where the inside of the mouth and/or teeth is exposed";
            }
            case 2: {
                return "a smile where the inside of the mouth and/or teeth is not exposed (closed jaw)";
            }
            case 1: {
                return "neutral (non-smiling) with both eyes open and mouth closed";
            }
            case 0: 
        }
        return "unspecified";
    }

    private String poseAngleToString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append("(");
        stringBuilder2.append("y: ").append(this.poseAngle[0]);
        if (this.poseAngleUncertainty[0] != 0) {
            stringBuilder2.append(" (").append(this.poseAngleUncertainty[0]).append(")");
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(", ");
        stringBuilder3.append("p:").append(this.poseAngle[1]);
        if (this.poseAngleUncertainty[1] != 0) {
            stringBuilder2.append(" (").append(this.poseAngleUncertainty[1]).append(")");
        }
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder4.append(", ");
        stringBuilder4.append("r: ").append(this.poseAngle[2]);
        if (this.poseAngleUncertainty[2] != 0) {
            stringBuilder2.append(" (").append(this.poseAngleUncertainty[2]).append(")");
        }
        StringBuilder stringBuilder5 = stringBuilder2;
        stringBuilder5.append(")");
        return stringBuilder5.toString();
    }

    private String faceImageTypeToString() {
        int n2 = this.faceImageType;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    return "unknown";
                }
                return "token frontal";
            }
            return "full frontal";
        }
        return "basic";
    }

    private String sourceTypeToString() {
        switch (this.sourceType) {
            default: {
                return "unknown";
            }
            case 6: {
                return "single video frame from a digital camera";
            }
            case 5: {
                return "single video frame from an analogue camera";
            }
            case 4: {
                return "single video frame from an unknown source";
            }
            case 3: {
                return "static photograph from a scanner";
            }
            case 2: {
                return "static photograph from a digital still-image camera";
            }
            case 1: {
                return "static photograph from an unknown source";
            }
            case 0: 
        }
        return "unspecified";
    }

    public static String toMimeType(int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                LOGGER.warning("Unknown image type: " + n2);
                return null;
            }
            return "image/jp2";
        }
        return "image/jpeg";
    }

    @Override
    public void readObject(InputStream inputStream) {
        int n2;
        DataInputStream dataInputStream;
        if (inputStream instanceof DataInputStream) {
            dataInputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream2;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(inputStream);
        }
        this.recordLength = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        int n3 = dataInputStream.readUnsignedShort();
        FaceImageInfo faceImageInfo = this;
        FaceImageInfo faceImageInfo2 = this;
        this.gender = Gender.getInstance((int)dataInputStream.readUnsignedByte());
        this.eyeColor = EyeColor.toEyeColor(dataInputStream.readUnsignedByte());
        this.hairColor = dataInputStream.readUnsignedByte();
        this.featureMask = dataInputStream.readUnsignedByte();
        this.featureMask = this.featureMask << 16 | dataInputStream.readUnsignedShort();
        faceImageInfo2.expression = dataInputStream.readShort();
        faceImageInfo2.poseAngle = new int[3];
        this.poseAngle[0] = n2 = dataInputStream.readUnsignedByte();
        this.poseAngle[1] = n2 = dataInputStream.readUnsignedByte();
        faceImageInfo.poseAngle[2] = n2 = dataInputStream.readUnsignedByte();
        faceImageInfo.poseAngleUncertainty = new int[3];
        faceImageInfo.poseAngleUncertainty[0] = dataInputStream.readUnsignedByte();
        faceImageInfo.poseAngleUncertainty[1] = dataInputStream.readUnsignedByte();
        faceImageInfo.poseAngleUncertainty[2] = dataInputStream.readUnsignedByte();
        this.featurePoints = new FeaturePoint[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            DataInputStream dataInputStream3 = dataInputStream;
            int n4 = dataInputStream3.readUnsignedByte();
            byte by = dataInputStream3.readByte();
            int n5 = dataInputStream3.readUnsignedShort();
            int n6 = dataInputStream3.readUnsignedShort();
            for (long i2 = 0L; i2 < 2L; i2 += dataInputStream.skip(2L)) {
            }
            this.featurePoints[n2] = new FeaturePoint(n4, by, n5, n6);
        }
        this.faceImageType = dataInputStream.readUnsignedByte();
        this.imageDataType = dataInputStream.readUnsignedByte();
        this.setWidth(dataInputStream.readUnsignedShort());
        this.setHeight(dataInputStream.readUnsignedShort());
        this.colorSpace = dataInputStream.readUnsignedByte();
        this.sourceType = dataInputStream.readUnsignedByte();
        this.deviceType = dataInputStream.readUnsignedShort();
        this.quality = dataInputStream.readUnsignedShort();
        if (this.getWidth() <= 0) {
            this.setWidth(800);
        }
        if (this.getHeight() <= 0) {
            this.setHeight(600);
        }
        FaceImageInfo faceImageInfo3 = this;
        faceImageInfo3.setMimeType(FaceImageInfo.toMimeType(faceImageInfo3.imageDataType));
        this.readImage(inputStream, faceImageInfo3.recordLength - 20L - (long)(n3 * 8) - 12L);
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        DataOutputStream dataOutputStream;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((FaceImageInfo)object).writeFacialRecordData(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Object object = byArray;
        long l2 = (long)byArray.length + 4L;
        DataOutputStream dataOutputStream2 = dataOutputStream;
        dataOutputStream2(outputStream);
        dataOutputStream2.writeInt((int)l2);
        dataOutputStream.write((byte[])object);
        dataOutputStream.flush();
    }

    @Override
    public long getRecordLength() {
        return this.recordLength;
    }

    public FeaturePoint[] getFeaturePoints() {
        return this.featurePoints;
    }

    public int getExpression() {
        return this.expression;
    }

    public EyeColor getEyeColor() {
        return this.eyeColor;
    }

    public Gender getGender() {
        return this.gender;
    }

    public int getHairColor() {
        return this.hairColor;
    }

    public int getFaceImageType() {
        return this.faceImageType;
    }

    public int getFeatureMask() {
        return this.featureMask;
    }

    public int getQuality() {
        return this.quality;
    }

    public int getSourceType() {
        return this.sourceType;
    }

    public int getImageDataType() {
        return this.imageDataType;
    }

    public int getColorSpace() {
        return this.colorSpace;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public int[] getPoseAngle() {
        int[] nArray = new int[3];
        int n2 = nArray.length;
        System.arraycopy(this.poseAngle, 0, nArray, 0, n2);
        return nArray;
    }

    public int[] getPoseAngleUncertainty() {
        int[] nArray = new int[3];
        int n2 = nArray.length;
        System.arraycopy(this.poseAngleUncertainty, 0, nArray, 0, n2);
        return nArray;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append("Image size: ").append(featurePointArray.getWidth()).append(" x ").append(featurePointArray.getHeight()).append("\n");
        StringBuilder stringBuilder3 = stringBuilder2.append("Gender: ");
        Object object = featurePointArray.gender;
        if (object == null) {
            object = Gender.UNSPECIFIED;
        }
        stringBuilder3.append(object).append("\n");
        stringBuilder3 = stringBuilder2.append("Eye color: ");
        object = featurePointArray.eyeColor;
        if (object == null) {
            object = EyeColor.UNSPECIFIED;
        }
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder3.append(object).append("\n");
        stringBuilder4.append("Hair color: ").append(featurePointArray.hairColorToString()).append("\n");
        stringBuilder4.append("Feature mask: ").append(featurePointArray.featureMaskToString()).append("\n");
        stringBuilder4.append("Expression: ").append(featurePointArray.expressionToString()).append("\n");
        stringBuilder4.append("Pose angle: ").append(featurePointArray.poseAngleToString()).append("\n");
        stringBuilder4.append("Face image type: ").append(featurePointArray.faceImageTypeToString()).append("\n");
        stringBuilder4.append("Source type: ").append(featurePointArray.sourceTypeToString()).append("\n");
        stringBuilder4.append("Feature points: ").append("\n");
        FeaturePoint[] featurePointArray = featurePointArray.featurePoints;
        if (featurePointArray.featurePoints != null && featurePointArray.length != 0) {
            for (FeaturePoint featurePoint : featurePointArray) {
                stringBuilder2.append("   ").append(featurePoint.toString()).append("\n");
            }
        } else {
            stringBuilder2.append("   (none)\n");
        }
        return stringBuilder2.toString();
    }

    @Override
    public int hashCode() {
        FaceImageInfo faceImageInfo = this;
        int n2 = (((super.hashCode() * 31 + this.colorSpace) * 31 + this.deviceType) * 31 + this.expression) * 31;
        EyeColor eyeColor = faceImageInfo.eyeColor;
        int n3 = eyeColor == null ? 0 : eyeColor.hashCode();
        n2 = ((((n2 + n3) * 31 + this.faceImageType) * 31 + this.featureMask) * 31 + Arrays.hashCode(this.featurePoints)) * 31;
        Gender gender = this.gender;
        int n4 = gender == null ? 0 : gender.hashCode();
        long l2 = this.recordLength;
        return (((((((n2 + n4) * 31 + this.hairColor) * 31 + this.imageDataType) * 31 + Arrays.hashCode(this.poseAngle)) * 31 + Arrays.hashCode(this.poseAngleUncertainty)) * 31 + this.quality) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + this.sourceType;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (FaceImageInfo.class != object.getClass()) {
            return false;
        }
        object = (FaceImageInfo)object;
        return this.colorSpace == ((FaceImageInfo)object).colorSpace && this.deviceType == ((FaceImageInfo)object).deviceType && this.expression == ((FaceImageInfo)object).expression && this.eyeColor == ((FaceImageInfo)object).eyeColor && this.faceImageType == ((FaceImageInfo)object).faceImageType && this.featureMask == ((FaceImageInfo)object).featureMask && Arrays.equals(this.featurePoints, ((FaceImageInfo)object).featurePoints) && this.gender == ((FaceImageInfo)object).gender && this.hairColor == ((FaceImageInfo)object).hairColor && this.imageDataType == ((FaceImageInfo)object).imageDataType && Arrays.equals(this.poseAngle, ((FaceImageInfo)object).poseAngle) && Arrays.equals(this.poseAngleUncertainty, ((FaceImageInfo)object).poseAngleUncertainty) && this.quality == ((FaceImageInfo)object).quality && this.recordLength == ((FaceImageInfo)object).recordLength && this.sourceType == ((FaceImageInfo)object).sourceType;
    }

    public static enum EyeColor {
        UNSPECIFIED(0),
        BLACK(1),
        BLUE(2),
        BROWN(3),
        GRAY(4),
        GREEN(5),
        MULTI_COLORED(6),
        PINK(7),
        UNKNOWN(255);

        public int code;

        public EyeColor(int n3) {
            this.code = n3;
        }

        public static EyeColor toEyeColor(int n2) {
            for (EyeColor eyeColor : EyeColor.values()) {
                if (eyeColor.toInt() != n2) continue;
                return eyeColor;
            }
            return UNKNOWN;
        }

        public int toInt() {
            return this.code;
        }
    }

    public static enum HairColor {
        UNSPECIFIED(0),
        BALD(1),
        BLACK(2),
        BLONDE(3),
        BROWN(4),
        GRAY(5),
        WHITE(6),
        RED(7),
        GREEN(8),
        BLUE(9),
        UNKNOWN(255);

        public int code;

        public HairColor(int n3) {
            this.code = n3;
        }

        public static HairColor toHairColor(int n2) {
            for (HairColor hairColor : HairColor.values()) {
                if (hairColor.toInt() != n2) continue;
                return hairColor;
            }
            return UNKNOWN;
        }

        public int toInt() {
            return this.code;
        }
    }

    public static enum Features {
        FEATURES_ARE_SPECIFIED,
        GLASSES,
        MOUSTACHE,
        BEARD,
        TEETH_VISIBLE,
        BLINK,
        MOUTH_OPEN,
        LEFT_EYE_PATCH,
        RIGHT_EYE_PATCH,
        DARK_GLASSES,
        DISTORTING_MEDICAL_CONDITION;

    }

    public static enum Expression {
        UNSPECIFIED,
        NEUTRAL,
        SMILE_CLOSED,
        SMILE_OPEN,
        RAISED_EYEBROWS,
        EYES_LOOKING_AWAY,
        SQUINTING,
        FROWNING;

    }

    public static enum FaceImageType {
        BASIC,
        FULL_FRONTAL,
        TOKEN_FRONTAL;

    }

    public static enum ImageDataType {
        TYPE_JPEG,
        TYPE_JPEG2000;

    }

    public static enum ImageColorSpace {
        UNSPECIFIED,
        RGB24,
        YUV422,
        GRAY8,
        OTHER;

    }

    public static enum SourceType {
        UNSPECIFIED,
        STATIC_PHOTO_UNKNOWN_SOURCE,
        STATIC_PHOTO_DIGITAL_CAM,
        STATIC_PHOTO_SCANNER,
        VIDEO_FRAME_UNKNOWN_SOURCE,
        VIDEO_FRAME_ANALOG_CAM,
        VIDEO_FRAME_DIGITAL_CAM,
        UNKNOWN;

    }

    public static class FeaturePoint
    implements Serializable {
        public static final long serialVersionUID = -4209679423938065215L;
        public int type;
        public int majorCode;
        public int minorCode;
        public int x;
        public int y;

        public FeaturePoint(int n2, int n3, int n4, int n5, int n6) {
            this.type = n2;
            this.majorCode = n3;
            this.minorCode = n4;
            this.x = n5;
            this.y = n6;
        }

        public FeaturePoint(int n2, byte by, int n3, int n4) {
            this(n2, (by & 0xF0) >> 4, by & 0xF, n3, n4);
        }

        public int getMajorCode() {
            return this.majorCode;
        }

        public int getMinorCode() {
            return this.minorCode;
        }

        public int getType() {
            return this.type;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return "( point: " + this.getMajorCode() + "." + this.getMinorCode() + ", type: " + Integer.toHexString(this.type) + ", (" + this.x + ", " + this.y + "))";
        }
    }
}

