/*
 * Decompiled with CFR 0.152.
 */
package net.security.device.api.id;

import android.os.Build;
import android.text.TextUtils;
import java.lang.reflect.Method;
import net.security.device.api.LogUtil;

public final class SystemUtils {
    public static String sysProperty(String key, String defValue) {
        String res = null;
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method method = clazz.getMethod("get", String.class, String.class);
            res = (String)method.invoke(clazz, key, defValue);
        }
        catch (Exception e) {
            LogUtil.e(e.toString());
        }
        if (res == null) {
            res = "";
        }
        return res;
    }

    public static boolean isASUS() {
        return Build.MANUFACTURER.toUpperCase().equals("ASUS");
    }

    public static boolean isHuawei() {
        return Build.MANUFACTURER.toUpperCase().equals("HUAWEI");
    }

    public static boolean isZTE() {
        return Build.MANUFACTURER.toUpperCase().equals("ZTE");
    }

    public static boolean isXiaomi() {
        return Build.MANUFACTURER.toUpperCase().equals("XIAOMI");
    }

    public static boolean isOppo() {
        return Build.MANUFACTURER.toUpperCase().equals("OPPO");
    }

    public static boolean isVivo() {
        return Build.MANUFACTURER.toUpperCase().equals("VIVO");
    }

    public static boolean isOnePlus() {
        return Build.MANUFACTURER.toUpperCase().equals("ONEPLUS");
    }

    public static boolean isBlackShark() {
        return Build.MANUFACTURER.toUpperCase().equals("BLACKSHARK");
    }

    public static boolean isSamsung() {
        return Build.MANUFACTURER.toUpperCase().equals("SAMSUNG");
    }

    public static boolean isMotolora() {
        return Build.MANUFACTURER.toUpperCase().equals("MOTOLORA");
    }

    public static boolean isNubia() {
        return Build.MANUFACTURER.toUpperCase().equals("NUBIA");
    }

    public static boolean isMeizu() {
        return Build.MANUFACTURER.toUpperCase().equals("MEIZU");
    }

    public static boolean isLenovo() {
        return Build.MANUFACTURER.toUpperCase().equals("LENOVO");
    }

    public static boolean isFreeme() {
        if (Build.MANUFACTURER.toUpperCase().equals("FREEMEOS")) {
            return true;
        }
        String pro = SystemUtils.sysProperty("ro.build.freeme.label", "");
        return !TextUtils.isEmpty((CharSequence)pro) && pro.toUpperCase().equals("FREEMEOS");
    }

    public static boolean isSSUI() {
        if (Build.MANUFACTURER.toUpperCase().equals("SSUI")) {
            return true;
        }
        String pro = SystemUtils.sysProperty("ro.ssui.product", "unknown");
        return !TextUtils.isEmpty((CharSequence)pro) && !pro.toUpperCase().equals("UNKNOWN");
    }
}

