/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.math.BigInteger;
import org.ejbca.cvc.AbstractDataField;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.util.StringConverter;

public class ByteField
extends AbstractDataField {
    public static final long serialVersionUID = 1L;
    public byte[] data;
    public boolean showBitLength = false;

    public ByteField(CVCTagEnum cVCTagEnum) {
        super(cVCTagEnum);
    }

    public ByteField(CVCTagEnum cVCTagEnum, byte[] byArray) {
        this(cVCTagEnum, byArray, false);
    }

    public ByteField(CVCTagEnum cVCTagEnum, byte[] byArray, boolean bl) {
        super(cVCTagEnum);
        this.data = byArray;
        this.showBitLength = bl;
    }

    public boolean isShowBitLength() {
        return this.showBitLength;
    }

    public void setShowBitLength(boolean bl) {
        this.showBitLength = bl;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public byte[] getEncoded() {
        return this.data;
    }

    @Override
    public String valueAsText() {
        String string = "";
        if (this.showBitLength) {
            int n2 = 0;
            byte[] byArray = this.data;
            if (this.data != null) {
                n2 = new BigInteger(1, byArray).bitLength();
            }
            string = "[" + n2 + "]  ";
        }
        return string + StringConverter.byteToHex(this.data);
    }
}

