/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.ejbca.cvc.AbstractDataField;
import org.ejbca.cvc.CVCTagEnum;

public class DateField
extends AbstractDataField {
    public static final long serialVersionUID = 6092901788235446614L;
    public static final int DATE_ARRAY_SIZE = 6;
    public static final TimeZone GMTTIMEZONE = TimeZone.getTimeZone("GMT");
    public static final DateFormat FORMAT_PRINTABLE = new SimpleDateFormat("yyyy-MM-dd");
    public Date date;

    public DateField(CVCTagEnum cVCTagEnum) {
        super(cVCTagEnum);
    }

    public DateField(CVCTagEnum cVCTagEnum, Date date) {
        ((DateField)serializable)(cVCTagEnum);
        Serializable serializable = Calendar.getInstance(GMTTIMEZONE);
        ((Calendar)serializable).setTimeInMillis(date.getTime());
        int n2 = ((Calendar)serializable).get(1);
        int n3 = ((Calendar)serializable).get(2);
        int n4 = ((Calendar)serializable).get(5);
        ((Calendar)serializable).clear();
        ((Calendar)serializable).set(n2, n3, n4);
        v3.date = ((Calendar)serializable).getTime();
    }

    public DateField(CVCTagEnum object, byte[] byArray) {
        this((CVCTagEnum)((Object)object));
        if (byArray != null && byArray.length == 6) {
            int n2 = byArray[0] * 10 + 2000 + byArray[1];
            int n3 = byArray[2] * 10 + byArray[3] - 1;
            int n4 = byArray[4] * 10 + byArray[5];
            Calendar calendar = Calendar.getInstance(GMTTIMEZONE);
            calendar.clear();
            if (object == CVCTagEnum.EFFECTIVE_DATE) {
                calendar.set(n2, n3, n4, 0, 0, 0);
            } else {
                calendar.set(n2, n3, n4, 23, 59, 59);
            }
            this.date = calendar.getTime();
            return;
        }
        object = new StringBuilder().append("data argument must have length 6, was ");
        int n5 = byArray != null ? byArray.length : 0;
        Serializable serializable = this;
        super(((StringBuilder)object).append(n5).toString());
        throw serializable;
    }

    static {
        FORMAT_PRINTABLE.setTimeZone(GMTTIMEZONE);
    }

    public Date getDate() {
        return this.date;
    }

    @Override
    public byte[] getEncoded() {
        byte[] byArray = new byte[6];
        byte[] byArray2 = byArray;
        Calendar calendar = Calendar.getInstance(GMTTIMEZONE);
        calendar.setTimeInMillis(this.date.getTime());
        int n2 = calendar.get(1) - 2000;
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(5);
        byArray2[0] = (byte)(n2 / 10);
        byArray2[1] = (byte)(n2 % 10);
        byArray2[2] = (byte)(n3 / 10);
        byArray2[3] = (byte)(n3 % 10);
        byArray2[4] = (byte)(n4 / 10);
        byArray[5] = (byte)(n4 % 10);
        return byArray;
    }

    @Override
    public String valueAsText() {
        return FORMAT_PRINTABLE.format(this.date);
    }
}

