/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.cert;

import org.ejbca.cvc.AccessRightEnum;
import org.ejbca.cvc.AuthorizationRoleEnum;

public class CVCAuthorizationTemplate {
    public Role role;
    public Permission accessRight;

    public CVCAuthorizationTemplate(org.ejbca.cvc.CVCAuthorizationTemplate cVCAuthorizationTemplate) {
        this.role = CVCAuthorizationTemplate.toRole(cVCAuthorizationTemplate);
        this.accessRight = CVCAuthorizationTemplate.toPermission(cVCAuthorizationTemplate);
    }

    public CVCAuthorizationTemplate(Role role, Permission permission) {
        this.role = role;
        this.accessRight = permission;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccessRightEnum fromPermission(Permission permission) {
        try {
            switch (permission.ordinal()) {
                default: {
                    throw new IllegalArgumentException("Error getting permission for " + (Object)((Object)permission));
                }
                case 4: {
                    return AccessRightEnum.READ_ACCESS_DG3_AND_DG4;
                }
                case 3: {
                    return AccessRightEnum.READ_ACCESS_DG4;
                }
                case 2: {
                    return AccessRightEnum.READ_ACCESS_DG3;
                }
                case 1: 
            }
            return AccessRightEnum.READ_ACCESS_NONE;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error getting permission from AuthZ template", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AuthorizationRoleEnum fromRole(Role role) {
        try {
            switch (role.ordinal()) {
                default: {
                    throw new IllegalArgumentException("Error getting role from AuthZ template " + (Object)((Object)role));
                }
                case 4: {
                    return AuthorizationRoleEnum.IS;
                }
                case 3: {
                    return AuthorizationRoleEnum.DV_F;
                }
                case 2: {
                    return AuthorizationRoleEnum.DV_D;
                }
                case 1: 
            }
            return AuthorizationRoleEnum.CVCA;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error getting role from AuthZ template", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Role toRole(org.ejbca.cvc.CVCAuthorizationTemplate object) {
        try {
            object = ((org.ejbca.cvc.CVCAuthorizationTemplate)object).getAuthorizationField().getRole();
            switch (((Enum)object).ordinal()) {
                default: {
                    throw new IllegalArgumentException("Unsupported role " + object);
                }
                case 4: {
                    return Role.IS;
                }
                case 3: {
                    return Role.DV_F;
                }
                case 2: {
                    return Role.DV_D;
                }
                case 1: 
            }
            return Role.CVCA;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException("Error getting role from AuthZ template", noSuchFieldException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Permission toPermission(org.ejbca.cvc.CVCAuthorizationTemplate object) {
        try {
            object = ((org.ejbca.cvc.CVCAuthorizationTemplate)object).getAuthorizationField().getAccessRight();
            switch (((Enum)object).ordinal()) {
                default: {
                    throw new IllegalArgumentException("Unsupported access right " + object);
                }
                case 4: {
                    return Permission.READ_ACCESS_DG3_AND_DG4;
                }
                case 3: {
                    return Permission.READ_ACCESS_DG4;
                }
                case 2: {
                    return Permission.READ_ACCESS_DG3;
                }
                case 1: 
            }
            return Permission.READ_ACCESS_NONE;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException("Unsupported access right", noSuchFieldException);
        }
    }

    public Role getRole() {
        return this.role;
    }

    public Permission getAccessRight() {
        return this.accessRight;
    }

    public String toString() {
        return this.role.toString() + this.accessRight.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!CVCAuthorizationTemplate.class.equals(object.getClass())) {
            return false;
        }
        object = (CVCAuthorizationTemplate)object;
        return this.role == ((CVCAuthorizationTemplate)object).role && this.accessRight == ((CVCAuthorizationTemplate)object).accessRight;
    }

    public int hashCode() {
        return this.role.value * 2 + this.accessRight.value * 3 + 61;
    }

    public static enum Role {
        CVCA(192),
        DV_D(128),
        DV_F(64),
        IS(0);

        public byte value;

        public Role(int n3) {
            this.value = (byte)n3;
        }

        public byte getValue() {
            return this.value;
        }
    }

    public static enum Permission {
        READ_ACCESS_NONE(0),
        READ_ACCESS_DG3(1),
        READ_ACCESS_DG4(2),
        READ_ACCESS_DG3_AND_DG4(3);

        public byte value;

        public Permission(int n3) {
            this.value = (byte)n3;
        }

        public boolean implies(Permission permission) {
            switch (this.ordinal()) {
                default: {
                    return false;
                }
                case 4: {
                    return permission == READ_ACCESS_DG3 || permission == READ_ACCESS_DG4 || permission == READ_ACCESS_DG3_AND_DG4;
                }
                case 3: {
                    return permission == READ_ACCESS_DG4;
                }
                case 2: {
                    return permission == READ_ACCESS_DG3;
                }
                case 1: 
            }
            return permission == READ_ACCESS_NONE;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

