/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;
import org.jmrtd.lds.DataGroup;
import org.jmrtd.lds.DisplayedImageInfo;

public abstract class DisplayedImageDataGroup
extends DataGroup {
    public static final long serialVersionUID = 5994136177872308962L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final int DISPLAYED_IMAGE_COUNT_TAG = 2;
    public int displayedImageTagToUse;
    public List<DisplayedImageInfo> imageInfos;

    public DisplayedImageDataGroup(int n2, List<DisplayedImageInfo> list, int n3) {
        super(n2);
        if (list != null) {
            this.displayedImageTagToUse = n3;
            this.imageInfos = new ArrayList<DisplayedImageInfo>(list);
            this.checkTypesConsistentWithTag();
            return;
        }
        throw new IllegalArgumentException("imageInfos cannot be null");
    }

    public DisplayedImageDataGroup(int n2, InputStream inputStream) {
        DisplayedImageDataGroup displayedImageDataGroup = this;
        super(n2, inputStream);
        if (displayedImageDataGroup.imageInfos == null) {
            this.imageInfos = new ArrayList<DisplayedImageInfo>();
        }
        this.checkTypesConsistentWithTag();
    }

    private void add(DisplayedImageInfo displayedImageInfo) {
        if (this.imageInfos == null) {
            this.imageInfos = new ArrayList<DisplayedImageInfo>();
        }
        this.imageInfos.add(displayedImageInfo);
    }

    private void checkTypesConsistentWithTag() {
        for (DisplayedImageInfo displayedImageInfo : this.imageInfos) {
            if (displayedImageInfo != null) {
                int n2 = displayedImageInfo.getType();
                if (n2 != 0) {
                    if (n2 != 1) {
                        LOGGER.warning("Unsupported image type");
                        continue;
                    }
                    if (this.displayedImageTagToUse == 24387) continue;
                    throw new IllegalArgumentException("'Portrait' image cannot be part of a 'Signature or usual mark' displayed image datagroup");
                }
                if (this.displayedImageTagToUse == 24384) continue;
                throw new IllegalArgumentException("'Signature or usual mark' image cannot be part of a 'Portrait' displayed image datagroup");
            }
            throw new IllegalArgumentException("Found a null image info");
        }
    }

    @Override
    public void readContent(InputStream inputStream) {
        int n2;
        block6: {
            block7: {
                Object object;
                if (inputStream instanceof TLVInputStream) {
                    inputStream = (TLVInputStream)inputStream;
                    object = inputStream;
                } else {
                    TLVInputStream tLVInputStream;
                    object = tLVInputStream;
                    tLVInputStream = new TLVInputStream(inputStream);
                }
                n2 = object.readTag();
                if (n2 != 2) break block6;
                if (object.readLength() != 1) break block7;
                n2 = object.readValue()[0] & 0xFF;
                for (int i2 = 0; i2 < n2; ++i2) {
                    block10: {
                        DisplayedImageInfo displayedImageInfo;
                        block9: {
                            block8: {
                                DisplayedImageInfo displayedImageInfo2;
                                displayedImageInfo = displayedImageInfo2;
                                displayedImageInfo2 = new DisplayedImageInfo((InputStream)object);
                                if (i2 != 0) break block8;
                                this.displayedImageTagToUse = displayedImageInfo.getDisplayedImageTag();
                                break block9;
                            }
                            if (displayedImageInfo.getDisplayedImageTag() != this.displayedImageTagToUse) break block10;
                        }
                        this.add(displayedImageInfo);
                        continue;
                    }
                    throw new IOException("Found images with different displayed image tags inside displayed image datagroup");
                }
                return;
            }
            throw new IllegalArgumentException("DISPLAYED_IMAGE_COUNT should have length 1");
        }
        throw new IllegalArgumentException("Expected tag 0x02 in displayed image structure, found " + Integer.toHexString(n2));
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        Object object;
        if (outputStream instanceof TLVOutputStream) {
            outputStream = (TLVOutputStream)outputStream;
            object = outputStream;
        } else {
            TLVOutputStream tLVOutputStream;
            object = tLVOutputStream;
            tLVOutputStream = new TLVOutputStream(outputStream);
        }
        Object object2 = object;
        object2.writeTag(2);
        object2.writeValue(new byte[]{(byte)((DisplayedImageDataGroup)((Object)iterator)).imageInfos.size()});
        Iterator<DisplayedImageInfo> iterator = ((DisplayedImageDataGroup)((Object)iterator)).imageInfos.iterator();
        while (iterator.hasNext()) {
            ((DisplayedImageInfo)iterator.next()).writeObject((OutputStream)object);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" [");
        boolean bl = true;
        Object object = this.imageInfos;
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                DisplayedImageInfo displayedImageInfo = (DisplayedImageInfo)object.next();
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder2.append(", ");
                }
                stringBuilder2.append(displayedImageInfo.toString());
            }
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3.append("]");
            return stringBuilder3.toString();
        }
        throw new IllegalStateException("imageInfos cannot be null");
    }

    public int hashCode() {
        int n2 = 1337;
        List<DisplayedImageInfo> list = this.imageInfos;
        return (list == null ? 1 : list.hashCode()) + n2 + 31337;
    }

    public boolean equals(Object list) {
        if (list == null) {
            return false;
        }
        if (list == list2) {
            return true;
        }
        if (!list2.getClass().equals(list.getClass())) {
            return false;
        }
        DisplayedImageDataGroup displayedImageDataGroup = list2;
        List<DisplayedImageInfo> list2 = (DisplayedImageDataGroup)((Object)list);
        list = displayedImageDataGroup.imageInfos;
        list2 = ((DisplayedImageDataGroup)((Object)list2)).imageInfos;
        return list == list2 || list != null && list.equals(list2);
    }

    public List<DisplayedImageInfo> getImages() {
        return new ArrayList<DisplayedImageInfo>(this.imageInfos);
    }
}

