/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import org.eid_bc.bouncycastle.asn1.ASN1Encodable;
import org.eid_bc.bouncycastle.asn1.ASN1EncodableVector;
import org.eid_bc.bouncycastle.asn1.ASN1Integer;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.asn1.ASN1Primitive;
import org.eid_bc.bouncycastle.asn1.ASN1Sequence;
import org.eid_bc.bouncycastle.asn1.DLSequence;
import org.jmrtd.lds.SecurityInfo;

public class PACEInfo
extends SecurityInfo {
    public static final long serialVersionUID = 7960925013249578359L;
    public static final int PARAM_ID_GFP_1024_160 = 0;
    public static final int PARAM_ID_GFP_2048_224 = 1;
    public static final int PARAM_ID_GFP_2048_256 = 2;
    public static final int PARAM_ID_ECP_NIST_P192_R1 = 8;
    public static final int PARAM_ID_ECP_BRAINPOOL_P192_R1 = 9;
    public static final int PARAM_ID_ECP_NIST_P224_R1 = 10;
    public static final int PARAM_ID_ECP_BRAINPOOL_P224_R1 = 11;
    public static final int PARAM_ID_ECP_NIST_P256_R1 = 12;
    public static final int PARAM_ID_ECP_BRAINPOOL_P256_R1 = 13;
    public static final int PARAM_ID_ECP_BRAINPOOL_P320_R1 = 14;
    public static final int PARAM_ID_ECP_NIST_P384_R1 = 15;
    public static final int PARAM_ID_ECP_BRAINPOOL_P384_R1 = 16;
    public static final int PARAM_ID_ECP_BRAINPOOL_P512_R1 = 17;
    public static final int PARAM_ID_ECP_NIST_P521_R1 = 18;
    public String protocolOID;
    public int version;
    public BigInteger parameterId;

    public PACEInfo(String string, int n2, int n3) {
        this(string, n2, BigInteger.valueOf(n3));
    }

    public PACEInfo(String string, int n2, BigInteger bigInteger) {
        if (PACEInfo.checkRequiredIdentifier(string)) {
            if (n2 == 2) {
                this.protocolOID = string;
                this.version = n2;
                this.parameterId = bigInteger;
                return;
            }
            throw new IllegalArgumentException("Invalid version, must be 2");
        }
        throw new IllegalArgumentException("Invalid OID");
    }

    public static PACEInfo createPACEInfo(byte[] object) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)object);
        object = aSN1Sequence;
        String string = ((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)).getId();
        Object object2 = aSN1Sequence.getObjectAt(1).toASN1Primitive();
        ASN1Primitive aSN1Primitive = null;
        if (aSN1Sequence.size() == 3) {
            aSN1Primitive = object.getObjectAt(2).toASN1Primitive();
        }
        int n2 = ((ASN1Integer)object2).getValue().intValue();
        object2 = null;
        if (aSN1Primitive != null) {
            object2 = ((ASN1Integer)aSN1Primitive).getValue();
        }
        return new PACEInfo(string, n2, (BigInteger)object2);
    }

    public static boolean checkRequiredIdentifier(String string) {
        return false;
    }

    public static MappingType toMappingType(String string) {
        if (!("0.4.0.127.0.7.2.2.4.1.1".equals(string) || "0.4.0.127.0.7.2.2.4.1.2".equals(string) || "0.4.0.127.0.7.2.2.4.1.3".equals(string) || "0.4.0.127.0.7.2.2.4.1.4".equals(string) || "0.4.0.127.0.7.2.2.4.2.1".equals(string) || "0.4.0.127.0.7.2.2.4.2.2".equals(string) || "0.4.0.127.0.7.2.2.4.2.3".equals(string) || "0.4.0.127.0.7.2.2.4.2.4".equals(string))) {
            if (!("0.4.0.127.0.7.2.2.4.3.1".equals(string) || "0.4.0.127.0.7.2.2.4.3.2".equals(string) || "0.4.0.127.0.7.2.2.4.3.3".equals(string) || "0.4.0.127.0.7.2.2.4.3.4".equals(string) || "0.4.0.127.0.7.2.2.4.4.1".equals(string) || "0.4.0.127.0.7.2.2.4.4.2".equals(string) || "0.4.0.127.0.7.2.2.4.4.3".equals(string) || "0.4.0.127.0.7.2.2.4.4.4".equals(string))) {
                if (!("0.4.0.127.0.7.2.2.4.6.2".equals(string) || "0.4.0.127.0.7.2.2.4.6.3".equals(string) || "0.4.0.127.0.7.2.2.4.6.4".equals(string))) {
                    throw new NumberFormatException("Unknown OID: \"" + string + "\"");
                }
                return MappingType.CAM;
            }
            return MappingType.IM;
        }
        return MappingType.GM;
    }

    public static String toKeyAgreementAlgorithm(String string) {
        if (!("0.4.0.127.0.7.2.2.4.1.1".equals(string) || "0.4.0.127.0.7.2.2.4.1.2".equals(string) || "0.4.0.127.0.7.2.2.4.1.3".equals(string) || "0.4.0.127.0.7.2.2.4.1.4".equals(string) || "0.4.0.127.0.7.2.2.4.3.1".equals(string) || "0.4.0.127.0.7.2.2.4.3.2".equals(string) || "0.4.0.127.0.7.2.2.4.3.3".equals(string) || "0.4.0.127.0.7.2.2.4.3.4".equals(string))) {
            if (!("0.4.0.127.0.7.2.2.4.2.1".equals(string) || "0.4.0.127.0.7.2.2.4.2.2".equals(string) || "0.4.0.127.0.7.2.2.4.2.3".equals(string) || "0.4.0.127.0.7.2.2.4.2.4".equals(string) || "0.4.0.127.0.7.2.2.4.4.1".equals(string) || "0.4.0.127.0.7.2.2.4.4.2".equals(string) || "0.4.0.127.0.7.2.2.4.4.3".equals(string) || "0.4.0.127.0.7.2.2.4.4.4".equals(string) || "0.4.0.127.0.7.2.2.4.6.2".equals(string) || "0.4.0.127.0.7.2.2.4.6.3".equals(string) || "0.4.0.127.0.7.2.2.4.6.4".equals(string))) {
                throw new NumberFormatException("Unknown OID: \"" + string + "\"");
            }
            return "ECDH";
        }
        return "DH";
    }

    public static String toCipherAlgorithm(String string) {
        if (!("0.4.0.127.0.7.2.2.4.1.1".equals(string) || "0.4.0.127.0.7.2.2.4.3.1".equals(string) || "0.4.0.127.0.7.2.2.4.2.1".equals(string) || "0.4.0.127.0.7.2.2.4.4.1".equals(string))) {
            if (!("0.4.0.127.0.7.2.2.4.1.2".equals(string) || "0.4.0.127.0.7.2.2.4.1.3".equals(string) || "0.4.0.127.0.7.2.2.4.1.4".equals(string) || "0.4.0.127.0.7.2.2.4.3.2".equals(string) || "0.4.0.127.0.7.2.2.4.3.3".equals(string) || "0.4.0.127.0.7.2.2.4.3.4".equals(string) || "0.4.0.127.0.7.2.2.4.2.2".equals(string) || "0.4.0.127.0.7.2.2.4.2.3".equals(string) || "0.4.0.127.0.7.2.2.4.2.4".equals(string) || "0.4.0.127.0.7.2.2.4.4.2".equals(string) || "0.4.0.127.0.7.2.2.4.4.3".equals(string) || "0.4.0.127.0.7.2.2.4.4.4".equals(string) || "0.4.0.127.0.7.2.2.4.6.2".equals(string) || "0.4.0.127.0.7.2.2.4.6.3".equals(string) || "0.4.0.127.0.7.2.2.4.6.4".equals(string))) {
                throw new NumberFormatException("Unknown OID: \"" + string + "\"");
            }
            return "AES";
        }
        return "DESede";
    }

    public static String toDigestAlgorithm(String string) {
        if (!("0.4.0.127.0.7.2.2.4.1.1".equals(string) || "0.4.0.127.0.7.2.2.4.3.1".equals(string) || "0.4.0.127.0.7.2.2.4.2.1".equals(string) || "0.4.0.127.0.7.2.2.4.4.1".equals(string) || "0.4.0.127.0.7.2.2.4.1.2".equals(string) || "0.4.0.127.0.7.2.2.4.3.2".equals(string) || "0.4.0.127.0.7.2.2.4.2.2".equals(string) || "0.4.0.127.0.7.2.2.4.4.2".equals(string) || "0.4.0.127.0.7.2.2.4.6.2".equals(string))) {
            if (!("0.4.0.127.0.7.2.2.4.1.3".equals(string) || "0.4.0.127.0.7.2.2.4.3.3".equals(string) || "0.4.0.127.0.7.2.2.4.2.3".equals(string) || "0.4.0.127.0.7.2.2.4.4.3".equals(string) || "0.4.0.127.0.7.2.2.4.6.3".equals(string) || "0.4.0.127.0.7.2.2.4.1.4".equals(string) || "0.4.0.127.0.7.2.2.4.3.4".equals(string) || "0.4.0.127.0.7.2.2.4.2.4".equals(string) || "0.4.0.127.0.7.2.2.4.4.4".equals(string) || "0.4.0.127.0.7.2.2.4.6.4".equals(string))) {
                throw new NumberFormatException("Unknown OID: \"" + string + "\"");
            }
            return "SHA-256";
        }
        return "SHA-1";
    }

    public static int toKeyLength(String string) {
        if (!("0.4.0.127.0.7.2.2.4.1.1".equals(string) || "0.4.0.127.0.7.2.2.4.3.1".equals(string) || "0.4.0.127.0.7.2.2.4.2.1".equals(string) || "0.4.0.127.0.7.2.2.4.4.1".equals(string) || "0.4.0.127.0.7.2.2.4.1.2".equals(string) || "0.4.0.127.0.7.2.2.4.3.2".equals(string) || "0.4.0.127.0.7.2.2.4.2.2".equals(string) || "0.4.0.127.0.7.2.2.4.4.2".equals(string) || "0.4.0.127.0.7.2.2.4.6.2".equals(string))) {
            if (!("0.4.0.127.0.7.2.2.4.1.3".equals(string) || "0.4.0.127.0.7.2.2.4.2.3".equals(string) || "0.4.0.127.0.7.2.2.4.3.3".equals(string) || "0.4.0.127.0.7.2.2.4.4.3".equals(string) || "0.4.0.127.0.7.2.2.4.6.3".equals(string))) {
                if (!("0.4.0.127.0.7.2.2.4.1.4".equals(string) || "0.4.0.127.0.7.2.2.4.3.4".equals(string) || "0.4.0.127.0.7.2.2.4.2.4".equals(string) || "0.4.0.127.0.7.2.2.4.4.4".equals(string) || "0.4.0.127.0.7.2.2.4.6.4".equals(string))) {
                    throw new NumberFormatException("Unknown OID: \"" + string + "\"");
                }
                return 256;
            }
            return 192;
        }
        return 128;
    }

    public static AlgorithmParameterSpec toParameterSpec(BigInteger bigInteger) {
        return PACEInfo.toParameterSpec(bigInteger.intValue());
    }

    public static AlgorithmParameterSpec toParameterSpec(int n2) {
        throw new NumberFormatException("Unknown standardized domain parameters " + n2);
    }

    public static String toStandardizedParamIdString(BigInteger bigInteger) {
        if (bigInteger == null) {
            return "null";
        }
        int n2 = bigInteger.intValue();
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    switch (n2) {
                        default: {
                            return bigInteger.toString();
                        }
                        case 18: {
                            return "NIST P-521 (secp521r1)";
                        }
                        case 17: {
                            return "BrainpoolP512r1";
                        }
                        case 16: {
                            return "BrainpoolP384r1";
                        }
                        case 15: {
                            return "NIST P-384 (secp384r1)";
                        }
                        case 14: {
                            return "BrainpoolP320r1";
                        }
                        case 13: {
                            return "BrainpoolP256r1";
                        }
                        case 12: {
                            return "NIST P-256 (secp256r1)";
                        }
                        case 11: {
                            return "BrainpoolP224r1";
                        }
                        case 10: {
                            return "NIST P-224 (secp224r1)";
                        }
                        case 9: {
                            return "BrainpoolP192r1";
                        }
                        case 8: 
                    }
                    return "NIST P-192 (secp192r1)";
                }
                return "2048-bit MODP Group with 256-bit Prime Order Subgroup";
            }
            return "2048-bit MODP Group with 224-bit Prime Order Subgroup";
        }
        return "1024-bit MODP Group with 160-bit Prime Order Subgroup";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String toProtocolOIDString(String string) {
        if ("0.4.0.127.0.7.2.2.4.1.1".equals(string)) {
            return "id-PACE-DH-GM-3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.4.1.2".equals(string)) {
            return "id-PACE-DH-GM-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.4.1.3".equals(string)) {
            return "id-PACE-DH-GM-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.4.1.4".equals(string)) {
            return "id-PACE-DH-GM-AES-CBC-CMAC-256";
        }
        if ("0.4.0.127.0.7.2.2.4.3.1".equals(string)) {
            return "id-PACE-DH-IM-3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.4.3.2".equals(string)) {
            return "id-PACE-DH-IM-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.4.3.3".equals(string)) {
            return "id-PACE-DH-IM-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.4.3.4".equals(string)) {
            return "id-PACE_DH-IM-AES-CBC-CMAC-256";
        }
        if ("0.4.0.127.0.7.2.2.4.2.1".equals(string)) {
            return "id-PACE-ECDH-GM-3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.4.2.2".equals(string)) {
            return "id-PACE-ECDH-GM-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.4.2.3".equals(string)) {
            return "id-PACE-ECDH-GM-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.4.2.4".equals(string)) {
            return "id-PACE-ECDH-GM-AES-CBC-CMAC-256";
        }
        if ("0.4.0.127.0.7.2.2.4.4.1".equals(string)) {
            return "id-PACE-ECDH-IM_3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.4.4.2".equals(string)) {
            return "id-PACE-ECDH-IM-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.4.4.3".equals(string)) {
            return "id-PACE-ECDH-IM-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.4.4.4".equals(string)) {
            return "id-PACE-ECDH-IM-AES-CBC-CMAC-256";
        }
        if ("0.4.0.127.0.7.2.2.4.6.2".equals(string)) {
            return "id-PACE-ECDH-CAM-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.4.6.3".equals(string)) {
            return "id-PACE-ECDH-CAM-AES-CBC-CMAC-192";
        }
        if (!"0.4.0.127.0.7.2.2.4.6.4".equals(string)) return string;
        return "id-PACE-ECDH-CAM-AES-CBC-CMAC-256";
    }

    @Override
    public String getObjectIdentifier() {
        return this.protocolOID;
    }

    @Override
    public String getProtocolOIDString() {
        PACEInfo pACEInfo = this;
        return pACEInfo.toProtocolOIDString(pACEInfo.protocolOID);
    }

    public int getVersion() {
        return this.version;
    }

    public BigInteger getParameterId() {
        return this.parameterId;
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector().add((ASN1Encodable)new ASN1ObjectIdentifier(serializable.protocolOID));
        aSN1EncodableVector2.add((ASN1Encodable)new ASN1Integer((long)serializable.version));
        Serializable serializable = serializable.parameterId;
        if (serializable != null) {
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1Integer((BigInteger)serializable));
        }
        return new DLSequence(aSN1EncodableVector2);
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append("PACEInfo [");
        PACEInfo pACEInfo = this;
        stringBuilder2.append("protocol: ").append(pACEInfo.toProtocolOIDString(pACEInfo.protocolOID));
        stringBuilder2.append(", version: ").append(this.version);
        if (this.parameterId != null) {
            stringBuilder2.append(", parameterId: ").append(PACEInfo.toStandardizedParamIdString(this.parameterId));
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append("]");
        return stringBuilder3.toString();
    }

    public int hashCode() {
        PACEInfo pACEInfo = this;
        int n2 = pACEInfo.protocolOID.hashCode() * 7 + 1234567891 + this.version * 5;
        int n3 = 3;
        BigInteger bigInteger = pACEInfo.parameterId;
        return n2 + (bigInteger == null ? 1991 : bigInteger.hashCode()) * n3;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == pACEInfo2) {
            return true;
        }
        if (!PACEInfo.class.equals(object.getClass())) {
            return false;
        }
        PACEInfo pACEInfo = pACEInfo2;
        PACEInfo pACEInfo2 = (PACEInfo)object;
        return pACEInfo.getDERObject().equals((Object)pACEInfo2.getDERObject());
    }

    public static class DHCParameterSpec
    extends DHParameterSpec {
        public BigInteger q;

        public DHCParameterSpec(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            super(bigInteger, bigInteger2);
            this.q = bigInteger3;
        }

        public BigInteger getQ() {
            return this.q;
        }
    }

    public static enum MappingType {
        GM,
        IM,
        CAM;

    }
}

