/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.icao;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;
import net.sf.scuba.tlv.TLVUtil;
import net.sf.scuba.util.Hex;
import org.jmrtd.lds.DataGroup;

public class DG12File
extends DataGroup {
    public static final long serialVersionUID = -1979367459379125674L;
    public static final int TAG_LIST_TAG = 92;
    public static final int ISSUING_AUTHORITY_TAG = 24345;
    public static final int DATE_OF_ISSUE_TAG = 24358;
    public static final int NAME_OF_OTHER_PERSON_TAG = 24346;
    public static final int ENDORSEMENTS_AND_OBSERVATIONS_TAG = 24347;
    public static final int TAX_OR_EXIT_REQUIREMENTS_TAG = 24348;
    public static final int IMAGE_OF_FRONT_TAG = 24349;
    public static final int IMAGE_OF_REAR_TAG = 24350;
    public static final int DATE_AND_TIME_OF_PERSONALIZATION_TAG = 24405;
    public static final int PERSONALIZATION_SYSTEM_SERIAL_NUMBER_TAG = 24406;
    public static final int CONTENT_SPECIFIC_CONSTRUCTED_TAG = 160;
    public static final int COUNT_TAG = 2;
    public static final String SDF = "yyyyMMdd";
    public static final String SDTF = "yyyyMMddhhmmss";
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public String issuingAuthority;
    public String dateOfIssue;
    public List<String> namesOfOtherPersons;
    public String endorsementsAndObservations;
    public String taxOrExitRequirements;
    public byte[] imageOfFront;
    public byte[] imageOfRear;
    public String dateAndTimeOfPersonalization;
    public String personalizationSystemSerialNumber;
    public List<Integer> tagPresenceList;

    public DG12File(String string, Date date, List<String> list, String string2, String string3, byte[] byArray, byte[] byArray2, Date date2, String string4) {
        this(string, new SimpleDateFormat(SDF).format(date), list, string2, string3, byArray, byArray2, new SimpleDateFormat(SDTF).format(date2), string4);
    }

    public DG12File(String object, String string, List<String> list, String string2, String string3, byte[] byArray, byte[] byArray2, String string4, String string5) {
        super(108);
        this.issuingAuthority = object;
        this.dateOfIssue = string;
        if (list == null) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
        } else {
            ArrayList<String> arrayList;
            object = arrayList;
            arrayList = new ArrayList<String>(list);
        }
        this.namesOfOtherPersons = object;
        this.endorsementsAndObservations = string2;
        this.taxOrExitRequirements = string3;
        this.imageOfFront = byArray;
        this.imageOfRear = byArray2;
        this.dateAndTimeOfPersonalization = string4;
        this.personalizationSystemSerialNumber = string5;
    }

    public DG12File(InputStream inputStream) {
        super(108, inputStream);
    }

    private void readField(int n2, TLVInputStream tLVInputStream) {
        int n3;
        block24: {
            block23: {
                block19: {
                    block20: {
                        block21: {
                            byte[] byArray;
                            block22: {
                                n3 = tLVInputStream.readTag();
                                if (n3 != 160) break block19;
                                TLVInputStream tLVInputStream2 = tLVInputStream;
                                tLVInputStream2.readLength();
                                n2 = tLVInputStream2.readTag();
                                if (n2 != 2) break block20;
                                n2 = tLVInputStream.readLength();
                                if (n2 != 1) break block21;
                                byArray = tLVInputStream.readValue();
                                if (byArray == null || byArray.length != 1) break block22;
                                int n4 = byArray[0] & 0xFF;
                                for (n3 = 0; n3 < n4; ++n3) {
                                    int n5 = tLVInputStream.readTag();
                                    if (n5 == 24346) {
                                        TLVInputStream tLVInputStream3 = tLVInputStream;
                                        tLVInputStream3.readLength();
                                        this.parseNameOfOtherPerson(tLVInputStream3.readValue());
                                        continue;
                                    }
                                    throw new IllegalArgumentException("Expected " + Integer.toHexString(24346) + ", found " + Integer.toHexString(n5));
                                }
                                break block23;
                            }
                            throw new IllegalArgumentException("Number of content specific fields should be encoded in single byte, found " + Arrays.toString(byArray));
                        }
                        throw new IllegalArgumentException("Expected length 1 count length, found " + n2);
                    }
                    throw new IllegalArgumentException("Expected " + Integer.toHexString(2) + ", found " + Integer.toHexString(n2));
                }
                if (n3 != n2) break block24;
                TLVInputStream tLVInputStream4 = tLVInputStream;
                tLVInputStream4.readLength();
                byte[] byArray = tLVInputStream4.readValue();
                if (n3 != 24358) {
                    if (n3 != 24405) {
                        if (n3 != 24406) {
                            switch (n3) {
                                default: {
                                    throw new IllegalArgumentException("Unknown field tag in DG12: " + Integer.toHexString(n3));
                                }
                                case 24350: {
                                    this.parseImageOfRear(byArray);
                                    break;
                                }
                                case 24349: {
                                    this.parseImageOfFront(byArray);
                                    break;
                                }
                                case 24348: {
                                    this.parseTaxOrExitRequirements(byArray);
                                    break;
                                }
                                case 24347: {
                                    this.parseEndorsementsAndObservations(byArray);
                                    break;
                                }
                                case 24346: {
                                    this.parseNameOfOtherPerson(byArray);
                                    break;
                                }
                                case 24345: {
                                    this.parseIssuingAuthority(byArray);
                                    break;
                                }
                            }
                        } else {
                            this.parsePersonalizationSystemSerialNumber(byArray);
                        }
                    } else {
                        this.parseDateAndTimeOfPersonalization(byArray);
                    }
                } else {
                    this.parseDateOfIssue(byArray);
                }
            }
            return;
        }
        throw new IllegalArgumentException("Expected " + Integer.toHexString(n2) + ", but found " + Integer.toHexString(n3));
    }

    private void parsePersonalizationSystemSerialNumber(byte[] byArray) {
        try {
            this.personalizationSystemSerialNumber = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.personalizationSystemSerialNumber = new String(byArray).trim();
        }
    }

    private void parseDateAndTimeOfPersonalization(byte[] byArray) {
        try {
            this.dateAndTimeOfPersonalization = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
        }
    }

    private void parseImageOfFront(byte[] byArray) {
        this.imageOfFront = byArray;
    }

    private void parseImageOfRear(byte[] byArray) {
        this.imageOfRear = byArray;
    }

    private void parseTaxOrExitRequirements(byte[] byArray) {
        try {
            this.taxOrExitRequirements = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.taxOrExitRequirements = new String(byArray).trim();
        }
    }

    private void parseEndorsementsAndObservations(byte[] byArray) {
        try {
            this.endorsementsAndObservations = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.endorsementsAndObservations = new String(byArray).trim();
        }
    }

    private synchronized void parseNameOfOtherPerson(byte[] byArray) {
        String string;
        if (this.namesOfOtherPersons == null) {
            this.namesOfOtherPersons = new ArrayList<String>();
        }
        DG12File dG12File = this;
        String string2 = string;
        try {
            string = new String(byArray, "UTF-8");
            dG12File.namesOfOtherPersons.add(string2.trim());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.namesOfOtherPersons.add(new String(byArray).trim());
        }
    }

    private void parseDateOfIssue(byte[] byArray) {
        if (byArray != null) {
            if (byArray.length == 8) {
                try {
                    this.dateOfIssue = new String(byArray, "UTF-8").trim();
                    return;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
                }
            }
            LOGGER.warning("DG12 date of issue is not in expected ccyymmdd ASCII format");
            if (byArray.length == 4) {
                this.dateOfIssue = Hex.bytesToHexString((byte[])byArray).trim();
                return;
            }
            throw new IllegalArgumentException("Wrong date format");
        }
        throw new IllegalArgumentException("Wrong date format");
    }

    private void parseIssuingAuthority(byte[] byArray) {
        try {
            this.issuingAuthority = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.issuingAuthority = new String(byArray).trim();
        }
    }

    @Override
    public void readContent(InputStream inputStream) {
        Object object;
        if (inputStream instanceof TLVInputStream) {
            inputStream = (TLVInputStream)inputStream;
            object = inputStream;
        } else {
            TLVInputStream tLVInputStream;
            object = tLVInputStream;
            tLVInputStream = new TLVInputStream(inputStream);
        }
        if (object.readTag() == 92) {
            ArrayList<Integer> arrayList;
            ByteArrayInputStream byteArrayInputStream;
            int n2 = object.readLength();
            int n3 = 0;
            int n4 = n2 / 2;
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
            byteArrayInputStream = new ByteArrayInputStream(object.readValue());
            ArrayList<Integer> arrayList2 = arrayList;
            arrayList = new ArrayList<Integer>(n4 + 1);
            while (n3 < n2) {
                int n5 = n3;
                n3 = new TLVInputStream((InputStream)byteArrayInputStream2).readTag();
                n4 = n5 + TLVUtil.getTagLength((int)n3);
                arrayList2.add(n3);
                n3 = n4;
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                this.readField((Integer)iterator.next(), (TLVInputStream)object);
            }
            return;
        }
        throw new IllegalArgumentException("Expected tag list in DG12");
    }

    @Override
    public void writeContent(OutputStream iterator) {
        DataOutputStream dataOutputStream;
        Object object;
        if (iterator instanceof TLVOutputStream) {
            iterator = (TLVOutputStream)iterator;
            object = iterator;
        } else {
            TLVOutputStream tLVOutputStream;
            object = tLVOutputStream;
            tLVOutputStream = new TLVOutputStream((OutputStream)((Object)iterator));
        }
        object.writeTag(92);
        iterator = this.getTagPresenceList();
        DataOutputStream dataOutputStream2 = dataOutputStream;
        dataOutputStream = new DataOutputStream((OutputStream)object);
        Object object2 = iterator.iterator();
        while (object2.hasNext()) {
            dataOutputStream2.writeShort(object2.next());
        }
        dataOutputStream2.flush();
        object.writeValueEnd();
        iterator = iterator.iterator();
        block9: while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (n2 != 24358) {
                if (n2 != 24405) {
                    if (n2 != 24406) {
                        switch (n2) {
                            default: {
                                throw new IllegalArgumentException("Unknown field tag in DG12: " + Integer.toHexString(n2));
                            }
                            case 24350: {
                                object.writeTag(n2);
                                object.writeValue(this.imageOfRear);
                                continue block9;
                            }
                            case 24349: {
                                object.writeTag(n2);
                                object.writeValue(this.imageOfFront);
                                continue block9;
                            }
                            case 24348: {
                                object.writeTag(n2);
                                object.writeValue(this.taxOrExitRequirements.trim().getBytes("UTF-8"));
                                continue block9;
                            }
                            case 24347: {
                                object.writeTag(n2);
                                object.writeValue(this.endorsementsAndObservations.trim().getBytes("UTF-8"));
                                continue block9;
                            }
                            case 24346: {
                                if (this.namesOfOtherPersons == null) {
                                    this.namesOfOtherPersons = new ArrayList<String>();
                                }
                                Object object3 = object;
                                Object object4 = object;
                                object4.writeTag(160);
                                object4.writeTag(2);
                                object3.write(this.namesOfOtherPersons.size());
                                object3.writeValueEnd();
                                Iterator<String> iterator2 = this.namesOfOtherPersons.iterator();
                                while (iterator2.hasNext()) {
                                    Object object5 = object;
                                    object2 = iterator2.next();
                                    object5.writeTag(24346);
                                    object5.writeValue(((String)object2).trim().getBytes("UTF-8"));
                                }
                                object.writeValueEnd();
                                continue block9;
                            }
                            case 24345: 
                        }
                        object.writeTag(n2);
                        object.writeValue(this.issuingAuthority.trim().getBytes("UTF-8"));
                        continue;
                    }
                    object.writeTag(n2);
                    object.writeValue(this.personalizationSystemSerialNumber.trim().getBytes("UTF-8"));
                    continue;
                }
                object.writeTag(n2);
                object.writeValue(this.dateAndTimeOfPersonalization.getBytes("UTF-8"));
                continue;
            }
            object.writeTag(n2);
            object.writeValue(this.dateOfIssue.getBytes("UTF-8"));
        }
    }

    public List<Integer> getTagPresenceList() {
        List<Object> list = this.tagPresenceList;
        if (list != null) {
            return list;
        }
        this.tagPresenceList = new ArrayList<Integer>(10);
        if (this.issuingAuthority != null) {
            this.tagPresenceList.add(24345);
        }
        if (this.dateOfIssue != null) {
            this.tagPresenceList.add(24358);
        }
        if ((list = this.namesOfOtherPersons) != null && !list.isEmpty()) {
            this.tagPresenceList.add(24346);
        }
        if (this.endorsementsAndObservations != null) {
            this.tagPresenceList.add(24347);
        }
        if (this.taxOrExitRequirements != null) {
            this.tagPresenceList.add(24348);
        }
        if (this.imageOfFront != null) {
            this.tagPresenceList.add(24349);
        }
        if (this.imageOfRear != null) {
            this.tagPresenceList.add(24350);
        }
        if (this.dateAndTimeOfPersonalization != null) {
            this.tagPresenceList.add(24405);
        }
        if (this.personalizationSystemSerialNumber != null) {
            this.tagPresenceList.add(24406);
        }
        return this.tagPresenceList;
    }

    public String getIssuingAuthority() {
        return this.issuingAuthority;
    }

    public String getDateOfIssue() {
        return this.dateOfIssue;
    }

    public List<String> getNamesOfOtherPersons() {
        return this.namesOfOtherPersons;
    }

    public String getEndorsementsAndObservations() {
        return this.endorsementsAndObservations;
    }

    public String getTaxOrExitRequirements() {
        return this.taxOrExitRequirements;
    }

    public byte[] getImageOfFront() {
        return this.imageOfFront;
    }

    public byte[] getImageOfRear() {
        return this.imageOfRear;
    }

    public String getDateAndTimeOfPersonalization() {
        return this.dateAndTimeOfPersonalization;
    }

    public String getPersonalizationSystemSerialNumber() {
        return this.personalizationSystemSerialNumber;
    }

    @Override
    public int getTag() {
        return 108;
    }

    @Override
    public String toString() {
        CharSequence charSequence = new StringBuilder().append("DG12File [");
        Object object = ((DG12File)serializable).issuingAuthority;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG12File)serializable).dateOfIssue;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG12File)serializable).namesOfOtherPersons;
        object = object != null && !object.isEmpty() ? ((DG12File)serializable).namesOfOtherPersons : "";
        charSequence = charSequence.append(object).append(", ");
        object = ((DG12File)serializable).endorsementsAndObservations;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG12File)serializable).taxOrExitRequirements;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG12File)serializable).imageOfFront == null ? "" : "image (" + ((DG12File)serializable).imageOfFront.length + ")";
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG12File)serializable).imageOfRear == null ? "" : "image (" + ((DG12File)serializable).imageOfRear.length + ")";
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG12File)serializable).dateAndTimeOfPersonalization;
        if (object == null) {
            object = "";
        }
        DG12File dG12File = serializable;
        Serializable serializable = charSequence.append((String)object).append(", ");
        charSequence = dG12File.personalizationSystemSerialNumber;
        if (charSequence == null) {
            charSequence = "";
        }
        return ((StringBuilder)serializable).append((String)charSequence).append("]").toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == dG12File2) {
            return true;
        }
        if (!object.getClass().equals(DG12File.class)) {
            return false;
        }
        DG12File dG12File = dG12File2;
        DG12File dG12File2 = (DG12File)object;
        return dG12File.toString().equals(dG12File2.toString());
    }

    public int hashCode() {
        return this.toString().hashCode() * 13 + 112;
    }
}

