/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;
import org.jmrtd.APDULevelBACCapable;
import org.jmrtd.Util;

public class BACAPDUSender
implements APDULevelBACCapable {
    public static final Provider BC_PROVIDER = Util.getBouncyCastleProvider();
    public static final IvParameterSpec ZERO_IV_PARAM_SPEC = new IvParameterSpec(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
    public CardService service;
    public Cipher cipher;
    public Mac mac;

    public BACAPDUSender(CardService cardService) {
        BACAPDUSender bACAPDUSender = this;
        bACAPDUSender.service = cardService;
        try {
            bACAPDUSender.mac = Mac.getInstance("ISO9797Alg3Mac", BC_PROVIDER);
            bACAPDUSender.cipher = Util.getCipher("DESede/CBC/NoPadding");
            return;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Unexpected security exception during initialization", generalSecurityException);
        }
    }

    @Override
    public synchronized byte[] sendGetChallenge() {
        return this.sendGetChallenge(null);
    }

    public synchronized byte[] sendGetChallenge(APDUWrapper aPDUWrapper) {
        CommandAPDU commandAPDU;
        BACAPDUSender bACAPDUSender = bACAPDUSender2;
        BACAPDUSender bACAPDUSender2 = commandAPDU;
        commandAPDU = new CommandAPDU(0, -124, 0, 0, 8);
        return bACAPDUSender.service.transmit((CommandAPDU)bACAPDUSender2).getData();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized byte[] sendMutualAuth(byte[] byArray, byte[] byArray2, byte[] byArray3, SecretKey secretKey, SecretKey secretKey2) {
        block30: {
            void var6_16;
            short s2;
            block29: {
                CommandAPDU commandAPDU;
                CommandAPDU commandAPDU2;
                block28: {
                    block27: {
                        if (byArray == null) throw new IllegalArgumentException("rndIFD wrong length");
                        try {
                            if (byArray.length != 8) throw new IllegalArgumentException("rndIFD wrong length");
                            if (byArray2 == null) break block27;
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            throw new CardServiceException("Security exception during mutual auth", (Throwable)generalSecurityException);
                        }
                        if (byArray2.length == 8) break block28;
                    }
                    byArray2 = new byte[8];
                }
                if (byArray3 == null) throw new IllegalArgumentException("kIFD wrong length");
                if (byArray3.length != 16) throw new IllegalArgumentException("kIFD wrong length");
                if (secretKey == null) throw new IllegalArgumentException("kEnc == null");
                if (secretKey2 == null) throw new IllegalArgumentException("kMac == null");
                BACAPDUSender bACAPDUSender = object;
                byte[] byArray4 = byArray3;
                byte[] byArray5 = byArray2;
                byte[] byArray6 = byArray;
                Cipher cipher = ((BACAPDUSender)object).cipher;
                cipher.init(1, (Key)secretKey, ZERO_IV_PARAM_SPEC);
                byArray = new byte[32];
                System.arraycopy(byArray6, 0, byArray, 0, 8);
                System.arraycopy(byArray5, 0, byArray, 8, 8);
                System.arraycopy(byArray4, 0, byArray, 16, 16);
                byArray = bACAPDUSender.cipher.doFinal(byArray);
                if (byArray.length != 32) throw new IllegalStateException("Cryptogram wrong length " + byArray.length);
                BACAPDUSender bACAPDUSender2 = object;
                bACAPDUSender2.mac.init(secretKey2);
                byArray2 = bACAPDUSender2.mac.doFinal(Util.pad(byArray, 8));
                if (byArray2.length != 8) throw new IllegalStateException("MAC wrong length");
                int n2 = 0;
                int n3 = 0;
                byArray3 = new byte[40];
                System.arraycopy(byArray, 0, byArray3, 0, 32);
                System.arraycopy(byArray2, 0, byArray3, 32, 8);
                int n4 = 40;
                CommandAPDU commandAPDU3 = commandAPDU2;
                commandAPDU2 = new CommandAPDU(0, -126, 0, 0, byArray3, n4);
                ResponseAPDU responseAPDU = ((BACAPDUSender)object).service.transmit(commandAPDU3);
                if (responseAPDU == null) throw new CardServiceException("Mutual authentication failed, received null response APDU");
                byte[] byArray7 = responseAPDU.getBytes();
                s2 = (short)responseAPDU.getSW();
                if (byArray7 == null) throw new CardServiceException("Mutual authentication failed, received empty data in response APDU", (int)s2);
                if (s2 == -28672) break block29;
                s2 = 0;
                CommandAPDU commandAPDU4 = commandAPDU;
                commandAPDU = new CommandAPDU(0, -126, n2, n3, byArray3, (int)s2);
                ResponseAPDU responseAPDU2 = ((BACAPDUSender)object).service.transmit(commandAPDU4);
                ResponseAPDU responseAPDU3 = responseAPDU2;
                byte[] byArray8 = responseAPDU2.getBytes();
                s2 = (short)responseAPDU3.getSW();
            }
            if (((void)var6_16).length != 42) throw new CardServiceException("Mutual authentication failed: expected length: 40 + 2, actual length: " + ((void)var6_16).length, (int)s2);
            BACAPDUSender bACAPDUSender = object;
            BACAPDUSender bACAPDUSender3 = bACAPDUSender;
            Cipher cipher = bACAPDUSender.cipher;
            cipher.init(2, (Key)secretKey, ZERO_IV_PARAM_SPEC);
            Cipher cipher2 = bACAPDUSender3.cipher;
            int n5 = ((void)var6_16).length;
            byte[] byArray9 = cipher2.doFinal((byte[])var6_16, 0, n5 - 8 - 2);
            Object object = byArray9;
            if (byArray9.length != 32) break block30;
            return object;
        }
        throw new IllegalStateException("Cryptogram wrong length " + ((Object)object).length);
    }
}

