/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import net.sf.scuba.util.Hex;
import org.jmrtd.Util;
import org.jmrtd.protocol.SecureMessagingWrapper;

public class EACCAResult
implements Serializable {
    public static final long serialVersionUID = 4431711176589761513L;
    public BigInteger keyId;
    public PublicKey piccPublicKey;
    public SecureMessagingWrapper wrapper;
    public byte[] keyHash;
    public PublicKey pcdPublicKey;
    public PrivateKey pcdPrivateKey;

    public EACCAResult(BigInteger bigInteger, PublicKey publicKey, byte[] byArray, PublicKey publicKey2, PrivateKey privateKey, SecureMessagingWrapper secureMessagingWrapper) {
        this.keyId = bigInteger;
        this.piccPublicKey = publicKey;
        this.keyHash = byArray;
        this.pcdPublicKey = publicKey2;
        this.pcdPrivateKey = privateKey;
        this.wrapper = secureMessagingWrapper;
    }

    public BigInteger getKeyId() {
        return this.keyId;
    }

    public PublicKey getPublicKey() {
        return this.piccPublicKey;
    }

    public SecureMessagingWrapper getWrapper() {
        return this.wrapper;
    }

    public String toString() {
        return "CAResult [keyId: " + this.keyId + ", PICC public key: " + this.piccPublicKey + ", wrapper: " + this.wrapper + ", key hash: " + Hex.bytesToHexString((byte[])this.keyHash) + ", PCD public key: " + Util.getDetailedPublicKeyAlgorithm(this.pcdPublicKey) + ", PCD private key: " + Util.getDetailedPrivateKeyAlgorithm(this.pcdPrivateKey) + "]";
    }

    public int hashCode() {
        EACCAResult eACCAResult = this;
        int n2 = (31 + Arrays.hashCode(eACCAResult.keyHash)) * 31;
        BigInteger bigInteger = eACCAResult.keyId;
        int n3 = bigInteger == null ? 0 : bigInteger.hashCode();
        n2 = (n2 + n3) * 31;
        PublicKey publicKey = this.piccPublicKey;
        int n4 = publicKey == null ? 0 : publicKey.hashCode();
        n2 = (n2 + n4) * 31;
        PublicKey publicKey2 = this.pcdPublicKey;
        int n5 = publicKey2 == null ? 0 : publicKey2.hashCode();
        n2 = (n2 + n5) * 31;
        PrivateKey privateKey = this.pcdPrivateKey;
        int n6 = privateKey == null ? 0 : privateKey.hashCode();
        int n7 = (n2 + n6) * 31;
        SecureMessagingWrapper secureMessagingWrapper = this.wrapper;
        int n8 = secureMessagingWrapper == null ? 0 : secureMessagingWrapper.hashCode();
        return n7 + n8;
    }

    public boolean equals(Object object) {
        if (serializable2 == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (EACCAResult.class != object.getClass()) {
            return false;
        }
        object = (EACCAResult)object;
        if (!Arrays.equals(((EACCAResult)serializable2).keyHash, ((EACCAResult)object).keyHash)) {
            return false;
        }
        Serializable serializable = ((EACCAResult)serializable2).keyId;
        if (serializable == null ? ((EACCAResult)object).keyId != null : !((BigInteger)serializable).equals(((EACCAResult)object).keyId)) {
            return false;
        }
        serializable = ((EACCAResult)serializable2).pcdPrivateKey;
        if (serializable == null ? ((EACCAResult)object).pcdPrivateKey != null : !serializable.equals(((EACCAResult)object).pcdPrivateKey)) {
            return false;
        }
        serializable = ((EACCAResult)serializable2).pcdPublicKey;
        if (serializable == null ? ((EACCAResult)object).pcdPublicKey != null : !serializable.equals(((EACCAResult)object).pcdPublicKey)) {
            return false;
        }
        serializable = ((EACCAResult)serializable2).piccPublicKey;
        if (serializable == null ? ((EACCAResult)object).piccPublicKey != null : !serializable.equals(((EACCAResult)object).piccPublicKey)) {
            return false;
        }
        Serializable serializable2 = ((EACCAResult)serializable2).wrapper;
        return !(serializable2 == null ? ((EACCAResult)object).wrapper != null : !serializable2.equals(((EACCAResult)object).wrapper));
    }

    public byte[] getKeyHash() {
        return this.keyHash;
    }

    public PublicKey getPCDPublicKey() {
        return this.pcdPublicKey;
    }

    public PrivateKey getPCDPrivateKey() {
        return this.pcdPrivateKey;
    }
}

