/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;
import net.sf.scuba.util.Hex;
import org.jmrtd.APDULevelReadBinaryCapable;
import org.jmrtd.protocol.SecureMessagingAPDUSender;

public class ReadBinaryAPDUSender
implements APDULevelReadBinaryCapable {
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd.protocol");
    public SecureMessagingAPDUSender secureMessagingSender;
    public CardService service;

    public ReadBinaryAPDUSender(CardService cardService) {
        ReadBinaryAPDUSender readBinaryAPDUSender = this;
        readBinaryAPDUSender.service = cardService;
        readBinaryAPDUSender.secureMessagingSender = new SecureMessagingAPDUSender(cardService);
    }

    public static byte[] getResponseData(ResponseAPDU object, boolean bl) {
        if (object == null) {
            return null;
        }
        byte[] byArray = object.getData();
        object = byArray;
        if (byArray != null) {
            if (!bl) {
                return object;
            }
            bl = true;
            if (object[0] == 83) {
                if ((byte)(object[bl] & 0x80) == -128) {
                    bl += object[bl] & 0xF;
                }
                byte[] byArray2 = new byte[((ResponseAPDU)object).length - (bl += 1)];
                System.arraycopy(object, bl ? 1 : 0, byArray2, 0, byArray2.length);
                return byArray2;
            }
            throw new CardServiceException("Malformed read binary long response data");
        }
        throw new CardServiceException("Malformed read binary long response data");
    }

    public static void checkStatusWordAfterFileOperation(CommandAPDU object, ResponseAPDU responseAPDU) {
        short s2 = (short)responseAPDU.getSW();
        object = "CAPDU = " + Hex.bytesToHexString((byte[])object.getBytes()) + ", RAPDU = " + Hex.bytesToHexString((byte[])responseAPDU.getBytes());
        switch (s2) {
            default: {
                throw new CardServiceException("Error occured, " + (String)object, (int)s2);
            }
            case 27266: {
                throw new CardServiceException("File not found, " + (String)object, (int)s2);
            }
            case 27010: 
            case 27013: 
            case 27014: {
                throw new CardServiceException("Access to file denied, " + (String)object, (int)s2);
            }
            case -28672: 
        }
    }

    @Override
    public synchronized void sendSelectApplet(APDUWrapper aPDUWrapper, byte[] byArray) {
        if (byArray != null) {
            CommandAPDU commandAPDU;
            CommandAPDU commandAPDU2 = commandAPDU;
            commandAPDU2(0, -92, 4, 12, byArray);
            ReadBinaryAPDUSender.checkStatusWordAfterFileOperation(commandAPDU, this.secureMessagingSender.transmit(aPDUWrapper, commandAPDU2));
            return;
        }
        throw new IllegalArgumentException("AID cannot be null");
    }

    @Override
    public synchronized void sendSelectFile(APDUWrapper aPDUWrapper, short s2) {
        CommandAPDU commandAPDU;
        ReadBinaryAPDUSender readBinaryAPDUSender = object;
        byte[] byArray = new byte[2];
        Object object = byArray;
        object[0] = (byte)(s2 >> 8 & 0xFF);
        byArray[1] = (byte)(s2 & 0xFF);
        CommandAPDU commandAPDU2 = commandAPDU;
        commandAPDU = new CommandAPDU(0, -92, 2, 12, (byte[])object, 0);
        object = readBinaryAPDUSender.secureMessagingSender.transmit(aPDUWrapper, commandAPDU2);
        if (object != null) {
            ReadBinaryAPDUSender.checkStatusWordAfterFileOperation(commandAPDU2, (ResponseAPDU)object);
        }
    }

    @Override
    public synchronized byte[] sendReadBinary(APDUWrapper object, int n2, int n3, int n4, boolean bl, boolean bl2) {
        CardServiceException cardServiceException2;
        block14: {
            short s2;
            Object object2;
            ResponseAPDU responseAPDU = null;
            if (n4 == 0) {
                return null;
            }
            int n5 = n3;
            n3 = (byte)((n5 & 0xFF00) >> 8);
            byte by = (byte)(n5 & 0xFF);
            if (bl2) {
                CommandAPDU commandAPDU;
                if (n4 < 128) {
                    n4 += 2;
                } else if (n4 < 256) {
                    n4 += 3;
                }
                if (n4 > 256) {
                    n4 = 256;
                }
                byte[] byArray = new byte[4];
                object2 = byArray;
                byArray[0] = 84;
                byArray[1] = 2;
                byArray[2] = n3;
                byArray[3] = by;
                CommandAPDU commandAPDU2 = commandAPDU;
                commandAPDU = new CommandAPDU(0, -79, 0, 0, (byte[])object2, n4);
                object2 = commandAPDU2;
            } else if (bl) {
                CommandAPDU commandAPDU;
                CommandAPDU commandAPDU3 = commandAPDU;
                n2 = (byte)n2;
                commandAPDU = new CommandAPDU(0, -80, n2, (int)by, n4);
                object2 = commandAPDU3;
            } else {
                CommandAPDU commandAPDU;
                object2 = commandAPDU;
                commandAPDU = new CommandAPDU(0, -80, n3, (int)by, n4);
            }
            responseAPDU = this.secureMessagingSender.transmit((APDUWrapper)object, (CommandAPDU)object2);
            try {
                s2 = (short)responseAPDU.getSW();
            }
            catch (CardServiceException cardServiceException2) {
                if (this.service.isConnectionLost((Exception)((Object)cardServiceException2))) break block14;
                LOGGER.log(Level.FINE, "Exception during READ BINARY", cardServiceException2);
                s2 = (short)cardServiceException2.getSW();
            }
            byte[] byArray = ReadBinaryAPDUSender.getResponseData(responseAPDU, bl2);
            object = byArray;
            if (byArray != null && ((APDUWrapper)object).length != 0) {
                ReadBinaryAPDUSender.checkStatusWordAfterFileOperation(object2, responseAPDU);
            } else {
                LOGGER.warning("Empty response data: rapduBytes = " + Arrays.toString((byte[])object) + ", le = " + n4 + ", sw = " + Integer.toHexString(s2));
            }
            return object;
        }
        throw cardServiceException2;
    }
}

