/*
 * Decompiled with CFR 0.152.
 */
package net.security.device.api.id.oaid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.Parcel;
import net.security.device.api.LogUtil;
import net.security.device.api.id.IOAID;
import net.security.device.api.id.IOAIDGetter;

public class AsusImpl
implements IOAID {
    private final Context context;

    public AsusImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        if (this.context == null) {
            return false;
        }
        try {
            PackageManager pm = this.context.getPackageManager();
            if (pm != null) {
                PackageInfo pi = pm.getPackageInfo("com.asus.msa.SupplementaryDID", 0);
                return pi != null;
            }
        }
        catch (Exception e) {
            LogUtil.e(e.toString());
        }
        return false;
    }

    @Override
    public void doGet(final IOAIDGetter getter) {
        if (this.context == null) {
            getter.onOAIDGetError(new NullPointerException("OAID context is null"));
            return;
        }
        Intent intent = new Intent("com.asus.msa.action.ACCESS_DID");
        ComponentName componentName = new ComponentName("com.asus.msa.SupplementaryDID", "com.asus.msa.SupplementaryDID.SupplementaryDIDService");
        intent.setComponent(componentName);
        try {
            boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    LogUtil.d("ASUS SupplementaryDIDService connected");
                    try {
                        Parcel v1 = Parcel.obtain();
                        Parcel v2 = Parcel.obtain();
                        try {
                            String oaid = null;
                            v1.writeInterfaceToken("com.asus.msa.SupplementaryDID.IDidAidlInterface");
                            if (service.transact(3, v1, v2, 0)) {
                                v2.readException();
                                oaid = v2.readString();
                            }
                            if (oaid == null || oaid.length() == 0) {
                                throw new RuntimeException("ASUS ID get failed");
                            }
                            getter.onOAIDGetComplete(oaid);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        finally {
                            v1.recycle();
                            v2.recycle();
                            AsusImpl.this.context.unbindService((ServiceConnection)this);
                        }
                    }
                    catch (Exception e) {
                        LogUtil.e(e.toString());
                        getter.onOAIDGetError(e);
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    LogUtil.d("ASUS SupplementaryDIDService disconnected");
                }
            }, 1);
            if (!isBinded) {
                throw new RuntimeException("ASUS SupplementaryDIDService bind failed");
            }
        }
        catch (Exception e) {
            getter.onOAIDGetError(e);
        }
    }
}

